/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT
	P.fullName as package_name,
	C.name as class_name,
	sig.signature as function_signature,
	func.numberOfLines as number_of_lines,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM
	TFunctions func
INNER JOIN
	TSignatures sig on func.id = sig.functionid
INNER JOIN
	TModelElements elem on func.id = elem.id
INNER JOIN
	TConstants cElem on (cElem.value = elem.status and cElem.name = 'STATUS_NORMAL')
LEFT OUTER JOIN
	TTypes C on elem.ParentId = C.id
LEFT OUTER JOIN
	TPackages P on
		C.PackageId = P.id 
		OR elem.parentId = P.id
LEFT OUTER JOIN	
	TSourceEntities sourceEntities on (func.id = sourceEntities.id) left outer join
	TFiles files on (sourceEntities.sourcefileid = files.id) 
WHERE
	func.numberOfLines > 200 /* SCHWELLWERT */
ORDER BY
	func.numberOfLines DESC
;
