/* $Id: MiniClass.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

CREATE TABLE VClassMethods(
	TypeId INTEGER,
	TypeName VARCHAR(1024),
	classid INTEGER,
	noContainedFunctions INTEGER)
;

INSERT INTO VClassMethods (TypeId, TypeName, classid, noContainedFunctions)
SELECT 
	type.id, 
	type.fullName,
	type.classid,
	count(distinct func.id)
FROM
	TTypes as type left outer join
	TFunctions as func on type.id = func.classId left outer join
	TSourceEntities sFunc on (sFunc.id = func.id) join
	TFiles fFunc on (sFunc.sourcefileid = fFunc.id) join
	TConstants cFile on (fFunc.kindOfFile = cFile.value) join
	TConstants as con on func.kindOfFunction = con.value join 
	TModelElements as mType on (mType.id = type.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name ='STATUS_NORMAL') 
WHERE
	cFile.name = 'FILE_SOURCE' AND
		(con.name = 'FUNC_METHOD' OR
		 con.name = 'FUNC_CONSTRUCTOR' OR
		 con.name = 'FUNC_DESTRUCTOR')
GROUP BY
	type.id,
	type.fullName,
	type.classid
;

create index TClassMethodsIndex on VClassMethods (TypeId, TypeName, Classid);

CREATE TABLE VClassFields(
	TypeId INTEGER,
	TypeName VARCHAR(1024),
	classid INTEGER,
	noContainedFields INTEGER)
;

INSERT INTO VClassFields (TypeId, TypeName, classid, noContainedFields)
SELECT 
	type.id, 
	type.fullName,
	type.classid,
	count(distinct field.id) 
FROM
	TTypes as type left outer join
	TVariables as field on type.id = field.classId join
	TConstants as con on field.kindOfVariable = con.value and
		(con.name like 'VAR_FIELD' or
		con.name like 'VAR_PROPERTY') join
	TModelElements as mType on (mType.id = type.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name ='STATUS_NORMAL') 
WHERE
	field.name <> '<self>'
GROUP BY
	type.id,
	type.fullName,
	type.classid
;

create index TClassFieldsIndex on VClassFields (TypeId, TypeName, Classid);

Select
        p.fullname as package_full_name,
	type.fullName as class_full_name,
        file.pathname as file_name,
	res2.noContainedFunctions as number_of_contained_functions,
	res3.noContainedFields as number_of_contained_fields
FROM
	TTypes as type join
	TModelElements as meType on (meType.id = type.id) join
	TConstants cmeType on (cmeType.value = meType.status and cmeType.name ='STATUS_NORMAL') join
	TMembers mType on (mType.id = type.id) left outer join
	TConstants con2 on (type.kindoftype = con2.value) left outer join
	TConstants con on (mType.visibility = con.value) left outer join
	VClassMethods as res2 on (type.id = res2.TypeID) left outer join
	VClassFields as res3 on type.id = res3.TypeID join
	TSourceEntities source on (type.id = source.id) join
	TFiles file on (source.sourcefileid = file.id) left outer join
        TPackages p on p.id = type.packageid
WHERE
	con2.name = 'TYPE_CLASS' AND	
	/* Keine inneren Klassen */
	type.classid = -1 AND
	/* Nur ffentliche Klassen */
	con.name = 'VISIBILITY_PUBLIC'

EXCEPT	

/* Die Klassen mit mehr als zwei Methoden oder Attributen ausschlieen */

Select
        p.fullname as package_full_name,
	type.fullName as class_full_name,
        file.pathname as file_name,
	res2.noContainedFunctions as number_of_contained_functions,
	res3.noContainedFields as number_of_contained_fields
FROM
	TTypes as type join
	TModelElements as meType on (meType.id = type.id) join
	TConstants cmeType on (cmeType.value = meType.status and cmeType.name ='STATUS_NORMAL') join
	TMembers mType on (mType.id = type.id) left outer join
	TConstants con2 on (type.kindoftype = con2.value) left outer join
	TConstants con on (mType.visibility = con.value) left outer join
	VClassMethods as res2 on (type.id = res2.TypeID) left outer join
	VClassFields as res3 on type.id = res3.TypeID join
	TSourceEntities source on (type.id = source.id) join
	TFiles file on (source.sourcefileid = file.id) left outer join
        TPackages p on p.id = type.packageid
WHERE
	con2.name = 'TYPE_CLASS' AND
	(res2.noContainedFunctions > 2 OR res3.noContainedFields > 2) 
	AND
	/* Keine inneren Klassen */
	type.classid = -1 AND
	/* Nur ffentliche Klassen */
	con.name = 'VISIBILITY_PUBLIC'
;

drop table VClassFields;
drop table VClassMethods;


