/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

select
	res.class_name,
	res.attribute_name,
	files.pathname as file_name,
	srcEnt.startLine as line_number		
from	(	
	SELECT DISTINCT 
		C.id as class_id,
		C.fullName AS class_name, 
		a.name As attribute_name
	FROM 
		TTypes As C join 
		TModelElements m on (C.id = m.id) join
		TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join
		TVariables AS v on (v.classId = C.id) join
		TMembers As a on (a.id = v.id) join
		TConstants AS constField  on (v.kindOfVariable = constField.Value) join
		TConstants AS constPrivate on (a.visibility = constPrivate.Value)
	WHERE 
		/* private attributes of C */
		constField.name = 'VAR_FIELD' AND 
		constPrivate.name = 'VISIBILITY_PRIVATE' AND
		a.name <> '<self>'

	/* take out those that have accesses */
	EXCEPT

	SELECT DISTINCT 
		C.id as class_id,
		C.fullName AS class_name, 
		a.name As attribute_name
	FROM 
		TTypes As C join 
		TVariables AS v on (v.classId = C.id) join
		TMembers As a on (a.id = v.id) join
		TConstants AS constField  on (v.kindOfVariable = constField.Value) join
		TConstants AS constPrivate on (a.visibility = constPrivate.Value) join
		TAccesses AS acc on ( acc.targetId = v.id) join
		TFunctions AS accBelongsToFunction on (acc.functionid = accBelongsToFunction.id) join
		TConstants AS funcType on (funcType.value = accBelongsToFunction.kindoffunction)
	WHERE 
		/* private attributes of C */
		constField.name = 'VAR_FIELD' AND 
		constPrivate.name = 'VISIBILITY_PRIVATE' 

		AND

		/* Not accessed from own initializer */
		((funcType.name = 'FUNC_INITIALIZER' AND accBelongsToFunction.name <> v.name) OR funcType.name <> 'FUNC_INITIALIZER')
	) as res left outer join
	TSourceEntities srcEnt on (res.class_id = srcEnt.id) left outer join
	TFiles files on (srcEnt.sourceFileId = files.id)
;
