/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VFileImportsFileCPP (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256));

insert into VFileImportsFileCPP 
select 
	f.id as fileid,
	f.pathname as filename,
	f2.id as knownfileid,
	f2.pathname as knownfilename
from
	TFiles f join
	TModelElements m on (f.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TImports imp on (imp.fileid = f.id) join
	TFiles f2 on (imp.targetid = f2.id) join
	TModelElements m2 on (f2.id = m2.id) join
	TConstants cm2 on (cm2.value = m2.status and cm2.name = 'STATUS_NORMAL') 	
where
	f.id <> f2.id
	
;


create table VFileImportsFileJAVA (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256));

insert into VFileImportsFileJAVA 
select 
	f.id as fileid,
	f.pathname as filename,
	f2.id as knownfileid,
	f2.pathname as knownfilename
from
	TFiles f join
	TModelElements m on (f.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TImports imp on (imp.fileid = f.id) join
	TTypes type on (imp.targetid = type.id) join
	TSourceEntities s on (s.id = type.id) join
	TFiles f2 on (s.sourcefileid = f2.id) join
	TModelElements m2 on (f2.id = m2.id) join
	TConstants cm2 on (cm2.value = m2.status and cm2.name = 'STATUS_NORMAL') 	
where
	f.id <> f2.id
	
;

create table VKnowsRel (classId int, className varchar(256), knownClassId int, knownClassName varchar(256) );

insert into VKnowsRel
select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union
	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types, 
	TConstants as c
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	types.kindOfType = c.value and
	(c.name like '%CLASS' or 
		c.name like '%INTERFACE')
;

create table VFileKnowsFileByClass (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256) );

insert into VFileKnowsFileByClass
select
	sourceFile.id as fileid,
	sourceFile.pathname as filename,
	targetFile.id as knownfileid,
	targetFile.pathname as knownfilename
from
	VKnowsRel knows,
	TSourceEntities source,
	TFiles	sourceFile,
	TSourceEntities target,
	TFiles targetFile
where
	knows.classid = source.id
	AND source.sourcefileid = sourceFile.id
	AND knows.knownClassid = target.id
	AND target.sourcefileid = targetFile.id
;

/* Datei benutzt andere Datei ber globale Funktionen oder Variablen */

create table VGlobalDeps (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256) );

insert into VGlobalDeps
Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	funcFile.id as knownfileid,
	funcFile.pathname as knownfilename
FROM
	TAccesses ac,
	TFunctions accessedFunction,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities funcSource,
	TFiles funcFile
WHERE
	ac.targetid = accessedFunction.id
	AND accessedFunction.classid = -1
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND funcSource.id = accessedFunction.id
	AND funcSource.sourcefileid = funcFile.id

UNION

Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	varFile.id as knownfileid,
	varFile.pathname as knownfilename
FROM
	TAccesses ac,
	TVariables accessedVariable,
	TConstants con,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities varSource,
	TFiles varFile
WHERE
	con.value = accessedVariable.kindofvariable
	AND con.name = 'VAR_GLOBALVAR'
	AND ac.targetid = accessedVariable.id
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND varSource.id = accessedVariable.id
	AND varSource.sourcefileid = varFile.id

;

create table TFileKnowsFile (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256) );

insert into TFileKnowsFile
SELECT * FROM VFileKnowsFileByClass
	UNION
SELECT * FROM 	VGlobalDeps
	UNION
SELECT * FROM 	VFileImportsFileJAVA
	UNION
SELECT * FROM 	VFileImportsFileJAVA
	
;


SELECT
	one.filename as file_name_1,
	one.knownfilename as file_name_2
FROM
	TFileKnowsFile one,
	TFileKnowsFile two,
	TModelElements mOne,
	TConstants cmOne
WHERE
	mOne.id = one.fileid
	AND cmOne.value = mOne.status
	AND cmOne.name = 'STATUS_NORMAL'
	AND one.fileid = two.knownfileid
	AND two.fileid = one.knownfileid
	AND one.fileid < two.fileid
;

DROP TABLE VFileImportsFileCPP;
DROP TABLE TFileKnowsFile;
DROP table VFileKnowsFileByClass;
DROP TABLE VKnowsRel;
DROP TABLE VGlobalDeps;
DROP TABLE VFileImportsFileJAVA;
