create table VKnowsRel (classId int, className varchar(256), knownClassId int, knownClassName varchar(256));

insert into VKnowsRel 
select distinct res.classId, res.className,
	res.knownClassId, res.knownClassName
from (
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TConstants con, TAccesses acc,
	TTypes cls, TTypes knowncls
where	con.name = 'TYPEACCESS_INHERITANCE' and
	con.value = acc.kindOfAccess and
	acc.sourceId = cls.id and
	acc.targetId = knowncls.id

union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
union

/* Exception declarations and casts */
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TConstants con, TAccesses acc, TTypes cls,
	TMembers m, TTypes knowncls
where	(con.name = 'TYPEACCESS_THROW' or
		con.name = 'TYPEACCESS_CAST') and
	con.value = acc.kindOfAccess and
	acc.functionId = m.id and
	m.classId = cls.id and
	acc.targetId = knowncls.id

union

/* Attributes and properties */
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TTypes as cls, TMembers as m,
	TVariables as var, TAccesses as acc,
	TTypes knowncls
where	cls.id = m.classId and
	m.id = var.id and
	var.typeDeclarationId = acc.id and
	acc.targetId = knowncls.id

union

/* Formal parameters, catch parameters and local variables */
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TTypes as cls, TMembers as m,
	TVariables as var, TAccesses as acc,
	TTypes knowncls
where	cls.id = m.classId and
	m.id = var.functionId and
	var.typeDeclarationId = acc.id and
	acc.targetId = knowncls.id

union
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TTypes as cls, TMembers as m,
	TFunctions as func, TAccesses as acc,
	TTypes knowncls
where	cls.id = m.classId and
	m.id = func.id and
	func.returnTypeDeclarationId = acc.id and
	acc.targetId = knowncls.id
union
select distinct	cls.id as ClassId, cls.fullName as ClassName,
	knowncls.id as KnownClassId, knowncls.fullName as KnownClassName
from	TTypes as cls, TMembers as sm,
	TAccesses acc, TMembers as dm, TTypes knowncls
where	cls.id = sm.classId and
	acc.functionId = sm.id and
	acc.targetId = dm.id and
	dm.classId = knowncls.id
) res 
join TTypes as types on res.knownClassId = types.id 
join TConstants as c on types.kindOfType = c.value
where res.classId != res.knownClassId and (c.name like '%CLASS' or c.name like '%INTERFACE');


SELECT DISTINCT
	class1.fullName AS class_name_1, 
	class2.fullName AS class_name_2,
	class1file.pathname as file_name_1,
	class1source.startline as line_number_1,
	class2file.pathname as file_name_2,
	class2source.startline as line_number_2	
FROM 
	TTypes class1, 
	TTypes class2, 
	TModelElements mF1,
	TModelElements mF2,
	TConstants cmF1,
	TConstants cmF2,
	VKnowsRel vKnowsRel, 
	VKnowsRel vKnowsRel2,
	TSourceEntities class1source,
	TFiles	class1file,
	TSourceEntities class2source,
	TFiles class2file

WHERE 
	class1.id = mF1.id
	AND cmF1.value = mF1.status
	AND cmF1.name = 'STATUS_NORMAL'	

	AND class2.id = mF2.id
	AND cmF2.value = mF2.status
	AND cmF2.name = 'STATUS_NORMAL'	


	AND vknowsRel.classId = class1.id AND 
	vknowsRel.knownClassId = class2.id AND
	vknowsRel2.classId = class2.id AND
	vknowsRel2.knownClassId = class1.id AND
	class1source.id = class1.id AND
	class1source.sourcefileid = class1file.id AND
	class2source.id = class2.id AND
	class2source.sourcefileid = class2file.id AND
	class1.id < class2.id
	
	/* No inheritance relation between classes */
	AND NOT EXISTS (
	SELECT
		inherits.classid 
	FROM
		TInheritances inherits
	WHERE
		(inherits.classid = class1.id AND inherits.superid = class2.id) OR
		(inherits.classid = class2.id AND inherits.superid = class1.id)

	UNION

	/* No inner class relation between classes */
	SELECT
		tcr.classid
	FROM
		TClassContainmentRelations tcr
	WHERE
		(class1.id = tcr.classid	AND	class2.id = tcr.containingclassid)
		OR (class2.id = tcr.classid	AND	class1.id = tcr.containingclassid)
	)


;

drop table VKnowsRel;


