/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VHiddenAttributes (attribute_id int, class_id int, class_fullname varchar(256), attribute_name varchar(256), number_of_overwrites int);

insert into VHiddenAttributes
SELECT 
	membSuperAttr.id as attribute_id,
	meSuperClass.id as class_id,
	meSuperClass.fullname AS class_fullname,
	membSuperAttr.name AS attribute_name,
	COUNT (membSubAttr.id) AS number_of_overwrites	
FROM 
	TTypes meSubClass join
	TModelElements mMeSubClass on (meSubClass.id = mMeSubClass.id) join
	TConstants con1 on (con1.value = mMeSubClass.status and con1.name = 'STATUS_NORMAL') join
	TInheritances inh on (inh.classId = meSubClass.id) join
	TTypes meSuperClass on (inh.superId = meSuperClass.id) join 
	TModelElements mMeSuperClass on (meSuperClass.id = mMeSuperClass.id) join
	TConstants con2 on (con2.value = mMeSuperClass.status and con2.name = 'STATUS_NORMAL') join
	TMembers membSubAttr on (membSubAttr.classId = meSubClass.id) join 
	TMembers membSuperAttr on (membSuperAttr.classId = meSuperClass.id AND membSubAttr.name = membSuperAttr.name) join  
	TConstants tcAttr on (	membSuperAttr.kindOfMember = tcAttr.value AND membSubAttr.kindOfMember = tcAttr.value)

WHERE	
	tcAttr.name = 'VAR_FIELD' and
	membSuperAttr.isstatic = 0 and
	membSuperAttr.name <> '<self>'

GROUP BY
	membSuperAttr.id,
	meSuperClass.id,
	meSuperClass.fullname,
	membSuperAttr.name	
;


SELECT
	hiddenAttributes.class_fullname,
	hiddenAttributes.attribute_name,
	hiddenAttributes.number_of_overwrites,
	files.pathname as file_name,
	srcEnt.startLine as line_number	
FROM
	VHiddenAttributes as hiddenAttributes join
	TSourceEntities srcEnt on (hiddenAttributes.attribute_id = srcEnt.id) left outer join
	TFiles files on (srcEnt.sourceFileId = files.id)
;

drop table VHiddenAttributes;
