/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	pack.fullname as package_name,
	type.name as class_name,
	sig.signature as function_signature,
	con.name as deadcode_after_statement_type,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
	
FROM
	TStatements exitStatement join
	TStatements nextStatement on (nextStatement.parentStatementid = exitStatement.parentStatementid) join
	TStatements parentStatement on (exitStatement.parentStatementid = parentStatement.id) join
	TConstants con2 on (parentStatement.kindofstatement = con2.value) join
	TConstants con on (exitStatement.kindofstatement = con.value) join
	TFunctions func on (exitStatement.functionid = func.id) join
	TModelElements m on (func.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join
	TSignatures sig on sig.functionid = func.id left outer join
	TTypes type on (func.classid = type.id) left outer join
	TPackages pack on (func.packageid = pack.id) left outer join
	TSourceEntities sourceEntities on (func.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) 

WHERE
	(con.name = 'STATEMENT_RETURN' OR
	con.name = 'STATEMENT_THROW' ) AND
	nextStatement.position > exitStatement.position AND
	con2.name = 'STATEMENT_BLOCK' AND
	type.name <> ''
;
