/* $Id: RisikoCode.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


CREATE OR REPLACE VIEW VNumberOfSourceStatementsPerBranch AS

SELECT
	branchStatement.id,
	COUNT(branchStatement.Id)
FROM
	TStatements branchStatement join
	TStatements childStatement on (childStatement.parentStatementid = branchStatement.id and
		branchStatement.kindofStatement = 76 /*STATEMENT_BRANCH*/) join
	TSourceEntities se on (se.id = childStatement.id)
GROUP BY
	branchStatement.id
;

SELECT DISTINCT
	'EMPTYCATCHBLOCK' as reason,
        p.fullname as package_full_name,
        C.fullname as class_full_name,
        sig.signature as signature,
        files.pathname AS file_name
FROM
	TStatements AS ecb,
	TModelElements AS mECB,
	TFunctions AS f,
	TTypes AS C,
	TSourceEntities sourceEntities,
	TFiles files,
        TSignatures sig,
        TPackages p

WHERE
	mECB.id = ecb.id 
	AND mECB.status = 161 /*STATUS_NORMAL*/

	/* look for catch blocks */
	AND ecb.kindOfStatement = 79 /*STATEMENT_CATCHBLOCK*/ AND
	
	/* some joins */
	ecb.functionId = f.id AND
	f.classId = C.id AND

	C.id = sourceEntities.id AND
	sourceEntities.sourcefileid = files.id AND

        sig.functionid = f.id AND
        
        p.id = C.packageid

/* take out non-empty catch blocks */
EXCEPT

SELECT DISTINCT
	'EMPTYCATCHBLOCK' as reason,
        p.fullname as package_full_name,
        C.fullname as class_full_name,
        sig.signature as signature,
	files.pathname AS file_name
FROM
	TStatements AS ecb,
	TStatements AS ecbMemberStatement,
	TFunctions AS f,
	TTypes AS C,
	TSourceEntities sourceEntities,
        TSignatures sig,
	TFiles files,
        TPackages p

WHERE
	/* look for catch blocks */
	ecb.kindOfStatement = 79 /*STATEMENT_CATCHBLOCK*/ AND

	/* some joins */
	ecb.functionId = f.id AND
	f.classId = C.id AND
	ecbMemberStatement.parentStatementId = ecb.id AND

	C.id = sourceEntities.id AND
	sourceEntities.sourcefileid = files.id AND
        
        sig.functionid = f.id AND
        
        p.id = C.packageid

EXCEPT

SELECT DISTINCT
        'EMPTYCATCHBLOCK' as reason,
        p.fullname as package_full_name,
        correspondingType.fullname as class_full_name,
        sig.signature as signature,
	file.pathname AS file_name
FROM 
	TStatements catchBlock,
	TSourceEntities seCatchBlock,
	tcomments comment,
	TsourceEntities seComment,
	TFunctions functionWithCatchBlock,
	TTypes correspondingType,
	TFiles file,
        TSignatures sig,
        TPackages p
WHERE
	catchBlock.kindofstatement = 79 /*STATEMENT_CATCHBLOCK*/
	AND catchBlock.id = seCatchBlock.id
	AND comment.id = seComment.id
	AND seComment.sourcefileid = seCatchBlock.sourcefileid
	/* Kommentar startet im Catch-Block */
	AND seComment.startline > seCatchBlock.startline
	AND seComment.startline < seCatchBlock.endline
	AND functionWithCatchBlock.id = catchBlock.functionid
	AND functionWithCatchBlock.classid = correspondingType.id
	AND seCatchBlock.sourcefileid = file.id
        AND sig.functionid = functionWithCatchBlock.id
        AND p.id = correspondingType.packageid


UNION

SELECT DISTINCT
        'MISSINGDEFAULT' as reason,
        p.fullname as package_full_name,
        type.fullname as class_full_name,
        sig.signature as signature,
	files.pathname AS file_name	
FROM
	TStatements branchStatement join
	TModelElements mbs on (mbs.id = branchStatement.id 
		and mbs.status = 161 /*STATUS_NORMAL*/
		and branchStatement.kindofstatement = 76 /*STATEMENT_BRANCH*/) join
	TStatements branch on (branch.parentstatementid = branchstatement.id) join
	TFunctions func on (branchStatement.functionid = func.id) join
        TSignatures sig on (sig.functionid = func.id) join
	TTypes type on (func.classid = type.id) join
	VNumberOfSourceStatementsPerBranch sspb on (sspb.id = branchStatement.id and sspb.count > 1) join
	TSourceEntities sourceEntities on (type.id = sourceEntities.id) join
        TPackages p on (type.packageid = p.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) left outer join
	TSourceEntities sEntity on sEntity.id = branch.id
GROUP BY
        package_full_name,
	class_full_name,
        signature,
	file_name
HAVING
	count(sEntity.id) = 0
;


DROP VIEW VNumberOfSourceStatementsPerBranch;