/* $Id: PotentiellePrivatsphaereMethode.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */

CREATE OR REPLACE VIEW VppsMethod AS

(
SELECT
	function.id,
	function.name,
	function.classid
FROM
	TFunctions function join 
	TModelElements mFunction on (function.id = mFunction.id) join
	TConstants cmFunction on (cmFunction.value = mFunction.status and cmFunction.name = 'STATUS_NORMAL') join
	TConstants cons on (function.kindoffunction = cons.value) join
	TMembers member on (member.id = function.id) join
	TConstants cons2 on (member.visibility = cons2.value)
WHERE
	cons.name = 'FUNC_METHOD' AND
	cons2.name ='VISIBILITY_PROTECTED'

/*
Methoden einer Oberklasse, die von der Unterklasse aufgerufen werden
*/

EXCEPT

SELECT
	function.id,
	function.name,
	function.classid
FROM
	TFunctions function join
	TTypes type on (function.classid = type.id) join
	TInheritances inheritance on (inheritance.superid = type.id) join
	TTypes subType on (inheritance.classid = subtype.id) join
	TAccesses access on (function.id = access.targetid and access.classid = subtype.id)


EXCEPT

/* Methoden, die in einer Unterklasse berschrieben werden */
SELECT
	function.id,
	function.name,
	function.classid
FROM
	TFunctions function join
	TTypes type on (function.classid = type.id) join
	TInheritances inheritance on (inheritance.superid = type.id) join
	TTypes subType on (inheritance.classid = subtype.id) join 
	TSignatures signaturOverriddenMethod on (function.id = signaturOverriddenMethod.functionid) join
	TSignatures signatureOverridingMethod on (signaturOverriddenMethod.signature = signatureOverridingMethod.signature) join
	TFunctions overridingmethod on (overridingMethod.id = signatureOverridingMethod.functionid)
WHERE
	overridingmethod.classid = subType.id


EXCEPT

/* Methoden, die eine Methode einer Oberklasse berschreiben */
SELECT
	function.id,
	function.name,
	function.classid
FROM
	TFunctions function join
	TTypes type on (function.classid = type.id) join
	TInheritances inheritance on (inheritance.classid = type.id) join
	TTypes superType on (inheritance.superid = supertype.id) join 
	TSignatures signaturOverridingMethod on (function.id = signaturOverridingMethod.functionid) join
	TSignatures signatureOverriddenMethod on (signaturOverridingMethod.signature = signatureOverriddenMethod.signature) join
	TFunctions overriddenmethod on (overriddenMethod.id = signatureOverriddenMethod.functionid)
WHERE
	overriddenmethod.classid = superType.id

)
;

SELECT 
        p.fullname as package_full_name,
	type.fullname as class_full_name,
	sig.signature as signature,
        se.startline as line_number,
	file.pathname AS filename
FROM
	VppsMethod function join
	TSourceEntities se on (function.id = se.id) join
        TSignatures sig on (sig.functionid = function.id) join
	Tfiles file on (file.id = se.sourcefileid) join
	TTypes type on (type.id = function.classid) join
        TPackages p on (p.id = type.packageid)
;

drop view VppsMethod;
