/* $Id: Polymorphieplacebo.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



SELECT DISTINCT 
        pA.fullname AS superclass_package_full_name,
	A.fullName AS superclass_full_name, 
	SA.signature AS supermethod_signature, 
        fA.pathname AS supermethod_file_name,
        srcA.startline AS supermethod_line_number,
        
        pB.fullname AS subclass_package_full_name,
	B.fullName AS subclass_full_name, 
	SB.signature AS pseudo_override_method_signature,
        fB.pathname AS pseudo_override_method_file_name,
        srcB.startline AS pseudo_override_method_line_number
FROM 
	TTypes AS A, 
	TModelElements AS mA,
	TConstants cmA,
	TTypes AS B,  
	TModelElements AS mB,
	TConstants cmB,
	TInheritances AS tInheritanceAB, 
	TFunctions AS Am, 
	TFunctions AS Bm,
	TSignatures AS SA,
	TSignatures AS SB,	
	TMembers AS memberAm_A, 
	TMembers AS memberBm_B,
	TConstants AS con,
        TPackages pA,
        TPackages pB,
        TFiles fA,
        TFiles fB,
        TSourceEntities srcA,
        TSourceEntities srcB
WHERE 
	mA.id = A.id
	AND mA.status = cmA.value
	AND cmA.name = 'STATUS_NORMAL'
	AND mB.id = B.id
	AND mB.status = cmB.value
	AND cmB.name = 'STATUS_NORMAL'

	/* B erbt von A */	
	AND tInheritanceAB.superId = A.id AND
	tInheritanceAB.classId = B.id AND
	Am.id = memberAm_A.id AND memberAm_A.classId = A.id AND
	Bm.id = memberBm_B.id AND memberBm_B.classId = B.id AND

	/* statische nicht private Methode */
	memberAm_A.isstatic = 1 AND
	memberAm_A.visibility != con.value AND
	con.name = 'VISIBILITY_PRIVATE' AND
	
	/* gleiche signatur */
	Am.id = SA.functionId AND
	Bm.id = SB.functionId AND
	SA.signature = SB.signature

        AND

        pA.id = A.packageid AND
        pB.id = B.packageid

        AND
        
        fA.id = srcA.sourcefileid AND
        srcA.id = Am.id AND
        fB.id = srcB.sourcefileid AND
        srcB.id = Bm.id
;


