/* $Id: LangeParameterliste.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


SELECT 
	P.fullName as package_full_name,
	C.fullname as class_full_name,
	func.signature as signature,
        file.pathname as file_name,
        src.startline as line_number,
	cnt as number_of_parameters
FROM
	TSignatures func
INNER JOIN
	TModelElements elem on func.functionId = elem.id
JOIN
	TConstants cElem on (cElem.value = elem.status and cElem.name = 'STATUS_NORMAL')
JOIN
	TMembers member on (func.functionId = member.id)
LEFT OUTER JOIN
	TTypes C on elem.ParentId = C.id
LEFT OUTER JOIN
	TPackages P on
		C.PackageId = P.id 
		OR elem.parentId = P.id
left outer join
        TSourceEntities src on src.id = func.functionid left outer join
        TFiles file on file.id = src.sourcefileid

INNER JOIN
	(SELECT DISTINCT 
       		COUNT(parameter) AS cnt, 
       		f.id as fId
	FROM 
		TVariables parameter, 
		TConstants constantFormalParameter, 
		TFunctions f
	WHERE 
		parameter.KindOfVariable = constantFormalParameter.Value AND 
		constantFormalParameter.Name = 'VAR_FORMALPARAM' AND
	      	f.id = parameter.functionId
	GROUP BY 
		fId
	) as res on func.functionId = res.fId
WHERE 
	cnt > 7 
		AND not exists (
		SELECT
			*
		FROM
			TMembers overriddenmember,
			TModelElements mElement,
			TConstants mCon
		WHERE
			    member.overridenmemberid = overriddenmember.id
			AND mElement.id = overriddenmember.id
			AND mCon.value = mElement.status
			AND mCon.name = 'STATUS_LIBRARY'
		)
	
	
ORDER BY 
	cnt DESC
;
