/*
 * $Id: Identitaetsspaltung.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $
 */
 
/*

Namensvergleich ignoriert Gro- und Kleinschreibung

*/ 
SELECT 
	lower(type.name) AS class_name
	, COUNT(type.id) AS duplicate_count
FROM 
	TTypes type join
	TModelElements mType on (type.id = mType.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TMembers member on (type.id = member.id) join
	TConstants con on (member.visibility = con.value) join
	TSourceEntities sourceEntities on (type.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) 
WHERE
	/* Anonyme Klassen sind nicht von Interesse */
	type.name <> '' AND	/* Nur ffentliche Typen */
	con.name = 'VISIBILITY_PUBLIC' AND
	/* Keine inneren Klassen */
	type.classid = '-1'
GROUP BY 
	lower(type.name)
HAVING COUNT(type.id) > 1
;
