/* $Id: RefusedBequestInterface.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


SELECT DISTINCT
	B.fullname as superclass_full_name,
        FB_sig.signature as overriddenmethod_signature,
	files2.pathname as superclass_file_name,
        FB_src.startline as overriddenmethod_line_number,

	A.fullname as subclass_full_name,
        FA_sig.signature as overridemethod_signature,
	files.pathname as subclass_file_name,
        FA_src.startline as overrideemehod_line_number

FROM
	TFunctions FA join
	TModelElements mFA on (FA.id = mFA.id) join
	TConstants cmFA on (cmFA.value = mFA.status and cmFA.name = 'STATUS_NORMAL') join
	TMembers A_Am on (A_Am.id = FA.id) join 
	TTypes A on (A.id = A_Am.classId) join
	TMembers B_Bm on (B_Bm.id = A_Am.overridenmemberid) join
	TFunctions FB on (B_Bm.id = FB.id) join
	TModelElements mFB on (FB.id = mFB.id) join
	TConstants cmFB on (cmFB.value = mFB.status and cmFB.name = 'STATUS_NORMAL') join
	TTypes B on (B.id = B_Bm.classid) join
	TInheritances AB on (A.id = AB.classid and AB.superID = B.id) join
	TConstants visibility on (B_Bm.visibility = visibility.value) join
	TAccesses returnAccesses on (fb.returntypedeclarationid = returnAccesses.id) join
	TAccesses returnAccesses2 on (fa.returntypedeclarationid = returnAccesses2.id) join
	TStatements aStatements on (aStatements.functionid = FA.id) join
	TConstants statementtype on (aStatements.kindofstatement = statementtype.value) join
	TSourceEntities sourceEntities on (A.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) join
	TSourceEntities sourceEntities2 on (B.id = sourceEntities2.id) join
	TFiles files2 on (sourceEntities2.sourcefileid = files2.id) join

        TSignatures FB_sig on (FB_sig.functionid = FB.id) join
        TSignatures FA_sig on (FA_sig.functionid = FA.id) left outer join

        TSourceEntities FB_src on (FB_src.id = FB.id) left outer join
        TFiles FB_file on (FB_file.id = FB_src.sourcefileid) left outer join

        TSourceEntities FA_src on (FA_src.id = FA.id) left outer join
        TFiles FA_file on (FA_file.id = FA_src.sourcefileid)


WHERE 

	
	/* Die Methode ist public/protected */
	B_Bm.visibility = visibility.value AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR

		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	)

	AND
		(
		(	/* Die Method A_m ist leer */
		FA.NumberOfStatements = 0 AND
		FB.NumberOfStatements > 0 
		)


		/* Die berschreibende Methode enthlt als einziges Statement ein return null, die berschriebene nicht */
		
		OR
		
		(FA.NumberOfStatements = 1 AND
			statementtype.name = 'STATEMENT_RETURN' AND
			NOT EXISTS (
				SELECT 
					*
				FROM
					TStatements statements join
					TAccesses accesses on (statements.id = accesses.sourceid) join
					TConstants cons on (statements.kindofstatement = cons.value)
				WHERE
					statements.functionid = FA.id AND
					cons.name = 'STATEMENT_RETURN'
			)
		)

		/* Die berschreibende Methode enthlt als einziges Statement ein throw Statement */
		

		OR
		
		(FA.NumberOfStatements = 1 AND
		statementtype.name = 'STATEMENT_THROW' 
		)
		
		OR
		
		(B_Bm.visibility < A_Am.visibility
		)

)

	
;
