/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE OR REPLACE View VPublicClassPublicMethods AS

SELECT
	types.fullname as god_class_name,
	COUNT (functions.id) as number_of_methods,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM 
	TTypes types join
	TModelelements mType on (mType.id = types.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TMembers typeMember on (types.id = typeMember.id) join
	TConstants cons3 on (typeMember.visibility = cons3.value) join
	TFunctions functions on (functions.classid = types.id) join
	TConstants cons on (functions.kindoffunction = cons.value) join
	TMembers members on (functions.id = members.id) join
	TConstants cons2 on (cons2.value = members.visibility) join
	TSourceEntities sourceEntities on (types.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id)
WHERE
	(cons.name = 'FUNC_METHOD' OR
	cons.name = 'FUNC_CONSTRUCTOR' OR
	cons.name = 'FUNC_DESTRUCTOR') AND
	cons2.name = 'VISIBILITY_PUBLIC' AND
	cons3.name = 'VISIBILITY_PUBLIC' 
GROUP BY
	types.fullname,
	files.pathname,
	sourceEntities.startLine
;

CREATE OR REPLACE View VPackageClassPublicPackageMethods AS
SELECT
	types.fullname as god_class_name,
	COUNT (functions.id) as number_of_methods,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM 
	TTypes types join
	TModelelements mType on (mType.id = types.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TMembers typeMember on (types.id = typeMember.id) join
	TConstants cons3 on (typeMember.visibility = cons3.value) join
	TFunctions functions on (functions.classid = types.id) join
	TConstants cons on (functions.kindoffunction = cons.value) join
	TMembers members on (functions.id = members.id) join
	TConstants cons2 on (cons2.value = members.visibility) join
	TSourceEntities sourceEntities on (types.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id)

WHERE
	(cons.name = 'FUNC_METHOD' OR
	cons.name = 'FUNC_CONSTRUCTOR' OR
	cons.name = 'FUNC_DESTRUCTOR') AND
	(cons2.name = 'VISIBILITY_PUBLIC' OR cons2.name = 'VISIBILITY_PACKAGE') AND
	cons3.name = 'VISIBILITY_PACKAGE'
GROUP BY
	types.fullname,
	files.pathname,
	sourceEntities.startLine
;

SELECT 
	*
FROM
	VPublicClassPublicMethods vpcpm
WHERE
	vpcpm.number_of_methods > 50

UNION


SELECT 
	*
FROM
	VPackageClassPublicPackageMethods vpcpm
WHERE
	vpcpm.number_of_methods > 50

;






DROP View VPublicClassPublicMethods;

DROP View VPackageClassPublicPackageMethods;


