/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

select
	res.ClassFullName as class_full_name,
	sig.signature as method_signature,
	file.pathname as file_name,
	src.startline as line_number
from
	(
	SELECT DISTINCT 
		C.id as ClassId,
		C.fullName AS ClassFullName, 
		m.id as MethodId,
		m.name As DeadMethodName
	FROM 
		TTypes As C, 
		TModelElements as me,
		TConstants as cm,
		TMembers AS m,
		TFunctions AS f,
		TConstants AS constPrivate
	WHERE 
		C.id = me.id 
		AND cm.value = me.status 
		AND cm.name = 'STATUS_NORMAL'

		/* private methods of C */
		AND f.id = m.id and
		m.classId = C.id and
		m.visibility = constPrivate.Value AND
		constPrivate.name = 'VISIBILITY_PRIVATE'

	/* take out those that have accesses */
	EXCEPT

	SELECT DISTINCT 
		C.id as ClassId,
		C.fullName AS ClassFullName, 
		m.id as MethodId,
		m.name As DeadMethodName
	FROM 
		TTypes As C, 
		TMembers AS m,
		TFunctions AS f,
		TConstants AS constPrivate,
		TAccesses AS acc
	WHERE 
		/* private methods of C */
		f.id = m.id and
		m.classId = C.id and
		m.visibility = constPrivate.Value AND
		constPrivate.name = 'VISIBILITY_PRIVATE' AND

		/* there is at least an access */
		acc.targetId = m.id AND
		acc.functionid <> f.id
	) as res join
	TSignatures sig on sig.functionid = res.MethodId left outer join
	TSourceEntities src on res.ClassId = src.id left outer join
	TFiles file on src.sourcefileid = file.id
;
