/* $Id: PraenataleKommunikation.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


SELECT DISTINCT 
	A.fullName AS SuperClassFullName, 
	sig.signature as signature,
        f.pathname as file_name,
        src.startline as line_number
FROM 
	TTypes A  inner join 
	TModelElements mA on (mA.id = A.id) join
	TConstants cmA on (cmA.value = mA.status and cma.name = 'STATUS_NORMAL') join
	TFunctions AS Am_Con on (Am_Con.classid = A.id) inner join 
	Taccesses as accesses on (accesses.functionId = Am_con.id) inner join 
	TFunctions AS Am on (accesses.targetid = Am.id and Am.classId = A.id) inner join
	TMembers AS funcMember on (funcMember.id = Am.id AND funcMember.isfinal = 0) inner join
	TSignatures sig on (sig.functionid = Am_con.id) left outer join
        TSourceEntities src on (src.id = Am_con.id) left outer join
        TFiles f on (f.id = src.sourcefileid),
	TConstants con,
	TConstants con2
        
        
WHERE 
	Am_con.kindoffunction = con.value  AND
	con.name = 'FUNC_CONSTRUCTOR' AND
	
	/* Konstruktor der Oberklasse muss diese Methode aufrufen */
	
	con2.value = Am.kindoffunction AND
	con2.name = 'FUNC_METHOD'



;
