/* $Id: Paketchen.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



create or replace view VPackPublicTypes as

SELECT
	pack.id as PackageId, 
	pack.fullName as PackageName,
	count(distinct types.id) as NoPublicTypes
FROM
	TPackages as pack left outer join
	TTypes as types on types.packageId = pack.id and types.classid = -1 join
	TModelElements mA on (types.id = mA.id) join
	TConstants cmA on (cmA.value = mA.status and cmA.name = 'STATUS_NORMAL') join	
	TMembers as m on types.id = m.id join
	TConstants con on m.Visibility = con.Value and con.Name = 'VISIBILITY_PUBLIC' join
	TSourceEntities as source on (source.id = types.id) join
	TFiles files on (source.sourcefileid = files.id) 
GROUP BY
	pack.id,
	pack.fullName
;


SELECT
	t.PackageName as package_name,
	t.NoPublicTypes as number_of_public_classes
FROM
	VPackPublicTypes as t
WHERE
	t.NoPublicTypes < 3
	AND t.NoPublicTypes > 0
ORDER BY
	number_of_public_classes
;	


drop view VPackPublicTypes;
