/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 2. Phase: Transformationen
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    

header {	
	package de.fzi.delphi.parser;
	
	// Imports
	import java.util.Vector;
	import java.util.Enumeration;
	import antlr.CommonAST;
	import de.fzi.delphi.CommonASTWithLineNumber;
	import de.fzi.delphi.OPProjectManager;
	import antlr.collections.AST;	
	import antlr.TokenStreamException;
	// HG: Wozu?
	import de.fzi.sissy.metamod.Statement;
	import de.fzi.sissy.metamod.SimpleStatement;
	import de.fzi.sissy.metamod.BranchStatement;
	import de.fzi.sissy.metamod.BlockStatement;
	import de.fzi.sissy.metamod.JumpStatement;
	import de.fzi.sissy.metamod.LoopStatement;
	import de.fzi.sissy.metamod.ExceptionHandler;
	import de.fzi.sissy.metamod.ModelElementList;
	import de.fzi.sissy.metamod.CatchBlock;
}

class OPTransformer extends TreeParser;
options {
	importVocab=OPParser;
//	exportVocab=OPTree;
	buildAST=true;
	ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
}
{	// DEBUG Options
	static final boolean DEBUG_ALL = false;
	static final boolean DEBUG_RULENAMES = false | DEBUG_ALL;
	static final boolean DEBUG_PRINT_IDENT_WITH_LINE= false | DEBUG_ALL;
	static int outputLineNumber=1;

	static int statementCounter = 0;
	String s; // return values

	void print(Object output){
		System.err.print(""+(outputLineNumber++)+".\t"+output);
		System.err.flush();
	}

	void println(Object output){
		print(output);
		System.err.println();
		System.err.flush();
	}

	void println(){
		println( "" );
	}

	void printRuleName(String rulename){
		if( !DEBUG_RULENAMES ) 
			return;
		println(rulename);
	}

}

goal 
{
// Print some Debug Info about the next tokens/tree
//	System.err.println(_t.toStringTree());
//	System.err.println("PROGRAM = "+PROGRAM);
//	System.err.println(OPParser._tokenNames[_t.getType()]+"="+_t.getType());		
//	System.err.println(_tokenNames[_t.getType()]+"="+_t.getType());
}
	: 
	(		program
		|	package_
		|	library_
		|	unit
	)
    ;

program
	:
		(programHeading)?
		programBlock
	;

programHeading
	{   printRuleName("OPTransformer."+"programHeading"); 
		Vector temp;
	}
	:	#(PROGRAM  IDENT (temp=identList)? )
	;

programBlock
	{ printRuleName("OPTransformer."+"programBlock"); }
	:
		( usesClause )*
		subprogramBody
	;	

package_
	{ printRuleName("OPTransformer."+"package_"); }
	:	#(PACKAGE 							
			IDENT
			(containsClause)?
		 )
	;


library_
	{ printRuleName("OPTransformer."+"library_"); }
	:	#(LIBRARY
			IDENT 
			programBlock
		)
	;


unit
	{ printRuleName("OPTransformer."+"unit"); }
	:	#(UNIT
			IDENT 
			( directive	)? 
			unitBody
		)
	;
	
unitBody
	:	
//		{ System.err.println("---- INTERFACE Section----"); }
		interfaceSection
//		{ System.err.println("---- IMPLEMENTATION Section----"); }
		implementationSection
 		(
 //			{ System.err.println("---- INITIALIZATION Section ----"); }
 			initSection	
 		)?
	;

interfaceSection
	{ printRuleName("OPTransformer."+"interfaceSection"+" #################################");  }
	:	#( INTERFACE
			(usesClause)?
			(interfaceSectionDecl)*
		)
	;

interfaceSectionDecl
	:	#( DECL_SECT 
			(
				basicDecl 
			|	#(PROC_DECL procedureHeading)
			| 	#(FUNC_DECL functionHeading)
			)
	   	)
	;

implementationSection
	{ printRuleName("OPTransformer."+"implementationSection"+" #################################");  }
	:	#( IMPLEMENTATION
			(usesClause)?
			(declSection[false])*
			(exportsStatement)*
		)
		
		{		
//			ListIterator li = getIn
//			##.addChild(); 
		
		}
		
	;
	
exportsStatement
	:	#(EXPORTS
			(
				identifier 
				(	(NAME|INDEX) constExpression 
					(
						(NAME|INDEX)  constExpression 
					)?
				)?
			
			)*
		)
	;
		
initSection
	{ printRuleName("OPTransformer."+"initSection"); }
	
	:	#(INITIALIZATION (statementList) 
			( finalization )?
		)
//	| 	compoundStatement
	;

finalization
	{ printRuleName("OPTransformer."+"finalization"); }
	:	#(FINALIZATION (statementList) )	
	;

containsClause
	{ printRuleName("OPTransformer."+"containsClause"); 
		Vector temp;
	}
	:	#(CONTAINS 
			temp=identList
		)
	;
	
usesClause
	{ printRuleName("OPTransformer."+"usesClause"); 
		Vector temp;
	}
	:	#(USES 
			temp=identList
		)
	;
	
identList returns [Vector v]
	{ 	printRuleName("OPTransformer."+"identList"); 
		v = new Vector(); }
    : #( IDLIST 
    		( id:identifier
    			{ v.addElement(getASTFactory().dup(id));}
    		)*
    	)
    ;

identifier
	{ printRuleName("OPTransformer."+"identifier"); }
	:	id:IDENT	
		{ 
			if( DEBUG_PRINT_IDENT_WITH_LINE )
				System.err.println(" $${"+#id.getText()+", "+#id.getLine()+"}"); 
		}
	;

subprogramBody 
	{ printRuleName("OPTransformer."+"subprogramBody "); }
  :   	
  	( declSection[false] )*
  	(exportsStatement)?
	  	( mainProgram )?	//Optional main program "begin ... end"
  ;

declSection [boolean isInnerDecl]
	{ printRuleName("OPTransformer."+"declSection"); }
	:	#( DECL_SECT 
			(
				basicDecl 
			|	procedureDecl[isInnerDecl]
			| 	functionDecl[isInnerDecl]
	    	|	constructorDecl
    		|	destructorDecl
			)?
	   	)
	;

basicDecl
	{ printRuleName("OPTransformer."+"basicDecl"); }
	: 	varDeclSection
	|	constDeclSection
	|	typeDeclSection
	|	labelDecl
	;

typeDeclSection
	{ printRuleName("OPTransformer."+"typeDeclSection"); }
	: 		( typeDecl )+
	;

typeDecl
	{ printRuleName("OPTransformer."+"typeDecl"); 
		Vector t=null;
	}
	:   #( TYPE_DECL id:IDENT
		//			{ printRuleName("OPTransformer."+"<TYPE>:"+id.getText()+"******************************"); }
	
			( DEREF )?
			
			(	s=typeId 
	   		|   s=structuredType
	   		|	#( CLASS 
	   				(
	   					#(	EXTENDS	(t=identList)? )
	  					( classVisibilityDecl )*
  					|	OF s=typeId 
	   				)
	   			)
	   		|	#( INTERFACE
	   				#(	EXTENDS	(t=identList)? )
	   				( comGuid )?
  					(classMethodDecl|propertyDecl)*
	   			)
	   		|	#( DISPINTERFACE
	   				#(	EXTENDS	(t=identList)? )
	   				( comGuid )?
  					(classMethodDecl|dispinterfacePropertyDecl)*
	   			)
			|	expressionRange
// 			|	proceduralType
		)
	)
	;

comGuid
	:	#( COM_GUID (STRING_LIT)? )
	;
	
dispinterfacePropertyDecl
	:	#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			s=typeId
			(propertySpecifiers|directive)*
		)
	;
	
labelDecl
	:
		#( LABEL_DECL expressionList! )
	;

varDeclSection
	{ printRuleName("OPTransformer."+"varDeclSection"); }
	: 	// #( v:VAR_DECL 
			 ( varDecl )+ 
		//)
	;

varDecl 
{	Vector il; 
}
  	:	#( vd:VAR_DECL 
  			il=identList 
  			( DEREF )?
	  		(	s=t:typeId
	 		|	r:range
			|	s=structuredType
//			|	proceduralType 
	  		)
  		)

  		{	// Elemente der Identlist in Vector schreiben
  			// DEREF wird verworfen
			CommonASTWithLineNumber oldAst=null;
			CommonASTWithLineNumber ast;
			for(int i=0;i<il.size();i++){
	  			ast = new CommonASTWithLineNumber();
				ast.initialize((CommonASTWithLineNumber)il.elementAt(i));

				if( #t != null )
					ast.addChild(#t);
				else if( #r != null )
					ast.addChild(#r);

				if( oldAst != null ) 
					oldAst.setNextSibling(ast);
				else
					#varDecl = ast;
				oldAst = ast;
			}
			//System.out.println("TVARDEC: "+#vd_in.getPositionElement());
			
			#varDecl = #([VAR_DECL,"VAR_DECL"],#varDecl);
			#varDecl.setPositionElement(#vd_in.getPositionElement());
		}
  	;

range
	{ printRuleName("OPTransformer."+"Range"); }
	:	// #(RANGE ordinalType ordinalType)
		expressionRange
	;

ordinalType
	:	expressionRange //range
	|	integerConstant
	|	enumDecl
	|	booleanConstant
	|	qualifiedIdentifier //identifier
	|	s=predefinedType // DEBUG: eigentlich OrdIdent
	;
	
enumDecl
	:	#( ENUM_DECL expressionList )
	;
	
charConstant
	:	charLiteral
	;
	
constDeclSection 
	{ printRuleName("OPTransformer."+"constDeclSection");	}
  	: 	
  	( 
  		#( CONST (constDecl)+)
  	|   #( r:RESOURCESTRING (constDecl)+) 
  		{
  		 	#r.setType(CONST);
  		}
  	)
	;

constDecl
	{ printRuleName("OPTransformer."+"constDecl");	}
	:	#( ASSIGN 
			identifier 
			( 	{ String temp; } 
				temp=typeId
			)? 
			(	expression
			|	objectInitialization
			)
		)
	;

/*		(
			( COLON! 
				(	t:typeId e1:EQUALS^ { #e1.setType(ASSIGN); } 
					(	
						objectInitialization
					|	setConstructor
					) 
				|	structuredType 
					e2:EQUALS^ { #e2.setType(ASSIGN); } 
						( objectInitialization
						| setConstructor
						)
				)
			)
			|	e3:EQUALS^	expression { #e3.setType(ASSIGN); } 
		)
*/

objectInitialization
	:	#(OBJ_INIT
			(
				(recordConstant)+
			|	(expression)+
			|	(objectInitialization)+
			)
		)
	;

recordConstant
	:	#(ASSIGN identifier expression)
	;
	
unitIdent
	:	#( UNIT_IDENT IDENT )
	;	
	

typeId returns [String str]
	{ 
		printRuleName("OPTransformer."+"typeId");
		str = null; 
		 }
	:	(
		#(TYPE_NODE 
		  (	
		  		#(p:PREDEF_TYPE s=predefinedType)
		  		 	{ str = p.getText(); }
			|	id:IDENT 	{ str = id.getText(); } 
							(unitIdent)? 
			|	str=structuredType
			|	#(ENUM_DECL expressionList)
			|	proceduralType
		  )
		) 
		|
		#(c:CONST
			{
				// Replace 'array of const' by 'array of TVarRec'
				str = "TVarRec";
				c.setType(TYPE_NODE);
				c.setText("TYPE_NODE");
				CommonASTWithLineNumber tVarRecID = new CommonASTWithLineNumber(new Token(IDENT));
				tVarRecID.setText(str);
				c.addChild(tVarRecID);
			}
		)
	)
	;
	
proceduralType
	:	#(PROCEDURE
  			(formalParameters)?
  			(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	|	#(FUNCTION
  			(formalParameters)?
	  		(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	;
	
predefinedType returns [String tok]
{ tok = ""; }
    :		real48:REAL48 				{ tok = #real48.getText(); }
		|	single:SINGLE 				{ tok = #single.getText(); }
		|	double_:DOUBLE 				{ tok = #double_.getText(); }
		| 	real:REAL 					{ tok = #real.getText(); }
		|	boolean_:BOOLEAN 			{ tok = #boolean_.getText(); }
		|	integer:INTEGER 			{ tok = #integer.getText(); } 
		|	cardinal:CARDINAL 			{ tok = #cardinal.getText(); }
		|	shortint:SHORTINT 			{ tok = #shortint.getText(); }
		|	smallint:SMALLINT 			{ tok = #smallint.getText(); }
		|	longint:LONGINT 			{ tok = #longint.getText(); }
		|	int64:INT64 				{ tok = #int64.getText(); }
		|	byte_:BYTE 					{ tok = #byte_.getText(); }
		|	word:WORD 					{ tok = #word.getText(); }
		|	longword:LONGWORD 			{ tok = #longword.getText(); }
		|	ansistring:ANSISTRING 		{ tok = #ansistring.getText(); }
		|	widestring:WIDESTRING 		{ tok = #widestring.getText(); }
		|	variant:VARIANT 			{ tok = #variant.getText(); }
		|	olevariant:OLEVARIANT 		{ tok = #olevariant.getText(); }
		|	#(string:STRING 			{ tok = #string.getText(); }
				(constValue)?
			)
	;	

constValue
	:
//	#( CONST_EXPR
		(	integerConstant
		|	unsignedReal
		|	booleanConstant
		|	charLiteral
		|	stringLiteral
		|	identifier 
	    |	NIL			
	   	) 
//   	)
	;
//
//predefinedType
//    :
//			REAL48
//		|	SINGLE
//		|	DOUBLE
//		| 	REAL
//		|	BOOLEAN
//		|	EXTENDED
//		|	COMP
//		|	CURRENCY
//		|	INTEGER
//		|	CARDINAL
//		|	SHORTINT
//		|	SMALLINT
//		|	LONGINT
//		|	INT64
//		|	BYTE
//		|	WORD
//		|	LONGWORD
//		|	ANSISTRING
//		|	WIDESTRING
//		|	VARIANT
//		|	OLEVARIANT
//		|	#(STRING (constExpression)?)
//		
//	;	

constExpression
	:	expression
	;

integerConstant
  : #( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedInteger
  ;

unsignedInteger
    :       INT_LIT
    |		HEX_CONST
 	;
 	
realConstant
  : #( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedReal
  ;

unsignedReal
	:	REAL_LIT
	;
	
booleanConstant
	:	( TRUE | FALSE )
	;

stringLiteral
    :	STRING_LIT  							
    ;	

charLiteral
	:	CHAR_LIT						
	| 	#(CHR INT_LIT)
	;	       
	
mainProgram
	{ printRuleName("OPTransformer."+"mainProgram");}
	:	#(MAIN_PROGRAM 
			{ printRuleName("OPTransformer."+"===================================");}
			compoundStatement 
		)
	;

compoundStatement
	{ printRuleName("OPTransformer."+"compundStatement");}
	:	statementList
	|	asmStatement
	;
	
statementList
	{ printRuleName("OPTransformer."+"statementList");}
	:	#( STMNT_LIST (statement)* )
	;

statement
	{ printRuleName("OPTransformer."+"statement");}
	: 	( label )?	
	(	simpleStatement
	|	ifStatement
	|   compoundStatement
	|	tryStatement
	|	gotoStatement
	|	caseStatement
	|	raiseStatement
	|	emptyStatement
	|	withStatement
	|	forStatement
	|   whileStatement
	|	repeatStatement
	)
	;

asmStatement
	:	#( ASM	( #( META_INFO INT_LIT) )* )
	;

whileStatement
  : #(	WHILE  
	  		expression
	  		statement
  	)
  ;

repeatStatement
  :	#(REPEAT
  		statementList
  		expression
  	)
  ;

forStatement
	:	#( FOR 
	  		#( ASSIGN identifier expression )
			(	#(TO expression )
			|	#(DOWNTO expression )
			)
			#( DO 		statement )
		)
	;


withStatement
	:	#(WITH expressionList statement )
	;


emptyStatement 	// remove emptyStatements
	:	EMPTY_STMNT
	;
	
label
	:	#( LABEL ( identifier | INT_LIT ) )
	;

ifStatement 
    :	#(IF expression statement (elseBlock )? )
    ;

elseBlock
	:
		#(ELSE 			statement )
    	
	;
gotoStatement
  	:	#(GOTO	identifier)
	;

raiseStatement
	:	#(RAISE
			( expression (raiseAt)? )? 
		)
	;

raiseAt
	:	 #(AT expression)
	;	

caseStatement
	:	#(CASE
			expression
			( caseSelector )+
			( caseElse	)?
		)
	;    

caseElse
	:	#( ELSE statementList )
	;
	
caseSelector
	: 	#( COLON 
			caseLabel ( COMMA caseLabel )* 
			statement 
		)
	;
	
caseLabel
	:	constExpression (DOTDOT constExpression )?
	;
	
////////////////////////////////////////////////////////////////////////////////
tryStatement
	:	#( TRY statementList
			(	tryExceptStatement
			|	tryFinallyStatement
			)
		)
	;

tryExceptStatement
	:	#( EXCEPT exceptionBlock )
	;

tryFinallyStatement
	:   #(FINALLY statementList )
	;

exceptionBlock
	:	statementList
	|	(
			(exceptionOn)+
        	(exceptionElse)?
		)
	;
	
exceptionOn
	:
		#(ON
			( identifier COLON )? 
			s=typeId 
			exceptionDo
		)
	;	
	
exceptionElse
	:	#( ELSE statementList )
    ;
    
exceptionDo
	:	#( DO statement )
	;	
////////////////////////////////////////////////////////////////////////////////
		

simpleStatement
	{ printRuleName("OPTransformer."+"simpleStatement");}
	:	
		expr:
		expression 
//		{ if( ##.getFirstChild().getType() != FUNC_CALL ){
//				##.setType(FUNC_CALL);
//				##.setText("FUNC_CALL");
//				## = #([EXPR,"EXPR"],##); 
//			}
//		}
//		{ ## = #([FUNC_CALL],ex1); }
	|	#(ASSIGN expression  expression
		)
		
	;

expressionList returns [Vector v]
{ v = new Vector(); }
    :  #(EXPR_LIST 
    		(
    			expr:expression 
    			{ v.addElement(getASTFactory().dupTree(expr));}
    		)+ 
    	) 
    ;   

expression 
	{ printRuleName("OPTransformer."+"expression");
	}
	:	#( EXPR 	
			simpleExpression  // (exprTail)* 
//			( dereference )?
		)
	;

//exprTail
//	:		DEREF 
//		|	arrayDim
//		|	expressionList
//	;
	
simpleExpression 
	{ printRuleName("OPTransformer."+"expression");
	}
	:
	(	 	#(EQUALS		simpleExpression simpleExpression)
		|	#(NOT_EQUALS	simpleExpression simpleExpression)
		|	#(LT			simpleExpression simpleExpression)
		|	#(LTE			simpleExpression simpleExpression)
		|	#(GT 			simpleExpression simpleExpression)
		|	#(GTE 			simpleExpression simpleExpression)
		|	#(IN 			simpleExpression simpleExpression)
	
		|	#(PLUS			simpleExpression simpleExpression)
		|	#(MINUS 		simpleExpression simpleExpression)
		|	#(OR 			simpleExpression simpleExpression)
		|	#(XOR 			simpleExpression simpleExpression)
	
	    |	#(TIMES 		simpleExpression simpleExpression)
		|	#(DIVIDE 		simpleExpression simpleExpression)
		|	#(MOD 			simpleExpression simpleExpression)
		|	#(DIV 			simpleExpression simpleExpression)
		|	#(AND 			simpleExpression simpleExpression)
		|	#(SHL 			simpleExpression simpleExpression)
		|	#(SHR 			simpleExpression simpleExpression)
		|	#(IS 			simpleExpression simpleExpression)
	 	|	#(AS 			simpleExpression simpleExpression
//	 						{ String temp;}
//	 						temp=typeId 
	 						)
	 	|	#(NOT			simpleExpression)
	 	|	#(ADDR_OP		simpleExpression)
		|	#(UNARY_PLUS	simpleExpression)
		|	#(UNARY_MINUS	simpleExpression)
		|	#(INHERITED 	(simpleExpression)? )
	 	|   #(DOT 			simpleExpression simpleExpression)
		|	primaryExpression
	)
	( dereference
		|	arrayDim
		 )*
 	;

primaryExpression
{ 	printRuleName("OPTransformer."+"primaryExpression");
	CommonAST dn=null; }
	:		expression 			// geklammerte Expression
		|  	unsignedConstant
		|	dn=fc:functionCallOrTypecast! // ( DEREF )*
			{ if( dn != null )
				## = #( dn,#fc ) ;
				else
					## = #fc;
			}
		|	identifier // ( DEREF )*
		|	s=typeId
	;

dereference
	:	( DEREF )+
	;

functionCallOrTypecast! returns [CommonAST b]
	{ printRuleName("OPTransformer."+"functionCallOrTypecast");
		b = null;
	}
	:	#(FUNC_CALL 
			(	qi:qualifiedIdentifier 
			|	s=t:typeId
			)
			#( PARAM_LIST (el1:expressionList)? )
			(el2:expressionList)?
			b1:( dereference | arrayDim )*
		)
		{ 	if( #b1 != null)
			{
				b = #b1;
			}
			// el1 == null wird bisher nicht behandelt
			if( el2 != null ) // Aufruf von gecasteter Funktion mit parametern
			{	
				if( qi != null ) {
					// ## = #(#[TYPE_CAST],#qi,#(#[FUNC_CALL],el1,#(#[PARAM_LIST],el2)));
					 ## = #(	#[FUNC_CALL],
						 			#(	#[TYPE_CAST,"TYPE_CAST"],
								 			#qi,
								 			el1
						 			),
						 			#(	#[PARAM_LIST],
						 					el2
						 			)
						 	);
				}
				else{
					## = #(#[TYPE_CAST,"TYPE_CAST"],el2);
					}
			}
			else 
			{	
				if( qi != null ) {
					## = #(#[FUNC_CALL],#qi,#(#[PARAM_LIST],el1));
				}
				else{
					## = #(#[TYPE_CAST,"TYPE_CAST"],t,el1);
				}
			}
			
		}
	;

arrayDim
	{ printRuleName("OPTransformer."+"arrayDim");
	}
	:	( options{greedy=true;}
			: 
			#( ARRAY_INDEX (arrayDim)? expression	)
		)+
	;	
	
unsignedConstant
    :	unsignedInteger
    | 	unsignedReal
	|	booleanConstant
	|	charLiteral
	|	stringLiteral
	|	setConstructor
    |	NIL
    ;

setConstructor
	{ printRuleName("OPTransformer."+"setConstructor");}
	:
		#(SET_CONSTR
			(	(expressionRange)+
			|	() // EMPTY_SET
			)
		)
	;
        	
procedureDecl [boolean isInnerDecl]
	{ if( DEBUG_RULENAMES ) 
		println("OPTransformer."+"procedureDecl"+", "+#procedureDecl_in.getLine());
//		System.out.println(new Exception().getStackTrace()[0].getMethodName());
		}
	:	
		#( PROC_DECL
	  		procedureHeading 
  			(declSection[false])*
			(compoundStatement)?
		)
	;

procedureHeading
	{ printRuleName("OPTransformer."+"procedureHeading");}
	:	(CLASS)?
		qualifiedIdentifier 
		(formalParameters)? 
		( directive )*
  	;
		
functionDecl [boolean isInnerDecl]
	{ printRuleName("OPTransformer."+"functionDecl"); 	
	}
  	: 	
  		#( FUNC_DECL
	  		functionHeading 
			( 
			 declSection[false] 
			)*
			(compoundStatement)?
		)
  ;

functionHeading
	{ printRuleName("OPTransformer."+"functionHeading"); 
	  String temp; }
	: 	(CLASS)?
		qualifiedIdentifier 
		(formalParameters)? 
  		(temp=typeId )?
		( directive )*
	;


qualifiedIdentifier returns [String str]
	{ printRuleName("OPTransformer."+"qualifiedIdentifier"); 
	  String temp=new String();
		str=new String();
	}
	:	#( id:IDENT 
			{   
//				System.err.println("$$ "+#id.getText()+", "+#id.getLine()); 
				str = id.getText();
			}
			(
				temp=qualifiedIdentifier
				{ str = str+"."+temp; }
			)* 
		)
	;

	
directive
	:
	{ printRuleName("OPTransformer."+"directive"); }
	#( DIRECTIVE
		(	#(MESSAGE constValue)
		| 	directiveExternal
		|	#(DISPID integerConstant)
		|	CDECL	
		|	ABSTRACT
		|	DYNAMIC
		|	EXPORT
		|	FAR
		|	FORWARD		
		|	LOCAL
		|	NEAR
		|	OVERLOAD
		|	OVERRIDE
		|	PASCAL
		|	REGISTER
		|	REINTRODUCE
		|	SAFECALL
		|	STDCALL
		|	VARARGS
		|	VIRTUAL
		|	ASSEMBLER
		|	READONLY 
		|	WRITEONLY	
		)+
	)
	;

directiveName
	:	#(NAME
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
		)
	;

directiveIndex
	:	#( INDEX INT_LIT )
	;
	
directiveExternal
	:	#(EXTERNAL 
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
			( directiveName		
			|	directiveIndex )*
		)
	;

        	
formalParameters
	{ printRuleName("OPTransformer."+"formalParameters"); }
	:		parameterList
	;


parameterList!
{
	printRuleName("OPTransformer."+"parameterList"); 
 	Vector params=null; 
	CommonASTWithLineNumber temp = new CommonASTWithLineNumber( new Token(PARAM_LIST));
	temp.setText("PARAM_LIST");
}
	:	#(PARAM_LIST 
			(	params=ps:parameterSpec!
				{	for(int i=0;i<params.size();i++) {
			  CommonASTWithLineNumber param = (CommonASTWithLineNumber)params.elementAt(i);	
			  param.setPositionElement(#ps_in.getPositionElement());	
			  		temp.addChild(param);
					  //System.out.println("TATA: "+#ps_in.getPositionElement());
				}
				}
			)+
		)
		{ ## = temp; }
	;

parameterSpec! returns [Vector params] 
	{	printRuleName("OPTransformer."+"parameterSpec"); 
		Vector il;
		params = new Vector(); 
	}
	: 	#( ps:PARAM_SPEC 
  			(var_:VAR|const_:CONST|out_:OUT)? 
  			il=identList
  			( s=t:typeId )?
 			( EQUALS constExpression )?
 		)
  		{	CommonASTWithLineNumber subAst;
			CommonASTWithLineNumber ruleAst=new CommonASTWithLineNumber(new Token(PARAM_SPEC));

			for(int i=0;i<il.size();i++){
	  			subAst = new CommonASTWithLineNumber();
	  			subAst.setType(PARAM_SPEC);
	  			subAst.setText("PARAM_SPEC");
				subAst.addChild(((CommonASTWithLineNumber)il.elementAt(i)));
				if ( t != null) 
					subAst.addChild(getASTFactory().dupTree(t));
				/* if( var_ != null ) 
					subAst.addChild(getASTFactory().dupTree(var_));
				if( const_ != null )
					subAst.addChild(getASTFactory().dupTree(const_));
				if( out_ != null )
					subAst.addChild(getASTFactory().dupTree(out_));
				*/	

				ruleAst.addChild(subAst);
				params.addElement(getASTFactory().dupTree(subAst));
			}
			##=ruleAst;
  		}
	;
	
structuredType  returns [String str=null;]
	{ printRuleName("OPTransformer."+"structuredType");
	}
	:	(PACKED)?
		(	arrayDecl { str= "<array>"; } 
		|	str=fileType 
			{ 	if( str != null ) 
					str = "file of "+str;
				else
					str = "<file>";
				// println("###"+str);
			}
		|	recordDecl { str= "<record>"; } (PACKED)?
		|	setType
		)
	;

setType
	:	#( SET ordinalType (directive)? )
	;


fileType returns [String t=null;]
	{	printRuleName("OPTransformer."+"fileType"); 
		}
	:
		#( FILE_TYPE 
			(
				t=typeId
			)? 
		)
	;

recordDecl
	{	printRuleName("OPTransformer."+"recordDecl"); }
	:	#( RECORD_DECL 
			(varDecl)*
			( variantSection )?
			( directive )?
		)
	;	
	
variantSection
	{	printRuleName("OPTransformer."+"variantSection"); 
		Vector temp=null;
	}
	:	#(VARIANT_SECT
			 // switch
			#(VAR_DECL 
				//temp=identList
				#(IDLIST (identifier)? )  
				s=typeId
			) // only type possible

			(
				#(COLON 
					// #(EXPR constValue)
					( #(EXPR constValue) )+
					(varDecl)*
				)
			)+
		)
	;
	
arrayDecl!
	{	printRuleName("OPTransformer."+"arrayDecl"); 
		String temp;
	}
  	:	
  		#( ARRAY_DECL 
  			(er:expressionRange)* 
  			(	temp=ti:typeId
  			|	ad:arrayDecl
  			) 
  		)

  	{	// Tree
  		CommonASTWithLineNumber tempAst=null;
  		CommonASTWithLineNumber root=new CommonASTWithLineNumber();
  		
  		root.setType(OPTransformerTokenTypes.ARRAY_DECL);
  		root.setText("ARRAY_DECL");
  		
		if( #er != null ){
			if( #ad != null && #ti == null ){
				tempAst = #(root, er, #(#[TYPE_NODE,"TYPE_NODE"], ad )  );
			}
			else if( #ad == null && #ti != null ){
				tempAst = #(root, er, ti );
			}
			else
				System.err.println("XXX Error in type calculation.");
		}
		else
		{
			if( #ad != null && #ti == null ){
				tempAst = #( root, #(#[TYPE_NODE,"TYPE_NODE"], ad ) );
			}
			else if( #ad == null && #ti != null ){
				tempAst = #( root, ti );
			}
			else
				System.err.println("XXX Error in type calculation.");
		}
	}
	{ ## = #tempAst; }
  	;

expressionRange
	{	printRuleName("OPTransformer."+"expressionRange");  }
	:	#(EXPR 
			(	simpleExpression 
			|	#(RANGE expression expression) 
			)
		)
	;
	
classVisibilityDecl
	{	printRuleName("OPTransformer."+"classVisibilityDecl"); 
	}
		// besser wre fr jedes Element einen UnterAST mit Blatt "PUBLIC" etc. 
	:	#(PUBLIC    (classElementDecl)* )
	|	#(AUTOMATED	(classElementDecl)* )
	|	#(PUBLISHED	(classElementDecl)* )
	|	#(PRIVATE	(classElementDecl)* )
	|	#(PROTECTED	(classElementDecl)* )
	;

classElementDecl
	{	printRuleName("OPTransformer."+"classElementDecl"); }
	:	varDecl 
	|	classMethodDecl
	|	propertyDecl
	|	recordDecl
	|	arrayDecl
	;
	
classMethodDecl
	:
		#(PROC_DECL procedureHeading (EQUALS qualifiedIdentifier)? )
	|	#(FUNC_DECL functionHeading (EQUALS qualifiedIdentifier)? )
	|	#(CONSTR_DECL constructorHeading (EQUALS qualifiedIdentifier)? )
	| 	#(DESTR_DECL destructorHeading (EQUALS qualifiedIdentifier)? )
	;

propertyDecl
	: 
		#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			( s=typeId )?
			(propertySpecifiers)*
		)
	;
//    property Item[Index: OleVariant]: Property_ read Get_Item; default;

propertyParameterList
		{ printRuleName("OPTransformer."+"propertyParameterList"); }
	:	parameterList
	
	;
	
//propertyParameterList!
//{ 	Vector params=null; 
//	CommonAST temp = new CommonAST( new Token(PARAM_LIST));
//	temp.setText("PRPTY_PARAM_LIST");
//}
//	:	#(PRPTY_PARAM_LIST 
//			(	params=parameterSpec!
//				{	for(int i=0;i<params.size();i++)
//			  		temp.addChild((CommonAST)params.elementAt(i));
//				}
//			)+
//		)
//		{ ## = temp; }
//	;
	
propertySpecifiers
	:	
		#( READ id_read:IDENT )
	|	#( WRITE id_write:IDENT )
	| 	#( INDEX
			(	constValue
		//	|	enumDecl
		//	|	setConstructor 
			)? 
		)
	| 	#( STORED propertySpecifiersValue
				//id_store:IDENT 
			)
	|	( #(DEFAULT propertySpecifiersValue)
		|	NODEFAULT 
		)
	| 	IMPLEMENTS 
	;

propertySpecifiersValue
	:(	constValue
	|	enumDecl
	|	setConstructor 
	)
	;

propertyInterface
	:	(propertyParameterList)? 
		s=typeId
	;

	
constructorDecl
	{ printRuleName("OPTransformer."+"constructorDecl");}
	:	#( CONSTR_DECL
	  		constructorHeading // procedureHeading 
  			(declSection[false])+
			compoundStatement
		)
		
	;

constructorHeading
	:	qualifiedIdentifier //IDENT ( DOT^ identifier )*
			( formalParameters )? 
			( directive )*
  	;
	
destructorDecl
	{ printRuleName("OPTransformer."+"destructorDecl");}
	:	#(DESTR_DECL
	  		destructorHeading // procedureHeading 
  			(declSection[false])+
			compoundStatement
		)
	;

destructorHeading
	:	qualifiedIdentifier //IDENT ( DOT^ identifier )*
			( formalParameters )? 
			( directive )*
  	;

