/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 3. Phase: Deklarationen einsammeln und Symboltabellen erstellen
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    

header {	
	package de.fzi.delphi.parser;
	
	// Imports	
	import java.util.Vector;
	import java.util.List;
	import java.util.ListIterator;
	import antlr.collections.AST;	
	import de.fzi.delphi.OPDebug;
	import de.fzi.delphi.OPProjectManager;
	import de.fzi.delphi.symbols.*;
	import de.fzi.delphi.symbols.types.*;
	import de.fzi.delphi.types.Type;
	import de.fzi.delphi.output.IOPOutput;
	import de.fzi.delphi.output.SRFOutput;
	import de.fzi.delphi.CommonASTWithLineNumber;

	import de.fzi.sissy.metamod.Statement;
	import de.fzi.sissy.metamod.SimpleStatement;
	import de.fzi.sissy.metamod.BranchStatement;
	import de.fzi.sissy.metamod.BlockStatement;
	import de.fzi.sissy.metamod.JumpStatement;
	import de.fzi.sissy.metamod.LoopStatement;
	import de.fzi.sissy.metamod.ExceptionHandler;
	import de.fzi.sissy.metamod.ModelElementList;
	import de.fzi.sissy.metamod.CatchBlock;
	import de.fzi.sissy.metamod.Position;
import de.fzi.delphi.PositionElement;
import de.fzi.sissy.util.Debug;

	import de.fzi.delphi.parser.debug.ScopeTree;
}


class OPDeclarationsParser extends OPAnalyzer;
options {
	buildAST=true;
	ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
}
{
	// Debugging Options
	static final boolean DEBUG_ALL = false;
	static final boolean DEBUG_RULENAMES = DEBUG_ALL | false;
	static final boolean DEBUG_RESOLVE  = DEBUG_ALL | false;

	static int statementCounter = 0;

	// return values
	String s; 

	// Instance State Variables
	private boolean isInterfaceSection = false;
	boolean isClassDecl = false; 	
	int currentVisibility = Modified.UNKNOWN;	// current visibility		
	
	// used for keeping track of lines
	private int lastKeywordLine = -1;

	IOPOutput output = null;
	private String unitName="";
	private ScopingEngine scopingEngine;
		
	UnknownClassType createDummyType(String name) {
		// dummy typ 
		UnknownClassType dummyType = new UnknownClassType(name);
		
		// in unresolved Scope ablegen
		Symbol tmpDummySym = OPProjectManager.getUnresolvedScope().addSymbol(dummyType);
		if (tmpDummySym == dummyType) {							
			// create a scope for the dummy 
			try {
				scopingEngine.changeScope(OPProjectManager.getUnresolvedScope());
				scopingEngine.createNewScope(dummyType.getName()).setCorrespondingSymbol(dummyType); 	
				scopingEngine.prevScope();
				scopingEngine.prevScope();				
			} catch (ScopingException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		else
			dummyType = (UnknownClassType)tmpDummySym;
		return dummyType;
	}

	UnknownClassType createMissingInterface(String fqn) {
		// dummy typ 
		int pos = fqn.lastIndexOf(".");
		assert (pos >= 0);
		 
		String name = fqn.substring(pos+1);
		String prefix = fqn.substring(0, pos);
		System.err.println("Create missing interface: " + prefix + "." + name);
		UnknownClassType missing = new UnknownClassType(name);
		
		Scope scope = scopingEngine.getRootScope().getScope(prefix);
		Symbol tmpSym = scope.addSymbol(missing);
		if (tmpSym == missing) {							
			try {
				scopingEngine.changeScope(scope);
				scopingEngine.createNewScope(missing.getName()).setCorrespondingSymbol(missing); 
				scopingEngine.prevScope();
				scopingEngine.prevScope();					
			} catch (ScopingException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		else
			missing = (UnknownClassType)tmpSym;
		return missing;
	}

void annotatePosElement(Statement stm, CommonASTWithLineNumber ast_in) {
	  PositionElement posElement = #ast_in.getPositionElement();
  if (posElement!=null) {
      stm.setPosition(new Position(null, posElement.getStartLine(), posElement.getStartColumn(), posElement.getEndLine(), posElement.getEndColumn()));
      //System.out.println("PositionElement for SimpleStatement found: "+posElement);
  }
	}
	
	void annotatePosElement(Symbol symbol, CommonASTWithLineNumber ast_in) {
	  PositionElement posElement = #ast_in.getPositionElement();
  if (posElement!=null) {
      symbol.setPositionElement(posElement);
      //System.out.println("PositionElement for SimpleStatement found: "+posElement);
  } else {
  	Debug.warning("Null-Annotation-of-Position-for-Symbol: "+symbol.toString());
  }
	}
	
	void markAttributeDeclaration(Scope location, Attribute v){
//		we print the whole scope later ...
//		if( output != null )
//			output.markAttributeDeclaration(location,v);
	}
		
	void markTypeDeclaration(Scope location, Type t){
//		we print the whole scope later ...
//		if( output != null )
//			output.markTypeDeclaration(location,t);
	}

	void markMethodDeclaration(Scope location, Method f) {
//		we print the whole scope later ...
//		if( output != null )
//			if( f != null ){
//				output.markMethodDeclaration(location, f);
//			}
	}
	
	void markNewCompilationUnit(String name){
//		we print the whole scope later ...
//		if( output != null )
//			output.markNewCompilationUnit(name);
	}
	
	void markUsesCompilationUnit(Scope s, String name){
		if( output != null ){
			// Output Unit-Entity if not on Project-List
			String unitName = name;
			
			if( unitName.indexOf('.') != -1 ) // -> contains '.'
				unitName = unitName.substring(unitName.lastIndexOf('.')+1);
				
			if( OPProjectManager.getProjectListEntry(unitName) == null ){
				output.markNewCompilationUnit(name);
			}
			output.markUsesCompilationUnit(s,name);
		}
	}

	void print(Object output){
		System.err.print(output);
		System.err.flush();
	}

	void println(Object output){
		print(output);
		System.err.println();
		System.err.flush();
	}

	void println(){
		println( "" );
	}

	void printRuleName(String rulename){
		if( !DEBUG_RULENAMES ) 
			return;
		println(rulename);
	}

	public Method methodDeclarationAction(String qid, List parameterList, String returnTypeIdent, 
			int category,
			boolean isClassMethod, 
			boolean isOverloaded, 
			boolean isAbstract, 
			boolean isVirtual, 
			boolean isOverride){
			
			Method proc=null;
			
			// return type of a constructor is the type of the enclosing class
			Type returnType = Type.NULL;

			// used to store the scope, where the declaration belongs to
			Scope declarationScope=null;

			String methodName = qid;
			String fqn = null;
			String prefix = null;

			// Split qualified identifier in prefix and name
			int pos = qid.lastIndexOf(".");
			if (pos >= 0) { 
				methodName = qid.substring(qid.lastIndexOf(".")+1);
				prefix = qid.substring(0, qid.lastIndexOf("."));
			}
			
			// Try to resolve prefix
			if (prefix != null) {

				Symbol tmpSym = scopingEngine.resolve(prefix);
				if (tmpSym != null) {
					// Possible assertation: tmpSym.isType == true

					if (!tmpSym.getScope().isUnresolvedScope() && tmpSym.isType()) {
						declarationScope = ((Type) tmpSym).getCorrespondingScope();					
					} else { 
						// This is a hack for subinterfaces and COM	
						System.err.println("Declaration of method " +  methodName + " for previously unknown type " + prefix);					
						String unitScopeName = scopingEngine.getCurrentScope().getCompilationUnit().getCorrespondingScope().getFullName();
						declarationScope = createMissingInterface(unitScopeName + "." + prefix).getCorrespondingScope();
					}
					fqn = declarationScope.getFullName() + "." + methodName;	
					prefix = declarationScope.getFullName();

				}
			} 
			
			if (fqn == null) {

				fqn = Scope.calculateFullPath(
						scopingEngine.getCurrentScope().getFullName(), qid);
						
				prefix = fqn.substring(0, fqn.lastIndexOf("."));				
								// prfen, ob Scope schon existiert?
				
				declarationScope=scopingEngine.getRootScope().getScope(prefix);
			}

				// sind wir schon drin?
			if( declarationScope != scopingEngine.getCurrentScope() ){
				if( declarationScope == null ) 	{
					// einen neuen Scope erzeugen
					declarationScope = scopingEngine.createNewScopeAbs(prefix);
				} else {					// in den (vorhandenen) Scope wechseln 
					try {
						declarationScope = scopingEngine.changeScope(scopingEngine.getRootScope().getScope(prefix));
					} catch (ScopingException e) {
							// TODO Auto-generated catch block
						e.printStackTrace();
					}			
				}
			}
			
			if( parameterList != null ){ 
				fqn += "/"+Method.parameterListToString(parameterList);
			}

			
			// Methodenobjekt anlegen
			Method m = new Method(methodName);

			/*
			 * Return types
			 */
			if( category == Method.CONSTRUCTOR ){
				// returntype berechnen (=classtype)
				// go up one level
				String className = scopingEngine.getCurrentScope().getName();
							
				// Klasse holen, zu der der Konstruktors gehrt
				Symbol sym = scopingEngine.resolve(className);
				// Return-Typ eines Konstruktors ist seine Klasse										
				if( sym instanceof Type )
					returnType = (Type)sym;
				else{
					returnType = createDummyType(className);
				}
			}else if( category == Method.FUNCTION ){
				if( returnTypeIdent != null ){	 
					// rckgabewert auflsen
	  				// OLD Symbol sym1 = scopingEngine.getCurrentScope().resolve(t);
	  				Symbol sym = scopingEngine.resolve(returnTypeIdent);
					if( sym != null && sym.isInstanceOf("Type") )
						returnType = (Type)sym;
					else{
						returnType = createDummyType(returnTypeIdent);
						// wird dann im zweiten Durchgang aufgelst
						// da zum jetzigen Zeitpunkt der aktuelle Scope noch ohne
						// die Informationen des Root-Scopes ist
					}
				}else{
					// kein Typ angegeben, dann muss schon eine Deklaration vorliegen
					// auflsen
					System.err.println("Warnung: Funktionsdeklaration fr " + m.toString() + " hat keinen Rckgabetyp");
					// FIXME Sinnvollen Rckgabetyp verwenden
					returnType = createDummyType("{unknown}");
				}
			} else // PROCEDURE, DESTRUCTOR
				;
			
			
			// Eigenschaften setzen
			m.setType(returnType);
			m.setInterfaceDeclaration(isInterfaceSection);
			m.setVisibility(currentVisibility);	// Sichtbarkeit der Umgebung setzen
			m.setClassMethod(isClassMethod);
			m.setOverloaded(isOverloaded);
			m.setCategory(category);
			m.setAbstract(isAbstract);
			m.setVirtual(isVirtual);
			m.setOverride(isOverride);
			// Parameter zur Methode hinzufgen
			if( parameterList != null )	
				m.setParameters(parameterList);
			
			if (!isInterfaceSection && (qid.indexOf(".") != -1 )) {
				Symbol tmpMet;
				if (parameterList != null)
					tmpMet = scopingEngine.resolveMethod(m);
				else {
					String tmpName;
					if (prefix == null)
						tmpName = m.getName();
					else
						tmpName = prefix + "." + m.getName();
					tmpMet = scopingEngine.resolve(tmpName);
				}
				if (tmpMet != null && tmpMet.isInstanceOf("Method"))
					m = (Method)tmpMet;
			}
			
			
			// und zum Parent-Scope hinzufgen...
			proc = (Method)scopingEngine.getCurrentScope().addSymbol( m );
			assert proc != null; // Success?

			Scope corScope = null;

			// Scope der Methode erzeugen und wechseln
			if( qid.indexOf(".") != -1 ){ // enthlt punkt?
				// prfen, ob Scope schon existiert?
				Scope scope=scopingEngine.getRootScope().getScope(fqn);

				if( scope == null ) {	// einen neuen Scope erzeugen
					scope = scopingEngine.createNewScopeAbs(fqn);
				} else 					// in den (vorhandenen) Scope wechseln wechseln
					try {
						scopingEngine.changeScope(scopingEngine.getRootScope().getScope(fqn));
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}			
				corScope = scope;	
			}
			else {
				// neuen Scope erzeugen und ffnen
				corScope = scopingEngine.createNewScope(m.getNameWithParameters());
			}
			// corScope is not needed any more ...
			assert corScope == scopingEngine.getCurrentScope();

			corScope.setCorrespondingSymbol(m);		
			
			// Parameter zum Methoden-Scope hinzufgen
			if( parameterList != null ){
				ListIterator li = parameterList.listIterator();

				while( li.hasNext() ){
					corScope.addSymbol((Symbol)li.next());
				}
			}

			// nicht-aufgelster Rckgabetyp
			if( ( category == Method.CONSTRUCTOR || category == Method.FUNCTION )
					&& returnType != null && returnType.isInstanceOf("UnknownClassType") ){
				// save reference
				((UnknownClassType)returnType ).addReference( m );
				// add to unknown-scope					
				OPProjectManager.getUnresolvedScope().addSymbol(returnType);
			}
						
			return proc;	
	}


	// Wrapper for changed signature of rule typeId
/*	public final String typeId(AST _t) throws RecognitionException {
		return typeId( _t,null);
	}*/
}

goal returns [Scope scope=null;]
{
	output = OPProjectManager.getOutput();

//	try{
//		output = new SRFOutput( new FileOutputStream("declarations.srf") );
//	}catch( FileNotFoundException e ){
//		output = new SRFOutput( System.out );
//	}
//	
	scopingEngine = new ScopingEngine(
		OPProjectManager.getProjectScope()
		);
		
	// check some assertions
	assert scopingEngine.getCurrentScope() != null;
	assert scopingEngine.getCurrentScope().isRootScope();
}
	: 
	(		program
		|	package_
		|	library_
		|	unit
			
	)
	{
		try {
			System.err.println("Rule goal: Scope was: " + scopingEngine.getCurrentScope().getFullName());
			// scopingEngine.prevScope();
			if (scopingEngine.getCurrentScope() != scopingEngine.getRootScope()) 
				scopingEngine.changeScope(scopingEngine.getRootScope());
		} catch (ScopingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		scope = scopingEngine.getRootScope();
	}
    ;

programHeading
	{   printRuleName("OPDeclarationsParser."+"programHeading"); 
	}
	:	#(PROGRAM  id:IDENT 
			{	
				if( output != null && output instanceof SRFOutput ){
					output.printCommentLine("declarations of "+#id.getText());
					((SRFOutput)output).setRootScopeName(#id.getText());
					((SRFOutput)output).writeHeader();
				}
				unitName = id.getText();

				CompilationUnit compilationUnit = new CompilationUnit(unitName);
				Scope compilationUnitScope = scopingEngine.createNewScope(unitName); // open Root Scope
				compilationUnitScope.setCorrespondingSymbol(compilationUnit);
				
				markNewCompilationUnit(scopingEngine.getRootScope().getFullName()+"."+unitName);
				scopingEngine.getRootScope().addSymbol(compilationUnit);
			}
			( #(IDLIST (IDENT)*) )?
		)
	;

package_
	{ printRuleName("OPDeclarationsParser."+"package"); }
	:	#(PACKAGE
			id:IDENT 
			{					
				unitName = id.getText();

				CompilationUnit compilationUnit = new CompilationUnit(unitName);
				Scope compilationUnitScope = scopingEngine.createNewScope(unitName); 
				compilationUnitScope.setCorrespondingSymbol(compilationUnit);

				markNewCompilationUnit(scopingEngine.getRootScope().getFullName()+"."+unitName );
				scopingEngine.getRootScope().addSymbol(compilationUnit);
			}
			(containsClause)?
		)
	;


library_
	{ printRuleName("OPDeclarationsParser."+"library"); }
	:	#(LIBRARY
			id:IDENT 
			{	
				if( output != null && output instanceof SRFOutput ){
					output.printCommentLine("declarations of "+#id.getText());
					((SRFOutput)output).setRootScopeName(#id.getText());
					((SRFOutput)output).writeHeader();
				}
				
				unitName = id.getText();

				CompilationUnit compilationUnit = new CompilationUnit(unitName);
				Scope compilationUnitScope = scopingEngine.createNewScope(unitName); 
				compilationUnitScope.setCorrespondingSymbol(compilationUnit);

				markNewCompilationUnit(scopingEngine.getRootScope().getFullName()+"."+unitName );
				scopingEngine.getRootScope().addSymbol(compilationUnit);
			}
			programBlock
		)
	;

	
unit
	{ printRuleName("OPDeclarationsParser."+"unit"); }
	:	#(UNIT
			id:IDENT 
			{	
				if( output != null && output instanceof SRFOutput ){
					output.printCommentLine("declarations of "+#id.getText());
					((SRFOutput)output).setRootScopeName(#id.getText());
					((SRFOutput)output).writeHeader();
				}
				
				unitName = id.getText();

				CompilationUnit compilationUnit = new CompilationUnit(unitName);
				Scope compilationUnitScope = scopingEngine.createNewScope(unitName); 
				compilationUnitScope.setCorrespondingSymbol(compilationUnit);

				markNewCompilationUnit(scopingEngine.getRootScope().getFullName()+"."+unitName );
				scopingEngine.getRootScope().addSymbol(compilationUnit);
			}
			( directive	)? 
			unitBody
		)
	;
	

usesClause
	{ printRuleName("OPDeclarationsParser."+"usesClause"); 
		Vector temp;
	}
	:	#(USES 
			temp=identList
		)
		{
			OPDebug.debugPrint(5,"Uses:");
			Scope unitScope=null;
			unitScope = scopingEngine.getCurrentScope();
			CompilationUnit compilationUnit = unitScope.getCompilationUnit();
			
			for(int i=0;i<temp.size();i++){
				String unitName = ((CommonASTWithLineNumber)temp.elementAt(i)).getText();
				
				OPDebug.debugPrint(5,unitName+" ");
				OPProjectManager.readDeclarationsFromCompilationUnit(unitName);

				// Macht nur Sinn, wenn der UnitScope schon existiert ...
				// sollte er aber, wenn oben die Deklarationen eingelesen wurden
				Scope usedUnitScope = OPProjectManager.getProjectScope().getSubScope(unitName);
				
				// nur zur Liste hinzufgen, wenn gelesen wurde
				if( usedUnitScope != null ){
					if( isInterfaceSection )
						compilationUnit.addInterfaceUses(usedUnitScope);
					else
						compilationUnit.addImplementationUses(usedUnitScope);
					markUsesCompilationUnit(
							scopingEngine.getCurrentScope(),
							usedUnitScope.getFullName()
						);
				}else{
					markUsesCompilationUnit(
							scopingEngine.getCurrentScope(),
							scopingEngine.getRootScope().getFullName()+"."+unitName
						);
				}
			}
			
			OPDebug.debugPrintln(5,"");
		}
	;

containsClause
	{ printRuleName("OPDeclarationsParser."+"containsClause"); 
		Vector temp;
	}
	:	#(CONTAINS 
			temp=identList
		)
		{
			OPDebug.debugPrint(5,"Contains:");
			Scope unitScope=null;
			unitScope = scopingEngine.getCurrentScope();
			CompilationUnit compilationUnit = unitScope.getCompilationUnit();
			
			for(int i=0;i<temp.size();i++){
				String unitName = ((CommonASTWithLineNumber)temp.elementAt(i)).getText();
				
				OPDebug.debugPrint(5,unitName+" ");
				OPProjectManager.readDeclarationsFromCompilationUnit(unitName);

				// Macht nur Sinn, wenn der UnitScope schon existiert ...
				// sollte er aber, wenn oben die Deklarationen eingelesen wurden
				Scope usedUnitScope = OPProjectManager.getProjectScope().getSubScope(unitName);
				
				// nur zur Liste hinzufgen, wenn gelesen wurde
				if( usedUnitScope != null ){
					compilationUnit.addInterfaceUses(usedUnitScope);
					markUsesCompilationUnit(
							scopingEngine.getCurrentScope(),
							usedUnitScope.getFullName()
						);
				}else{
					markUsesCompilationUnit(
							scopingEngine.getCurrentScope(),
							scopingEngine.getRootScope().getFullName()+"."+unitName
						);
				}
			}
			
			OPDebug.debugPrintln(5,"");
		}
	;

initSection
	{ 
		if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"initSection"); 
		ModelElementList mel = null;
	}
	
	:	#(kw:INITIALIZATION { lastKeywordLine = #kw.getLine(); }
	  		
			{ 	
				Method initializer = methodDeclarationAction(
					"[initialization]", 
					null,			// paramlist
					null,				// return-type
					Method.UNIT_INITIALIZER,	// category
					false, 
					false, 
					false, 
					false, 
					false);
				markMethodDeclaration(scopingEngine.getCurrentScope(), initializer);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		  	
			(mel=statementList 
				{
					BlockStatement block = new BlockStatement(); 
					block.setStatements(mel);
					initializer.setBody(block);
				}  
			)
			( finalization )?
		)
//	| 	compoundStatement
	;

finalization
	{ 
		if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"finalization"); 
		ModelElementList mel = null;
	}
	
	:   #(kw:FINALIZATION { lastKeywordLine = #kw.getLine(); }
	  		
			{ 	
				Method finalizer = methodDeclarationAction(
					"[finalization]", 
					null,			// paramlist
					null,				// return-type
					Method.UNIT_FINALIZER,	// category
					false, 
					false, 
					false, 
					false, 
					false);
				markMethodDeclaration(scopingEngine.getCurrentScope(), finalizer);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		  	
			(mel=statementList 
				{
					BlockStatement block = new BlockStatement(); 
					block.setStatements(mel);
					finalizer.setBody(block);
				}  
			)
		)
		;

varDecl 
	{ 
		if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"varDecl"); 
		String t=null;
	}
  	:	#(vd:VAR_DECL
	  		#( id:IDENT 
	  			(	
	  				t=typeId
	  				{ 
						Type type=null;
						Attribute v=null; 
	  					// resolve type of attribute
	  					// OLD Symbol typeSym = scopingEngine.getCurrentScope().resolve(t);
	  					Symbol typeSym = scopingEngine.resolve(t);

						// type could be resolved
						if( typeSym != null 
							&& typeSym.isInstanceOf("Type")
							){
							type = (Type)typeSym;

							// add attribute to scope 
	  						v=(Attribute)scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(),type,currentVisibility) ); 
	  						v.setLine(id.getLine());
	  						v.setInterfaceDeclaration(isInterfaceSection);
	  						annotatePosElement(v, #vd_in);
	  						
	  						if( typeSym.isInstanceOf("UnknownSymbol") ){
								// save reference
								((UnknownSymbol)typeSym).addReference(v);
	  						}
						}else if( t != null ){ // unable to resolve type -> unknown type
							Type tempType = createDummyType(t);
							
							v=(Attribute)scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(),tempType,currentVisibility) );
	  						v.setLine(id.getLine());
							v.setInterfaceDeclaration(isInterfaceSection);
								  						annotatePosElement(v, #vd_in);
	
							// add to unknown-scope					
							OPProjectManager.getUnresolvedScope().addSymbol(tempType);
							// save reference
							((UnknownClassType)tempType).addReference(v);
							
	  					}else{
							v=(Attribute)scopingEngine.getCurrentScope().addSymbol( 
								new Attribute(id.getText(),NilType.get(),currentVisibility) 
							);
	  						v.setLine(id.getLine());
	  						v.setInterfaceDeclaration(isInterfaceSection);
	  							  						annotatePosElement(v, #vd_in);
	
						}	

						// mark the declaration
						markAttributeDeclaration(scopingEngine.getCurrentScope(),v);
	  				}
	  			|	range
	  				{	
						Type tempType = new UnknownClassType("dummy:range");
  						tempType.setInterfaceDeclaration(isInterfaceSection);
						// add type to unknown-scope					
						OPProjectManager.getUnresolvedScope().addSymbol(tempType);
	  					// add symbol and back reference
	  					Symbol v = null;
	  					((UnknownClassType)tempType).addReference(v=scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(),tempType) )); 
	  						  						annotatePosElement(v, #vd_in);
	  				}
	  			) 
	  		)
  		) 
  	;

constDeclSection
	{
		if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"constDecl");
		String t=null; 
	}
	:	
		#( CONST 
			(	
				#( ASSIGN	
						id:identifier 
						(	t=typeId	
							{ 
								// OLD Symbol sym =scopingEngine.getCurrentScope().resolve(t); 
								Symbol sym =scopingEngine.resolve(t); 
								Type type = null;
								if( sym != null && sym.isInstanceOf("Type") )
									type = (Type)sym;
								
								// unable to resolve type
			  					if( type == null ){
									UnknownClassType tempType = createDummyType(t);
									
									Symbol s  = scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(),tempType) );
									s.setInterfaceDeclaration(isInterfaceSection);
									  						  						annotatePosElement(s, #id_in);
	
																		
									// save reference
									tempType.addReference(s);

									// add to unknown-scope					
									OPProjectManager.getUnresolvedScope().addSymbol(tempType);

			  					}
			  					else{ // add to scope
									Symbol s = scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(),type) ); 
									s.setInterfaceDeclaration(isInterfaceSection);
																											  						  						annotatePosElement(s, #id_in);
	  					}
							}
						| 	()			
							{		// add to scope
									// correction ==> null-type is not adequate ==> look up primitive type e. g. integer
									Symbol s = scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText(), OPProjectManager.getConstantType()) ); 
									s.setInterfaceDeclaration(isInterfaceSection);
																  						  						annotatePosElement(s, #id_in);
	}
						) 
						(	expression
						|	objectInitialization
						)
				)
			 )+
		)
	;

propertyDecl
	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"propertyDecl"); 
			String t=null,qid=null; 
		}
	: 
		#( PRPTY_DECL
			qid=qualifiedIdentifier
			(propertyParameterList)?
			( t=typeId )?
//			(propertySpecifiers)*
			(
				#( READ id_read:IDENT )
			|	#( WRITE id_write:IDENT )
			| 	#( INDEX
					(	constValue
				//	|	enumDecl
				//	|	setConstructor 
					)? 
				)
			| 	#( STORED propertySpecifiersValue
						//id_store:IDENT 
					)
			|	( #(DEFAULT propertySpecifiersValue)
				|	NODEFAULT 
				)
			| 	IMPLEMENTS 
			)*
			{ 	// resolve Type
				if( t != null ){
					Type type = scopingEngine.resolveType(t);
					boolean saveRef = false;
					if( type == null ){
			  			type = createDummyType(t);
			  			
						// add to unknown-scope					
						OPProjectManager.getUnresolvedScope().addSymbol(type);
						saveRef = true;
					}

		  			Property prop = new Property(qid,type);
		  			// MB: Visibility
					prop.setVisibility(currentVisibility);
					  						  
					  						  						annotatePosElement(prop, #propertyDecl_in);
				
					if (saveRef) {
						// save reference
						((UnknownClassType)type).addReference(scopingEngine.getCurrentScope().addSymbol( prop ));
					}

					// In a write specifier, if fieldOrMethod is a method, it must be a procedure that takes a single value or const parameter of the same type as the property (or more, if it is an array property or indexed property).
		  			if( id_write != null ){
						ModifiedSymbol accessor = (ModifiedSymbol)scopingEngine.resolve(id_write.getText());
						if (accessor == null) {
							accessor = new Method( id_write.getText() );
							OPDebug.debugPrintln(5, "propertydecl: Unresolved setter specifier for property " + prop.getFullName());
						}
		  				prop.setSetter( accessor );
		  			}
		  			// In a read specifier, if fieldOrMethod is a method, it must be a parameterless function whose result type is the same as the property's type. (An exception is the access method for an indexed property or an array property. See index specifiers IDH_OP_indexSpecifiers and array properties.)
		  			
		  			if( id_read != null ){
						ModifiedSymbol accessor = (ModifiedSymbol)scopingEngine.resolve(id_read.getText());
						if (accessor == null) {
							accessor = new Method( id_read.getText() );
							OPDebug.debugPrintln(5, "propertydecl: Unresolved getter specifier for property " + prop.getFullName());
						}
		  				prop.setGetter( accessor );
					}
					prop.setInterfaceDeclaration(isInterfaceSection);
					
					scopingEngine.getCurrentScope().addSymbol( prop  );
				}else{
					// FIXME: get supertype-scope and try to resolve there
					// Besser: komplettes Objekt der Oberklasse kopieren
					// und nur die Sichtbarkeit ndern.

					Symbol s = scopingEngine.getCurrentScope().getCorrespondingSymbol();
					
					if ((s != null) && s.isInstanceOf("ClassType")
						&& ((ClassType)s).getSuperClasses() != null
						&& ((ClassType)s).getSuperClasses().size() > 0) {
							ListIterator li =
								((ClassType)s).getSuperClasses().listIterator();
							while( li.hasNext() ){
								Type currentType = ((Type)li.next());
								if( qid != null
									&& currentType != null
								 	&& currentType.isInstanceOf("SubScoped") ){
										Scope scopeOfType = ((SubScoped)currentType).getSubScope();
																			
										if( scopeOfType == null )
											continue;
										
										Symbol rSym = null;
										try {
											scopingEngine.changeScope(((SubScoped)currentType).getSubScope());
											rSym=scopingEngine.resolve(qid);
											scopingEngine.prevScope();
										} catch (ScopingException e) {
											// TODO Auto-generated catch block
											e.printStackTrace();
										}
													
										if( rSym  != null && rSym.isInstanceOf("Property") ){
											Property newProp = (Property)((Property)rSym).clone();
											
											newProp.setScope(scopingEngine.getCurrentScope());
											newProp.setInterfaceDeclaration(isInterfaceSection);
											
											scopingEngine.getCurrentScope().addSymbol( newProp );
											break;
										}
								 	}
							}
						}			
				}
			}
		)
	;

procedureDecl [boolean isInnerDecl]
	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"procedureDecl"+(isInnerDecl?" INNER PROCEDURE":"")); 
		Method f=null;
		Statement stm = null;
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:	#(pd:PROC_DECL { lastKeywordLine = #pd.getLine(); 
System.out.println(#pd.getText());
System.out.println(#pd.getPositionElement().getStartLine()	);
	System.out.println(#pd.getPositionElement().getStartColumn()	);
	System.out.println(#pd.getPositionElement().getEndLine()	);
	System.out.println(#pd.getPositionElement().getEndColumn()	);
	}
	  		f=procedureHeading 
  			(declSection[false])*
			(stm=compoundStatement {f.setBody((BlockStatement)stm);})?
			{ 	
				markMethodDeclaration(scopingEngine.getCurrentScope(), f);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
															  						  						annotatePosElement(f, #procedureDecl_in);
				
				try {
					scopingEngine.changeScope(entryScope);
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}
		)
	;

procedureHeading returns [Method proc=null;]
	{	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"procedureHeading");	
		List parameterList=null;
		String qid;
		boolean isClassMethod = false;
		boolean isOverloaded = false;
		boolean isAbstract = false;
		boolean isVirtual = false;
		boolean isOverride = false;
	}
	:(	CLASS 	{ isClassMethod = true; }	)?
		qid=qualifiedIdentifier 
		{
		}
		( parameterList=formalParameters ) ?
		( 
			{ int dir; }
			dir=directive 
			{	// direktiven auswerten
				if ( dir == OVERLOAD ) isOverloaded = true; 
				if ( dir == ABSTRACT ) isAbstract = true;
				if ( dir == VIRTUAL || dir == DYNAMIC) isVirtual = true;
				if ( dir == OVERRIDE ) isOverride = true;;
			}
		)*
		{
			assert qid != null: "procedureHeading: qid == null"; 
			proc=methodDeclarationAction(
				qid,parameterList,
				null,				// return-type
				Method.PROCEDURE,	// category
				isClassMethod, 
				isOverloaded, 
				isAbstract, 
				isVirtual, 
				isOverride
			);
		}
  	;
  	

directive returns [int ddret=0;] // returns the tokentype of the directive
	:	#(DIRECTIVE 
			(   ABSTRACT { ddret = ABSTRACT; }
			|   OVERLOAD { ddret = OVERLOAD; }
			|   VIRTUAL { ddret = VIRTUAL; }
			|   OVERRIDE { ddret = OVERRIDE; }
			|   DYNAMIC { ddret = DYNAMIC; }
			|	( . )
			)
		)
	;

functionDecl [boolean isInnerDecl]
	{ 	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"functionDecl"+(isInnerDecl?" INNER FUNCTION":"")); 
		Method f = null;
		Statement stm = null;
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:	#(fd:FUNC_DECL {lastKeywordLine = #fd.getLine(); }
	  		f=functionHeading 
  			(
	  			declSection[true]
  			)*
			{ 	
				markMethodDeclaration(scopingEngine.getCurrentScope(), f);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
																			  						  						annotatePosElement(f, #functionDecl_in);
				
			}
			(stm=compoundStatement {f.setBody((BlockStatement)stm);})?
			{ 
				try {
					scopingEngine.changeScope(entryScope);
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}
		)
//			{ if( isInnerDecl ) 
//				##.addChild(
//						((new CommonASTWithLineNumber(new Token(INNER_DECL))))
//					);
//				
//			}
				;

functionHeading returns [Method func=null;]
	{ 	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"functionHeading"); 
		String t=null,qid=null;
		List parameterList=null;
		boolean isClassMethod = false;
		boolean isOverloaded = false;
		boolean isAbstract = false;
		boolean isVirtual = false;
		boolean isOverride = false;
	}
	: 	(	CLASS 	{ isClassMethod = true; } )?
		qid=qualifiedIdentifier 
		( parameterList=formalParameters )? 
		(	t=typeId 	)?
		( 	{ int dir; }
			dir=directive 
			{	// direktiven auswerten
				if ( dir == OVERLOAD ) isOverloaded = true; 
				if ( dir == ABSTRACT ) isAbstract = true;
				if ( dir == VIRTUAL || dir == DYNAMIC) isVirtual = true;
				if ( dir == OVERRIDE ) isOverride = true;
			}
		)*
		{
			assert qid != null: "functionHeading: qid == null"; 
			
			func=methodDeclarationAction(
				qid,parameterList,
				t,				// return-type
				Method.FUNCTION,	// category
				isClassMethod, 
				isOverloaded, 
				isAbstract, 
				isVirtual, 
				isOverride
			);
		}
  	;

constructorDecl
	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"constructorDecl"); 
		Method f=null;
		Statement stm = null;
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:	#(cd:CONSTR_DECL { lastKeywordLine = #cd.getLine(); }
	  		f=constructorHeading 
  			(declSection[false])*
			(stm=compoundStatement {f.setBody((BlockStatement)stm);})?
			{ 	
				markMethodDeclaration(scopingEngine.getCurrentScope(), f);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
																							  						  						annotatePosElement(f, #constructorDecl_in);
				
			}
			{ 
				try {
					scopingEngine.changeScope(entryScope);
					// scopingEngine.changeScope(entryScope);
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		)
	;

constructorHeading returns [Method constructor=null;]
{	
	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"constructorHeading"); 
	String qid;
	List parameterList = null;
	boolean isClassMethod = false;
	boolean isOverloaded = false;
	boolean isAbstract = false;
	boolean isVirtual = false;
	boolean isOverride = false;
}
	:	(	CLASS 	{ isClassMethod = true; }	)?
		qid=qualifiedIdentifier 
		{
		}
		( parameterList=formalParameters ) ?
		( 
			{ int dir; }
			dir=directive
			{ 
				if ( dir == OVERLOAD ) isOverloaded = true; 
				if ( dir == ABSTRACT ) isAbstract = true;
				if ( dir == VIRTUAL || dir == DYNAMIC) isVirtual = true;
				if ( dir == OVERRIDE ) isOverride = true;
			}
			
		)*
		{
			assert qid != null: "constructorHeading: qid == null"; 
			constructor=methodDeclarationAction(
				qid,parameterList,
				null,				// return-type
				Method.CONSTRUCTOR,	// category
				isClassMethod, 
				isOverloaded, 
				isAbstract, 
				isVirtual, 
				isOverride
			);
		}
  	;

declSection [boolean isInnerDecl]
	{ printRuleName("OPDeclarationsParser."+"declSection"); }
	:	#( DECL_SECT 
			(
				basicDecl 
			|	procedureDecl[isInnerDecl]
			| 	functionDecl[isInnerDecl]
	    	|	constructorDecl
    		|	destructorDecl
			)?
	   	)
	;
	
destructorDecl
{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"destructorDecl"); 
	Method f=null;
	Statement stm = null;
	Scope entryScope = scopingEngine.getCurrentScope();
}
	:	#(dd:DESTR_DECL {lastKeywordLine = #dd.getLine(); }
	  		f=destructorHeading 
  			(declSection[false])*
			(stm=compoundStatement {f.setBody((BlockStatement)stm);})?
			{ 	
				markMethodDeclaration(scopingEngine.getCurrentScope(), f);
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
																											  						  						annotatePosElement(f, #destructorDecl_in);
				
			}
			{ 
				try {
					scopingEngine.changeScope(entryScope);
					// scopingEngine.changeScope(entryScope);
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		)
	;
	
destructorHeading returns [Method destructor=null;]
{	
	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"destructorHeading"); 
	String qid;
	List parameterList = null;
	boolean isClassMethod = false;
	boolean isOverloaded = false;
	boolean isAbstract = false;
	boolean isVirtual = false;
	boolean isOverride = false;
}
	:	(	CLASS 	{ isClassMethod = true; }	)?
		qid=qualifiedIdentifier 
		{
		}
		( parameterList=formalParameters ) ?
		( 
			{ int dir; }
			dir=directive 
			{
				if ( dir == OVERLOAD ) isOverloaded = true; 
				if ( dir == ABSTRACT ) isAbstract = true;
				if ( dir == VIRTUAL || dir == DYNAMIC) isVirtual = true;
				if ( dir == OVERRIDE ) isOverride = true;
			}	
		)*
		{
			assert qid != null: "destructorHeading: qid == null"; 
			destructor=methodDeclarationAction(
				qid,parameterList,
				null,				// return-type
				Method.DESTRUCTOR,	// category
				isClassMethod, 
				isOverloaded, 
				isAbstract, 
				isVirtual, 
				isOverride
			);
		}
  	;

parameterList returns [List list=new Vector();]
{	
	String t=null; 
}
	:	#(PARAM_LIST
			(
				#( ps:PARAM_SPEC 
					(VAR|CONST|OUT)?
					id:identifier
						(	t=typeId )?	
							{ 
								
								Symbol currentParam;
								if( t != null ){
									Type type = scopingEngine.resolveType(t);
									
				  					if( type == null ){
				  						// tag as unknown
				  						UnknownClassType tempType = createDummyType(t);
										currentParam=new Attribute(id.getText(),tempType);

										tempType.setInterfaceDeclaration(isInterfaceSection);

										// add to unknown-scope					
										OPProjectManager.getUnresolvedScope().addSymbol(tempType);
										
										// save reference
										tempType.addReference(currentParam);
				  					}
				  					else // add to current scope
										currentParam=new Attribute(id.getText(),type); 
																							}else{ // no type 
									currentParam=new Attribute(id.getText(),Type.NULL); 
																							}									
								list.add(currentParam);
  						  						annotatePosElement(currentParam, #ps_in);
				}
						
				)
			)+
		)
	;

formalParameters returns [List list=null;]
	:	list=parameterList
	;

typeDecl
	{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"); }
	:   #( TYPE_DECL id:IDENT	
			{ if( DEBUG_RULENAMES ) {
					print( ": "+id.getText()); 
					println( ", l."+id.getLine()); 
				}
			}
			( DEREF )? // tauschen mit deref aus Recorddecl.: ( DEREF )?
		   	(	
				{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-typeId"); }
		   		{ Type t; }
		   		t=typeId_
		    		{  
						// BaseTyp auflsen und setzen
		    			Symbol thisTypesType = scopingEngine.resolve(t);
		    			if( thisTypesType != null && thisTypesType.isInstanceOf("Type") ){
			    			Type userType = new UserDefinedType(id.getText(),(Type)thisTypesType ) ;
			    			userType.setInterfaceDeclaration(isInterfaceSection);
  						  						annotatePosElement(userType, #typeDecl_in);
				
							scopingEngine.getCurrentScope().addSymbol(
								userType
							); 
		    			}
					}
			|	
				{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-arrayDecl"); }
				{ 
					ArrayType arrayType = null;
				}
			    	(packed1:PACKED)? arrayType=arrayDecl (packed2:PACKED)?
		    		{
		    			// set packed flag
		    			if( arrayType != null && (packed1 != null || packed2 != null) ){
		    				arrayType.setPacked(true);	
		    			}
		    		}
		   	|	// FIXME HG/MB: Nchste Zeile entfernen?
				( DEREF	)? 
				{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-RECORD_DECL"); }
				recordDecl
			|	{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-CLASS_DECL"); }
				classDecl[id]
			|	{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-INTERFACE_DECL"); }
				interfaceDecl[id] 
			|	{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-DISPINTERFACE_DECL"); }
				dispInterfaceDecl[id]
			|   {	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-range"); }
				range
		//	|	proceduralType
			)
	)
	;

recordDecl returns [RecordType recordType=null;]
	{	printRuleName("OPDeclarationsParser."+"recordDecl"); 
	}
	:	#( RECORD_DECL 
				{	
						// TODO RecordType ausprogrammieren
						// new type
						recordType = (RecordType)scopingEngine.getCurrentScope().addSymbol(
								new RecordType()
							);
						
						  						  						annotatePosElement(recordType, #recordDecl_in);
				recordType.setInterfaceDeclaration(isInterfaceSection);
						// new scope
						Scope corScope = scopingEngine.createNewScope(recordType.getName());
						corScope.setCorrespondingSymbol(recordType);
						recordType.setSubScope(corScope);
					}
						
					(varDecl)* 
					{	// back to previous scope
						try {
						scopingEngine.prevScope();
						} catch (ScopingException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					( variantSection )?
					( directive )?
				)
		
	;		  
	
arrayDecl returns [ArrayType newArrayType=null;]
	{	printRuleName("OPDeclarationsParser."+"arrayDecl"); 
					Type baseType = null;
	
	}
	:	#(ARRAY_DECL 
			(expressionRange)? // MB
			baseType=typeId_ // FIXME: ok?
			{
				if( baseType != null ){
					newArrayType=(ArrayType)scopingEngine.getCurrentScope().addSymbol(new ArrayType(baseType));
					newArrayType.setInterfaceDeclaration(isInterfaceSection);
											  						  						annotatePosElement(newArrayType, #arrayDecl_in);
				
				}
			}
		) 
	;


fileType returns [FileType fileType=null;]
	{	printRuleName("OPDeclarationsParser."+"fileType"); 		
		Type baseType=null;
	}
	:
		#( FILE_TYPE 
			(
				baseType=typeId_ // FIXME: null ok?
			)? 
			
			{
				if( baseType != null ){
					fileType=(FileType)scopingEngine.getCurrentScope().addSymbol(new FileType(baseType));
					fileType.setInterfaceDeclaration(isInterfaceSection);
																  						  						annotatePosElement(fileType, #fileType_in);
				
				}else{
					fileType=(FileType)scopingEngine.getCurrentScope().addSymbol(new FileType());
					fileType.setInterfaceDeclaration(isInterfaceSection);
																				  						  						annotatePosElement(fileType, #fileType_in);
				}
			}
		)
	;

labelDecl
	{	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"labelDecl"); }
	:
		LABEL_DECL
/*		Label spielen eigentlich keine Rolle
		#( LABEL_DECL 
			#(IDLIST
				(	
					id:IDENT
	  				{ 
	  					// TODO Label-Kategorie setzen
	  					scopingEngine.getCurrentScope().addSymbol( new Attribute(id.getText()) ); 
	  				}
				)+ 
			)
		) 
*/
	;

classMethodDecl
	{	if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"classMethodDecl"); 
		Method m=null;
		Scope entryScope = scopingEngine.getCurrentScope(); 
	}
	:(	#(PROC_DECL m=procedureHeading (EQUALS qualifiedIdentifier)? )
	|	#(FUNC_DECL m=functionHeading (EQUALS qualifiedIdentifier)? )
	|	#(CONSTR_DECL m=constructorHeading (EQUALS qualifiedIdentifier)? )
	| 	#(DESTR_DECL m=destructorHeading (EQUALS qualifiedIdentifier)? )
	)
	{ 
			try {
				// System.err.println("classMethodDecl: " + m.toString() + ": Changing scope from " + scopingEngine.getCurrentScope().getFullName() + " to " + entryScope.getFullName());
				scopingEngine.changeScope(entryScope);				
			} catch (ScopingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
	}
	;

interfaceSectionDecl
	{
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:	#( d:DECL_SECT 
			(
				basicDecl 
			|	#(PROC_DECL procedureHeading) //procedureDecl  
				{ 
					try {
						scopingEngine.changeScope(entryScope);
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			 	}
			| 	#(FUNC_DECL functionHeading) // functionDecl
				{ 
					try { 
						scopingEngine.changeScope(entryScope);
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			 	}
			)
	   	)
	;

identifier
	:	id:IDENT
	;

//compoundStatement
//	:	#( STMNT_LIST ( . )? )
//	;

implementationSection
	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"implementationSection");  }
	:	#( IMPLEMENTATION
			(usesClause)?
			(declSection[false])*
			(exportsStatement)*
		)
	;

interfaceSection
	{ printRuleName("OPDeclarationsParser"+"interfaceSection"+" #################################");  }
	:	#( INTERFACE { 	isInterfaceSection = true; 
					scopingEngine.setInterface(true);
				}
			(usesClause)?
			(interfaceSectionDecl)*
			{ 	isInterfaceSection = false; 
				scopingEngine.setInterface(false);
			}
		)
	;

mainProgram
	:	#(MAIN_PROGRAM 
			{
				Method proc = (Method)scopingEngine.getCurrentScope().addSymbol( 
					new Method("[main]",Type.NULL)
					);
																				  						  						annotatePosElement(proc, #mainProgram_in);
				Statement stm = null;
				markMethodDeclaration(scopingEngine.getCurrentScope(), proc);
				proc.setLine( lastKeywordLine );
				scopingEngine.createNewScope( "[main]" ).setCorrespondingSymbol(proc);  
				scopingEngine.getCurrentScope().setSourceLine(lastKeywordLine);
			}
			stm=compoundStatement 
			{ 	
				proc.setBody((BlockStatement)stm);

				try {
					scopingEngine.prevScope();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}
		)
	;
// ANFANG des Statement-Codes
// HG: wrde ich nicht in dieser Datei machen.
compoundStatement returns [Statement stm] {stm = null; ModelElementList mel=null;
  
	}
	:	mel=statementList  
		{ // Create BlockStatement and insert statements of 
		  // ModelElementList (from statementList) into it.
		  
		  	stm = new BlockStatement();
			
	annotatePosElement(stm, #compoundStatement_in);
			
		  	//OPProjectManager.getStatementMapper().addInstance(statementCounter, stm);
		 
		  	OPProjectManager.getStatementMapper().addInstance(#compoundStatement, stm);
		  	
		  	((BlockStatement)stm).setStatements(mel);
		  	
		}
		|	asmStatement 
		{	// Assembler-Statement ==> Simple-Statement
			stm = new SimpleStatement();
			annotatePosElement(stm, #compoundStatement_in);
			
		 	OPProjectManager.getStatementMapper().addInstance(#compoundStatement, stm);
		}
	;

statement returns [Statement stm]
	{ printRuleName("OPTransformer."+"statement"); stm=null;}
	:( label )?	
	(	stm=simpleStatement
	|	stm=ifStatement
	|   stm=compoundStatement
	|	stm=tryStatement
	|	stm=gotoStatement
	|	stm=caseStatement
	|	stm=raiseStatement
	|	stm=emptyStatement
	|	stm=withStatement
	|	stm=forStatement
	|   stm=whileStatement
	|	stm=repeatStatement
	) 
	;


asmStatement :#( ASM	( #( META_INFO INT_LIT) )* )
	;


whileStatement returns [LoopStatement loop_stm] 
 { loop_stm = new LoopStatement(); Statement body = null;
 	annotatePosElement(loop_stm, #whileStatement_in);
}
:#(	WHILE  
	  		expression
	  		body=statement { loop_stm.setBody(body); }
  	)   {OPProjectManager.getStatementMapper().addInstance(#whileStatement, loop_stm);}
	
  ;


repeatStatement returns [LoopStatement loop_stm] 
 { loop_stm = new LoopStatement(); BlockStatement body = null; ModelElementList mel = null;
  	annotatePosElement(loop_stm, #repeatStatement_in);
 }
:#(REPEAT
  		mel=statementList 
  		{ 	// Create BlockStatement as body of LoopStatement
  			// and insert statements from statementList
  			body = new BlockStatement();
  			body.setStatements(mel);
  			loop_stm.setBody(body);
  			  		OPProjectManager.getStatementMapper().addInstance(#repeatStatement, loop_stm);
	  		}
  		expression
  	)
  ;


forStatement returns [LoopStatement loop_stm] 
 { loop_stm = new LoopStatement(); Statement body = null;
 			  annotatePosElement(loop_stm, #forStatement_in);
	
}
:#( FOR 
	  		#( ASSIGN identifier expression )
			(	#(TO expression )
			|	#(DOWNTO expression )
			)
			#( DO 		body=statement { loop_stm.setBody(body); 		OPProjectManager.getStatementMapper().addInstance(#forStatement, loop_stm);
	})
		)
	;


withStatement returns [BlockStatement block_stm]
{  // BlockStatement ==> recheck!!!
	block_stm = new BlockStatement(); Statement body = null; 
	  	annotatePosElement(block_stm, #withStatement_in);
	
}
:#(WITH expressionList body=statement { block_stm.addStatement(body); 		OPProjectManager.getStatementMapper().addInstance(#withStatement, block_stm);})
	;


emptyStatement returns [BlockStatement block_stm=null]
{ 	// empty BlockStatement()
//	annotatePosElement(block_stm, #emptyStatement_in);
			}
:EMPTY_STMNT 
{	//Debug.warning("BlockStatement for EMPTY-Statement created!");
	block_stm = new BlockStatement(); 
	}
	
	;

ifStatement returns [BranchStatement branch_stm]
{ // BranchStatement
	branch_stm = new BranchStatement();
	Statement then_stm = null;
	Statement else_stm = null;
		  annotatePosElement(branch_stm, #ifStatement_in);
	
}
:#(IF expression then_stm=statement 
		{branch_stm.addBranch(then_stm);} 
 	(else_stm=elseBlock )? 
	 	{ 	if (else_stm!=null) {
	 			branch_stm.addBranch(else_stm);
		 	} else {
		 		// no else: create empty BlockStatement!!
		 		// Necessary for Calculation of CFG-Measures
		 		// (see also Metamod-Class: BranchStatement)
		 		else_stm = new BlockStatement();
	 			branch_stm.addBranch(else_stm);
	 			else_stm.setImplicit();
	 		};
	 		OPProjectManager.getStatementMapper().addInstance(#ifStatement, branch_stm);
	 	}
	)
    ;


elseBlock returns [Statement stm]
{stm = null;}
:#(ELSE stm=statement )
	;


gotoStatement returns [JumpStatement stm]
{	// ==> JumpStatement (Jump)
	stm = new JumpStatement(); 
	stm.setJump();
	  annotatePosElement(stm, #gotoStatement_in);
	
	}
:#(GOTO	identifier) { 		OPProjectManager.getStatementMapper().addInstance(#gotoStatement, stm);
}
	;


raiseStatement returns [JumpStatement stm]
{	// ==> JumpStatement (Throw)
	stm = new JumpStatement(); 
	stm.setThrow();
	annotatePosElement(stm, #raiseStatement_in);
	}
:#(RAISE
			( expression (raiseAt)? )? 
		) {OPProjectManager.getStatementMapper().addInstance(#raiseStatement, stm);}
	;


raiseAt :#(AT expression)
	;


caseStatement returns [BranchStatement branch_stm]
{ 	// BranchStatement
	branch_stm = new BranchStatement();
	Statement case_stm = null;
	Statement else_stm = null;
	  	annotatePosElement(branch_stm, #caseStatement_in);
	
	}
:#(CASE
			expression
			( case_stm=caseSelector 
			 	{ branch_stm.addBranch(case_stm);}
			)+
			( else_stm=caseElse	)?
			 	{ 	if (else_stm!=null) {
			 			branch_stm.addBranch(else_stm);
				 	} else {
				 		// no else: create empty BlockStatement!!
				 		// Necessary for Calculation of CFG-Measures
				 		// (see also Metamod-Class: BranchStatement)
				 		else_stm = new BlockStatement();
			 			branch_stm.addBranch(else_stm);
			 			else_stm.setImplicit();
			 		};
			 		OPProjectManager.getStatementMapper().addInstance(#caseStatement, branch_stm);
			 	}
		)
	;


caseElse returns [BlockStatement block_stm] 
{ block_stm = new BlockStatement(); ModelElementList mel=null;}
:#( ELSE mel=statementList { block_stm.setStatements(mel);})
	;


caseSelector returns [Statement stm]
{stm = null;}
:#( COLON 
			caseLabel ( COMMA caseLabel )* 
			stm=statement 
		)
	;


caseLabel :constExpression (DOTDOT constExpression )?
	;


tryStatement returns [ExceptionHandler ex_handler]
{ ex_handler = new ExceptionHandler(); 
  ModelElementList mel = null; 
  	annotatePosElement(ex_handler, #tryStatement_in);
	
}
:#( TRY mel=sl:statementList 
				{ 
					BlockStatement guarded_block = new BlockStatement();
					guarded_block.setStatements(mel);
								 		OPProjectManager.getStatementMapper().addInstance(#sl, guarded_block);
											 		OPProjectManager.getStatementMapper().addInstance(#tryStatement, ex_handler);
			ex_handler.setGuardedBlock(guarded_block);
				}
			(	mel=tryExceptStatement
			{ ex_handler.setCatchBlocks(mel);
				}
					
			|	mel=fs:tryFinallyStatement 
			{ BlockStatement finally_block = new BlockStatement();
			  finally_block.setStatements(mel);
			 		OPProjectManager.getStatementMapper().addInstance(#tryStatement, ex_handler);
														 		OPProjectManager.getStatementMapper().addInstance(#fs, finally_block);
			 ex_handler.setFinallyBlock(finally_block);}
			)
		)
	;


tryExceptStatement returns [ModelElementList catch_blocks]
{catch_blocks = null;}
:#( EXCEPT catch_blocks=exceptionBlock )
	;


tryFinallyStatement returns [ModelElementList finally_mel]
{finally_mel = null;}
:#(FINALLY finally_mel=statementList )
	;


exceptionBlock returns [ModelElementList catch_blocks]
{	catch_blocks = new ModelElementList(); 
	ModelElementList mel = null;
	Statement stm = null;
 }
: mel=sl:statementList 
  { CatchBlock catch_block = new CatchBlock();
  	catch_block.setStatements(mel);
  	catch_blocks.add(catch_block);
 		OPProjectManager.getStatementMapper().addInstance(#sl, catch_block);
			
  }
	|	(
			(stm=on:exceptionOn 
				{	CatchBlock catch_block = new CatchBlock();
			  		catch_block.addStatement(stm);
				  	catch_blocks.add(catch_block);
				 		OPProjectManager.getStatementMapper().addInstance(#on, catch_block);
			
				}
			)+
        	(mel=el:exceptionElse
				{	CatchBlock catch_block = new CatchBlock();
			  		catch_block.setStatements(mel);
				  	catch_blocks.add(catch_block);
				  				     		statementCounter++;  OPProjectManager.getStatementMapper().addInstance(new Integer(statementCounter), catch_block);
															 		OPProjectManager.getStatementMapper().addInstance(#el, catch_block);
			
				}
        	)?
		)
	;


exceptionOn returns [Statement stm]
{stm = null;}
:#(ON
			( identifier COLON )? 
			s=typeId 
			stm=exceptionDo
		)
	;


exceptionElse returns [ModelElementList mel]
{mel = null;}
:#( ELSE mel=statementList  )
    ;


exceptionDo returns [Statement stm]
{stm = null;}
:#( DO stm=statement )
	;


simpleStatement returns [SimpleStatement stm]
{ printRuleName("OPTransformer."+"simpleStatement");
  stm = new SimpleStatement();  
  annotatePosElement(stm, #simpleStatement_in);
  /*
  PositionElement posElement = #simpleStatement_in.getPositionElement();
  if (posElement!=null) {
      stm.addAnnotation(posElement);
      System.out.println("PositionElement for SimpleStatement found: "+posElement);
  }
  */
}
:expr:
		expression 
//		{ if( ##.getFirstChild().getType() != FUNC_CALL ){
//				##.setType(FUNC_CALL);
//				##.setText("FUNC_CALL");
//				## = #([EXPR,"EXPR"],##); 
//			}
//		}
//		{ ## = #([FUNC_CALL],ex1); }
{OPProjectManager.getStatementMapper().addInstance(#simpleStatement, stm);}
	|	#(ASSIGN expression  expression 
		) {OPProjectManager.getStatementMapper().addInstance(#simpleStatement, stm);}
;

statementList returns [ModelElementList stmList] 
{stmList = new ModelElementList(); Statement s = null; }
:#( STMNT_LIST (s=statement 
					{stmList.add(s);}
				)* )
	;

// ENDE des Statement-Codes

classVisibilityDecl
	{	printRuleName("OPTransformer."+"classVisibilityDecl"); 
	}
		// besser fr jedes Element einen UnterAST mit Blatt "PUBLIC" etc. ?
	:(	
		{ currentVisibility = Modified.PUBLIC; }
		#(PUBLIC    (classElementDecl)* )
	|	{ currentVisibility = Modified.AUTOMATED; }
		#(AUTOMATED	(classElementDecl)* )
	|	{ currentVisibility = Modified.PUBLISHED; }
		#(PUBLISHED	(classElementDecl)* )
	|	{ currentVisibility = Modified.PRIVATE; }
		#(PRIVATE	(classElementDecl)* )
	|	{ currentVisibility = Modified.PROTECTED; }
		#(PROTECTED	(classElementDecl)* )
	)
	{ currentVisibility = Modified.UNKNOWN; }
	;

classDecl [de.fzi.delphi.CommonASTWithLineNumber id]
	{ 
		Vector superTypes=null;  
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:
		#(cl:CLASS { isClassDecl = true; }
	 		(
	 			( 	 
					#( EXTENDS (superTypes=identList)? )
				)?
				{   
					ClassType newClass = null;
					// Supertypen eintragen
					if( superTypes != null )
					{
						// Class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol( new ClassType(id.getText()) ); 
						newClass.setInterfaceDeclaration(isInterfaceSection);
																	  						  						annotatePosElement(newClass, #cl_in);
				
						for( int i=0;i<superTypes.size();i++)
						{
							Type currentSuperType = (Type)scopingEngine.resolve( ((CommonASTWithLineNumber)superTypes.elementAt(i)).getText() );
			
							if( currentSuperType != null && currentSuperType.isInstanceOf("ClassType") ){ // gefunden
								newClass.addSuperClass((ClassType)currentSuperType);

								// Rckwrts-Referenz setzen
								if( currentSuperType.isInstanceOf("UnknownClassType") )
									((UnknownClassType)currentSuperType).addReference(newClass);
							}else{ // nicht gefunden
								UnknownClassType dummyType = createDummyType(((CommonASTWithLineNumber)superTypes.elementAt(i)).getText());

								// Rckwrts-Referenz setzen
								dummyType.addReference(newClass);
								
								// als supertyp hinzufgen
								newClass.addSuperClass(dummyType);
							}
						}
					}
					else
					{
						// class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol(
										new ClassType( id.getText(),(ClassType)scopingEngine.resolveType("TObject"))); 
						  						  						annotatePosElement(newClass, #cl_in);
				newClass.setInterfaceDeclaration(isInterfaceSection);
					}
					markTypeDeclaration(scopingEngine.getCurrentScope(),newClass);
					
				 	// create a new subscope for this identifier
					scopingEngine.createNewScope(id.getText(), id.getLine()).setCorrespondingSymbol(newClass); 
				}
	   			( classVisibilityDecl )*
				{ 	// return from class-decl
					try {
						scopingEngine.changeScope(entryScope);
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} 
				}
	   		)	
	   	 	( OF
	   	 		{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"typeDecl"+"-typeId"); }
		   		{ Type t; }
		   		t=typeId_
		    		{  Type userType = new UserDefinedType(id.getText(),t);
		    			// FIXME: Hier fehlt Resolving des Basetypes t
		    			// siehe Bug #252
		    			userType.setInterfaceDeclaration(isInterfaceSection);
						scopingEngine.getCurrentScope().addSymbol( userType ); 
					}
	   	 	)?
	   	 	{ isClassDecl = false; }
	   	)
	;

interfaceDecl[de.fzi.delphi.CommonASTWithLineNumber id]
	{ 
		Vector superTypes=null; 
		Scope entryScope = scopingEngine.getCurrentScope();
	}
	:		#( INTERFACE
	   				#(	EXTENDS (superTypes=identList)? )
	   				( comGuid )?
				{   
					ClassType newClass = null;
					// Supertypen eintragen
					if( superTypes != null )
					{
						// Class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol( new ClassType(id.getText()) ); 
						newClass.setInterfaceDeclaration(isInterfaceSection);
						for( int i=0;i<superTypes.size();i++)
						{
							Type currentSuperType = (Type)scopingEngine.resolve( ((CommonASTWithLineNumber)superTypes.elementAt(i)).getText() );
			
							if( currentSuperType != null && currentSuperType.isInstanceOf("ClassType") ){ // gefunden
								newClass.addSuperClass((ClassType)currentSuperType);

								// Rckwrts-Referenz setzen
								if( currentSuperType.isInstanceOf("UnknownClassType") )
									((UnknownClassType)currentSuperType).addReference(newClass);
							}else{ // nicht gefunden
								// dummy typ 
								UnknownClassType dummyType = createDummyType(((CommonASTWithLineNumber)superTypes.elementAt(i)).getText());
																
								// Rckwrts-Referenz setzen
								dummyType.addReference(newClass);
								
								// als supertyp hinzufgen
								newClass.addSuperClass(dummyType);
							}
						}
					}
					else
					{
						// class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol(
										new ClassType( id.getText(),(ClassType)scopingEngine.resolveType("TObject"))
									); 
						newClass.setInterfaceDeclaration(isInterfaceSection);
					}
					newClass.setInterface(true); // is Interface (!= Interface-Section)
					markTypeDeclaration(scopingEngine.getCurrentScope(),newClass);
					
				 	// create a new subscope for this identifier
					scopingEngine.createNewScope(id.getText(), id.getLine()).setCorrespondingSymbol(newClass); 
				}

	   			(classMethodDecl|propertyDecl )*
				{ 	// return from class-decl
					try {
						scopingEngine.changeScope(entryScope);
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} 
				}
			)
	;
	
dispInterfaceDecl[de.fzi.delphi.CommonASTWithLineNumber id]
{ 
	Vector superTypes=null; 
	Scope entryScope = scopingEngine.getCurrentScope();	
}
	:		#( DISPINTERFACE
	   				#(	EXTENDS	(superTypes=identList)? )
	   				( comGuid )?
				{   
					ClassType newClass = null;
					// Supertypen eintragen
					if( superTypes != null )
					{
						// Class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol( new ClassType(id.getText()) ); 
						newClass.setInterfaceDeclaration(isInterfaceSection);
						for( int i=0;i<superTypes.size();i++)
						{
							Type currentSuperType = (Type)scopingEngine.resolve( ((CommonASTWithLineNumber)superTypes.elementAt(i)).getText() );
			
							if( currentSuperType != null && currentSuperType.isInstanceOf("ClassType") ){ // gefunden
								newClass.addSuperClass((ClassType)currentSuperType);

								// Rckwrts-Referenz setzen
								if( currentSuperType.isInstanceOf("UnknownClassType") )
									((UnknownClassType)currentSuperType).addReference(newClass);
							}else{ // nicht gefunden
								// dummy typ 
								UnknownClassType dummyType = createDummyType(((CommonASTWithLineNumber)superTypes.elementAt(i)).getText());
																
								// Rckwrts-Referenz setzen
								dummyType.addReference(newClass);
								
								// als supertyp hinzufgen
								newClass.addSuperClass(dummyType);
							}
						}
					}
					else
					{
						// class Type
						newClass = (ClassType)scopingEngine.getCurrentScope().addSymbol(
										new ClassType( id.getText(),(ClassType)scopingEngine.resolveType("IDispatch"))
									); 
						newClass.setInterfaceDeclaration(isInterfaceSection);
					}
					newClass.setInterface(true); // is Interface (!= Interface-Section)
					markTypeDeclaration(scopingEngine.getCurrentScope(),newClass);
					
				 	// create a new subscope for this identifier
					scopingEngine.createNewScope(id.getText(), id.getLine()).setCorrespondingSymbol(newClass); 
				}

	   			(classMethodDecl|propertyDecl )*
				{ 	// return from class-decl
					try {
						scopingEngine.changeScope(entryScope);
					} catch (ScopingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} 
				}
			)
	;

// Die Regeln mit Unterstrich wurden ursprnglich wegen der genderten Signatur 
// der Regeln in der neuen Grammatik eingefhrt. 
// Inzwischen ist die Signartur aber eigentlich die selbe.
// (bis auf den Rckgabewert)
enumDecl_ returns [String retString="";]
{	if( DEBUG_RULENAMES ) print("OPDeclarationsParser."+"enumDecl"); }
	:	
	  			#( ENUM_DECL 
						{ Vector v; }
						v=expressionList 
						{
							EnumeratedType enumType = null;

							// die gesamte Enumeration
			    			enumType = new EnumeratedType();
			    			enumType.setInterfaceDeclaration(isInterfaceSection);
							scopingEngine.getCurrentScope().addSymbol( enumType ); 
							
							// Enum-Elemente werden einfach dem Scope als Attribute hinzugefgt
							for(int i=0;i<v.size();i++){
								
								CommonASTWithLineNumber currentAst = ((CommonASTWithLineNumber)v.elementAt(i));
								while( currentAst.getNumberOfChildren() > 0 )
									currentAst = (CommonASTWithLineNumber)currentAst.getFirstChild();
								
								TypedSymbol currentElement = new TypedSymbol( 
											currentAst.getText()
												);
								currentElement.setType(enumType);
								currentElement.setInterfaceDeclaration(isInterfaceSection);
								enumType.addEnumerationElement(currentElement);
								
								// add the enumeration's elements to the same scope 
 								scopingEngine.getCurrentScope().addSymbol(
 									currentElement
								); 
								
								if( i < v.size() ) 
									if( i > 0 ) 
										retString += ", "+currentElement.toString();
									else
										retString += currentElement.toString();
							}
							retString = enumType.getName();
						}
				)
	;

// Die Regeln mit Unterstrich wurden ursprnglich wegen der genderten Signatur 
// der Regeln in der neuen Grammatik eingefhrt. 
// Inzwischen ist die Signartur aber eigentlich die selbe.
// (bis auf den Rckgabewert)
typeId_ returns [Type type=null;]
	{ 
		if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"typeId");
		String str=null;
	}
	:	#(TYPE_NODE 
		  (		#( p:PREDEF_TYPE s=predefinedType)
	  		 	{ 
	  		 		// try to resolve the type 
	  		 		Symbol resolvedType = scopingEngine.resolve(s);
	  		 		if( resolvedType != null && resolvedType.isInstanceOf("Type") ){
	  		 			type = (Type)resolvedType;
	  		 		}else{
		  		 		type = createDummyType(s);
		  		 		type.setInterfaceDeclaration(isInterfaceSection);
						// add to unknown-scope					
						OPProjectManager.getUnresolvedScope().addSymbol((UnknownClassType)type);
	  		 		}
	  		 	}
			|	id:IDENT 	
				{
					Symbol resolvedType = scopingEngine.resolve(id.getText());
					if( resolvedType != null && resolvedType.isInstanceOf("Type") ){
						type = (Type)resolvedType;
					}else{
						type = createDummyType(id.getText());
		  		 		type.setInterfaceDeclaration(isInterfaceSection);
						// add to unknown-scope					
						OPProjectManager.getUnresolvedScope().addSymbol((UnknownClassType)type);
					}
				} 
				(unitIdent)? 
			|	str=structuredType
			|	str=enumDecl_
				{
					// try to resolve
					Symbol resolvedType = null;
					if( str != null ){
						resolvedType = scopingEngine.resolve(str);
					}
					if( resolvedType != null && resolvedType.isInstanceOf("Type") ){
						type = (Type)resolvedType;	
					}else{
						type = new UnknownClassType("{enum}");
		  		 		type.setInterfaceDeclaration(isInterfaceSection);
						// add to unknown-scope					
						OPProjectManager.getUnresolvedScope().addSymbol((UnknownClassType)type);
					}
				}
			|	proceduralType
				{
					type = new UnknownClassType("{proceduralType}");
	  		 		type.setInterfaceDeclaration(isInterfaceSection);
					// add to unknown-scope					
					OPProjectManager.getUnresolvedScope().addSymbol((UnknownClassType)type);
				}
		  )
		) 
		{	// try to resolve
			if( type == null )
			{
				type = scopingEngine.resolveType(str);

				if( type == null ){
					Type miscType = createDummyType(str);
					
					miscType.setInterfaceDeclaration(isInterfaceSection);
					
					scopingEngine.getCurrentScope().addSymbol(miscType);
				}
			}
		}
	;

structuredType returns [String str=null;] // FIXME better: return type
	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"structuredType");}
	:	(packed1:PACKED)?
		(	
			{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"structuredType.array");}
			{ ArrayType newArray; }
			newArray=arrayDecl
			{ str= newArray.getName(); 
				if(packed1 != null) // prefixed PACKED keyword
					newArray.setPacked(true); 
			} 
			( PACKED { newArray.setPacked(true); } )?	// PACKED suffix
		|	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"structuredType.fileType");}
			{ FileType file; }
			file=fileType
			{ str= file.getName(); } 
		|	{ if( DEBUG_RULENAMES ) println("OPDeclarationsParser."+"structuredType.record");}
			{ RecordType rec; }
			rec=recordDecl
			{ str= rec.getName(); 
				if(packed1 != null) // prefixed PACKED keyword
					rec.setPacked(true); 
			} 
			( PACKED { rec.setPacked(true); } )? // PACKED suffix
		|	setType { str= "{set}"; }
		)
		{ assert str != null; }
	;
