/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Oberklasse fr Analysen
// (angepasste Regeln fr die von op_trans vernderten Teilbume)
//
// fgt auerdem Scoping-Operationen dazu
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    

header {	
	package de.fzi.delphi.parser;
	
	// Imports
	import java.util.Vector;
	import java.util.Enumeration;
	import java.util.Stack;	
//	import antlr.CommonAST;
	import de.fzi.delphi.CommonASTWithLineNumber;

	import antlr.collections.AST;	
	import de.fzi.delphi.symbols.Scope;
	// HG: Wozu?
//    import de.fzi.sissy.metamod.Statement;
//	import de.fzi.sissy.metamod.SimpleStatement;
//	import de.fzi.sissy.metamod.BranchStatement;
//	import de.fzi.sissy.metamod.BlockStatement;
//	import de.fzi.sissy.metamod.JumpStatement;
//	import de.fzi.sissy.metamod.LoopStatement;
//	import de.fzi.sissy.metamod.ExceptionHandler;
//	import de.fzi.sissy.metamod.ModelElementList;
//	import de.fzi.sissy.metamod.CatchBlock;
}


class OPAnalyzer extends OPTransformer;

options {
	buildAST=true;
//	importVocab=OPTree;
	ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
}
{
	// Some Debugging Options
	static final boolean DEBUG_ALL = false;
	static final boolean DEBUG_RULENAMES = DEBUG_ALL | false;
	static final boolean DEBUG_PRINT_IDENT_WITH_LINE = DEBUG_ALL | false;
	String s; // return values
	
	void print(Object output){
		System.err.print(output);
		System.err.flush();
	}

	void println(Object output){
		print(output);
		System.err.println();
		System.err.flush();
	}

	void println(){
		println( "" );
	}

	void printRuleName(String rulename){
		if( !DEBUG_RULENAMES ) 
			return;
		println(rulename);
	}

}

goal
	: 
	(		program
		|	package_
		|	library_
		|	unit
	)
    ;


varDecl 
	{ 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"varDecl"); 
		String t=null;
	}
  	:	#(VAR_DECL
	  		#( id:IDENT 
	  			(	
	  				t=typeId	
	  			|	range
	  			) 
	  		)
  		) 
  	;

range
	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"Range"); }
	:	#( EXPR #(RANGE ordinalType ordinalType) )
	;
	
	
constDeclSection
	{
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"constDecl");
		String t=null; 
	}
	:	
		#( CONST 
			(	
				#( ASSIGN	
						identifier 
						(typeId)? 
						(	expression
						|	objectInitialization
						)
				)
			 )+
		)
	;

procedureDecl [boolean isInnerDecl]
	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"procedureDecl"); }
	:	#(PROC_DECL
	  		procedureHeading 
  			declSection[true]
			compoundStatement
		)
	;

procedureHeading
	{	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"procedureHeading");	}
	:	(id:IDENT
			( formalParameters ) ?
			( directive )*
		)
  	;

functionDecl [boolean isInnerDecl]
	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionDecl"); }
	:	#(FUNC_DECL
	  		functionHeading 
  			declSection[true]
			compoundStatement
		)
	;

functionHeading
	{ 	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionHeading"); 
		String t;
	}
//	:	id:IDENT
//		( formalParameters )? 
//		t=typeId 
//		( directive )*
//  	;

	: 	(CLASS)?
		qualifiedIdentifier 
		(formalParameters)? 
  		(t=typeId )?
		( directive )*
	;
formalParameters
	:	parameterList
	;
	
parameterList
	:	#(PARAM_LIST
			(
				#( PARAM_SPEC 
					identifier
					typeId 
					(VAR|CONST|OUT)?
				)
			)+
		)
	;


typeDecl
	{	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeDecl"); }
	:   #( TYPE_DECL id:IDENT	{ String t; }
			// tauschen mit deref aus Recorddecl.: ( DEREF )?
		   	(	
		   		t=typeId 
			|	arrayDecl
		    	//	(PACKED)? arrayDecl (PACKED)?
		   	|	( DEREF	)? 
				#( RECORD_DECL 
					(varDecl)* 
					( variantSection )?
					( directive )?
				)
	  		|	
	  			#( ENUM_DECL 
						{ Vector v; }
						v=identList 
				)
		   	|	
		   		#(CLASS
		   			{
		   				Vector superTypes=null; 
		   			}
	   				( 	 
						#( EXTENDS
							( superTypes=identList )?
						)
					)?
	   				( classVisibilityDecl )*
	   			)
	   		|	#( INTERFACE
	   				#(	EXTENDS	( IDENT )* )
					( comGuid )?
  					(classMethodDecl|propertyDecl)*
	   			)
	   		|	#( DISPINTERFACE
	   				#(	EXTENDS	( IDENT )* )
	   				( comGuid )?
  					(classMethodDecl|dispinterfacePropertyDecl)*
	   			)
	   		|   range
	//   	|	proceduralType
			)
	)
	;
  
labelDecl
	{	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"labelDecl"); }
	:
		LABEL_DECL
//		#( LABEL_DECL
//			#(IDLIST
//				(	
//					id:IDENT
//				)+ 
//			)
//		)
	;

classMethodDecl
	{	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"classMethodDecl"); }
	:	#(PROC_DECL procedureHeading ( (EQUALS qualifiedIdentifier))? )
	|	#(FUNC_DECL functionHeading ( (EQUALS qualifiedIdentifier) )? )
	|	#(CONSTR_DECL constructorHeading (EQUALS qualifiedIdentifier)? ) 
	| 	#(DESTR_DECL destructorHeading (EQUALS qualifiedIdentifier)? )
	;

interfaceSectionDecl
	:	#( d:DECL_SECT 
			(	basicDecl 
			|	#(PROC_DECL procedureHeading) //procedureDecl  
			| 	#(FUNC_DECL functionHeading) // functionDecl
			)
	   	)
	;

typeId returns [String str=null;]
	{ 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeId");
	 }
	:	#(TYPE_NODE 
		  (	
		  		#(p:PREDEF_TYPE s=predefinedType)
		  		 	{ str = s; }
			|	id:IDENT 	{ str = id.getText(); } 
							(unitIdent)? 
			|	str=structuredType
			|	enumDecl { str = "<enum>"; }
			|	proceduralType { str = "<delegate>"; }
		  )
		) 
	;

enumDecl
	:	#(ENUM_DECL expressionList)	
	;
	
structuredType returns [String str=null;]
	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType");}
	:	(PACKED)?
		(	arrayDecl 
			{ str= "<array>"; } 
		|	str=fileType 
			{ 	if( str != null ) 
					str = "<file of "+str+">";
				else
					str = "<file>";
//				println("###"+str);
			}
		|	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType.record");}
			recordDecl { str= "<record>"; } 
				( PACKED { str= "<record_packed>"; } )?
		|	setType { str= "<set>"; }
		)
		{ assert str != null; }
	;

arrayDecl
	:	#(ARRAY_DECL 
			(expressionRange)? // MB
			typeId) 
	;

functionCallOrTypecast returns [CommonASTWithLineNumber b]
	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionCallOrTypecast");
		b = null;
	}
	: 	#( DEREF	functionCallOrTypecast )
		| #(FUNC_CALL 
			(	qi:qualifiedIdentifier 
			|	s=t:typeId
			|	typeCast
			)
			#( PARAM_LIST (el1:expressionList)? )
			( el2:expressionList )?
			b1: (dereference | arrayDim )*
		)
	;

typeCast
{	 if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeCast"); }
	:	#( TYPE_CAST (identifier|typeId) expressionList )
	;

primaryExpression
{ CommonASTWithLineNumber dn=null; }
	:		expression 			// geklammerte Expression
		|  	unsignedConstant
		|	dn=fc:functionCallOrTypecast // ( DEREF )*
		|	identifier // ( DEREF )*
		|	s=typeId
		|	typeCast
	;
	
