/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.wizards;

import de.fzi.cloneanalyzer.config.GenericConfig;
import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.config.PluginConfig;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class ConfigWizardPage
extends WizardPage {
    private Button deleteWhitespace;
    private Button deleteComments;
    private Button calcAtOnce;
    private List filterList;
    private Text fileText;
    private Text minimumCloneLengthText;
    private Text fileFilter;
    private Text commentFileNameText;
    private ISelection selection;
    private boolean isInitialized = false;
    private IConfig oldConfig;
    private int minimumCloneLengthInt;
    private Pattern fileFilterPattern;

    public ConfigWizardPage(ISelection selection, IConfig oldConfig) {
        super("wizardPage");
        this.setTitle("CloneAnalyzer Configuration");
        this.setDescription("Set the Parameters for CloneAnalyzer");
        this.selection = selection;
        this.oldConfig = oldConfig;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label1 = new Label(container, 0);
        label1.setText("Minimum Length of Clones:");
        this.minimumCloneLengthText = new Text(container, 2052);
        this.minimumCloneLengthText.setText("");
        this.minimumCloneLengthText.setLayoutData((Object)this.createGDInstance(400, 15));
        Label label2 = new Label(container, 0);
        label2.setText("Ignore Whitespace:");
        this.deleteWhitespace = new Button(container, 32);
        this.deleteWhitespace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigWizardPage.this.dialogChanged();
            }
        });
        Label label4 = new Label(container, 0);
        label4.setText("Ignore Comments:");
        this.deleteComments = new Button(container, 32);
        this.deleteComments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigWizardPage.this.dialogChanged();
            }
        });
        Label label10 = new Label(container, 0);
        label10.setText("Calculate annotation positions at once \n(not recommended):");
        this.calcAtOnce = new Button(container, 32);
        this.calcAtOnce.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigWizardPage.this.dialogChanged();
            }
        });
        Label label3 = new Label(container, 0);
        label3.setText("File Filter :");
        this.fileFilter = new Text(container, 2052);
        this.fileFilter.setText("");
        this.fileFilter.setLayoutData((Object)this.createGDInstance(400, 15));
        Label label6 = new Label(container, 0);
        label6.setText("Comment Description File:");
        this.commentFileNameText = new Text(container, 2052);
        this.commentFileNameText.setText("");
        this.commentFileNameText.setLayoutData((Object)this.createGDInstance(400, 15));
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.minimumCloneLengthText.setText(Integer.toString(this.oldConfig.getMinCloneLength()));
        this.minimumCloneLengthText.setSize(20, 50);
        this.minimumCloneLengthText.update();
        this.fileFilter.setText(this.oldConfig.getFileFilter());
        this.fileFilter.setSize(20, 50);
        this.deleteWhitespace.setSelection(this.oldConfig.isDeleteWhitespace());
        this.deleteComments.setSelection(this.oldConfig.isDeleteComments());
        this.calcAtOnce.setSelection(this.oldConfig.getCalcAtOnce());
        this.commentFileNameText.setText(this.oldConfig.getCommentFileName());
        this.commentFileNameText.setSize(20, 50);
        this.isInitialized = true;
    }

    private void dialogChanged() {
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean checkInput() {
        try {
            this.minimumCloneLengthInt = Integer.parseInt(this.minimumCloneLengthText.getText());
            if (this.minimumCloneLengthInt < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.minimumCloneLengthInt = 1;
            return EclipseUtil.warning("Please correct minimumCloneLengthInt, it has to be a positive integer value");
        }
        try {
            this.fileFilterPattern = Pattern.compile(this.fileFilter.getText());
        }
        catch (PatternSyntaxException e) {
            return EclipseUtil.warning("Please correct the RegExp in fileFilter");
        }
        try {
            File f = new File(this.commentFileNameText.getText());
            if (!f.exists()) {
                EclipseUtil.warning("Attention: CommentsFile does not exist!\nA copy of the default file will be placed to the specified location.");
                return true;
            }
        }
        catch (Exception e) {
            EclipseUtil.warning("Error in Configuration");
            return true;
        }
        return true;
    }

    public GenericConfig getConfig() throws CloneException {
        if (this.isInitialized) {
            PluginConfig config = new PluginConfig();
            config.setMinCloneLength(this.minimumCloneLengthText.getText());
            config.setDeleteWhitespace(this.deleteWhitespace.getSelection());
            config.setDeleteComments(this.deleteComments.getSelection());
            config.setFileFilter(this.fileFilter.getText());
            config.setCommentFileName(this.commentFileNameText.getText());
            config.setCalcAtOnce(this.calcAtOnce.getSelection());
            return config;
        }
        return null;
    }

    public GridData createGDInstance(int width, int height) {
        GridData gd = new GridData();
        gd.widthHint = width;
        gd.heightHint = height;
        return gd;
    }
}

