/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.viewer;

import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.cloneanalyzer.viewer.CloneComparisonDialogAction;
import de.fzi.cloneanalyzer.viewer.CloneDoubleClickAction;
import de.fzi.cloneanalyzer.viewer.CloneTreeViewerListener;
import de.fzi.cloneanalyzer.viewer.CloneViewContentProvider;
import de.fzi.cloneanalyzer.viewer.CloneViewSorter;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class CloneTreeViewer
extends ViewPart
implements IResourceChangeListener {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action sortInstancesAction;
    private Action sortLengthAction;
    private Action sortMaxCoverageAction;
    private Action sortAvgCoverageAction;
    private Action updateAction;
    private Action doubleClickAction;
    private Action compareSelectAction;
    private Action compareDialogAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private CloneViewSorter vs = new CloneViewSorter();

    public void myUpdate() {
        this.setUpToDateState();
        this.viewer.refresh();
    }

    public void setChangedState() {
        this.updateAction.setEnabled(true);
        this.updateAction.setText("Status: changes occured, click for recommended update");
        this.updateAction.setToolTipText("Sources have been changed, Clone Information might be inconsistent, click for recommended update");
        this.updateAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK"));
    }

    public void setUpToDateState() {
        this.updateAction.setEnabled(false);
        this.updateAction.setText("Status: up to date");
        this.updateAction.setToolTipText("Clone Information is up to date");
        this.updateAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.setChangedState();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.addTreeListener((ITreeViewerListener)new CloneTreeViewerListener(this.viewer));
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new CloneViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)this.vs);
        this.viewer.setInput((Object)CloneAnalyzerPlugin.getDefault().getData());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        CloneAnalyzerPlugin.getDefault().setTreeViewer(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.sortInstancesAction);
        manager.add((IAction)this.sortLengthAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sortMaxCoverageAction);
        manager.add((IAction)this.sortAvgCoverageAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CloneTreeViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.doubleClickAction);
        manager.add((IAction)this.compareDialogAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.sortInstancesAction);
        manager.add((IAction)this.sortLengthAction);
        manager.add((IAction)this.sortMaxCoverageAction);
        manager.add((IAction)this.sortAvgCoverageAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.updateAction);
    }

    private void makeActions() {
        this.compareDialogAction = new CloneComparisonDialogAction(this.viewer);
        this.sortInstancesAction = new Action(){

            public void run() {
                CloneTreeViewer.this.vs.sortFor(1);
                CloneTreeViewer.this.viewer.refresh();
            }
        };
        this.sortInstancesAction.setText("Sort for Instances");
        this.sortInstancesAction.setToolTipText("Sort for the number of instances");
        this.sortInstancesAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.sortLengthAction = new Action(){

            public void run() {
                CloneTreeViewer.this.vs.sortFor(2);
                CloneTreeViewer.this.viewer.refresh();
            }
        };
        this.sortLengthAction.setText("Sort for Length");
        this.sortLengthAction.setToolTipText("Sort for the length of the clone pattern");
        this.sortLengthAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.sortMaxCoverageAction = new Action(){

            public void run() {
                CloneTreeViewer.this.vs.sortFor(3);
                CloneTreeViewer.this.viewer.refresh();
            }
        };
        this.sortMaxCoverageAction.setText("Sort for maximal relative coverage");
        this.sortMaxCoverageAction.setToolTipText("Sort for the maximum percentage that the length of each cloneinstance makes up in relation to the total file length");
        this.sortMaxCoverageAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.sortAvgCoverageAction = new Action(){

            public void run() {
                CloneTreeViewer.this.vs.sortFor(4);
                CloneTreeViewer.this.viewer.refresh();
            }
        };
        this.sortAvgCoverageAction.setText("Sort for average relative coverage");
        this.sortAvgCoverageAction.setToolTipText("Sort for the average percentage over the length of each cloneinstance makes up in relation to the total file length");
        this.sortAvgCoverageAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.expandAllAction = new Action(){

            public void run() {
                CloneTreeViewer.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText("Expand all elements");
        this.expandAllAction.setToolTipText("Expand all elements");
        this.expandAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.collapseAllAction = new Action(){

            public void run() {
                CloneTreeViewer.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText("Collapse all elements");
        this.collapseAllAction.setToolTipText("Collapse all elements");
        this.collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UP"));
        this.doubleClickAction = new CloneDoubleClickAction(this.viewer);
        this.updateAction = new Action(){

            public void run() {
                CloneAnalyzerPlugin.getDefault().runAnalyzer();
            }
        };
        this.setUpToDateState();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CloneTreeViewer.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"CloneTreeView", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void select(CloneInstance ci) {
        MaxCloneSet cs = ci.getCloneSet();
        cs.setExpand();
        this.viewer.refresh((Object)cs);
        this.viewer.setExpandedState((Object)ci.getCloneSet(), true);
        this.viewer.refresh((Object)ci, false);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)ci), true);
    }

    public void hide() {
        this.getViewSite().getPage().hideView((IViewPart)this);
    }

    public void show() {
        try {
            this.getViewSite().getPage().showView("de.fzi.cloneanalyzer.viewer.TreeView");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

