/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.viewer;

import de.fzi.cloneanalyzer.core.CloneInstanceEclipse;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.cloneanalyzer.reader.CloneFileEclipse;
import de.fzi.cloneanalyzer.viewer.CloneDocumentRangeNode;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CloneComparisonDialog
extends Dialog {
    protected CloneInstanceEclipse ci;
    protected CloneFileEclipse selected;
    protected MaxCloneSet mcs;
    protected ListViewer cloneFileList;
    protected CompareConfiguration compareConfiguration;
    protected CompareViewerSwitchingPane contentPane;
    protected IStructureCreator structureCreator = null;

    public CloneComparisonDialog(Shell shell, CloneInstanceEclipse ci) {
        super(shell);
        this.ci = ci;
        this.mcs = ci.getCloneSet();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Compare Clone Files");
    }

    private void createCloneInstancesList(Composite cloneInstancesPane) {
        this.cloneFileList = new ListViewer(cloneInstancesPane);
        this.cloneFileList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cloneFileList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cloneFileList.setInput((Object)this.ci.getCloneSetSiblingsCloneFiles());
        this.cloneFileList.getList().setLayoutData((Object)new GridData(1808));
        this.cloneFileList.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CloneFileEclipse other = null;
                if (!selection.isEmpty()) {
                    other = (CloneFileEclipse)selection.getFirstElement();
                    CloneComparisonDialog.this.compareConfiguration.setRightLabel(other.toString());
                }
                CloneDocumentRangeNode left = CloneComparisonDialog.this.selected.getNode();
                CloneDocumentRangeNode right = other.getNode();
                DiffNode dn = new DiffNode(12, null, (ITypedElement)left, (ITypedElement)right);
                DiffNode dn2 = new DiffNode((IDiffContainer)dn, 3, null, (ITypedElement)((CloneDocumentRangeNode)((Object)left.getChildren()[1])), (ITypedElement)((CloneDocumentRangeNode)((Object)right.getChildren()[1])));
                DiffNode dn3 = new DiffNode((IDiffContainer)dn, 3, null, (ITypedElement)((CloneDocumentRangeNode)((Object)left.getChildren()[2])), (ITypedElement)((CloneDocumentRangeNode)((Object)right.getChildren()[2])));
                dn.add((IDiffElement)dn2);
                dn.add((IDiffElement)dn3);
                CloneComparisonDialog.this.contentPane.setInput((Object)dn2);
            }
        });
    }

    private void createCloneInstancesPane(Composite vsplitter) {
        Group cloneInstancesPane = new Group(vsplitter, 0);
        cloneInstancesPane.setText("Comparable Files for " + this.ci);
        cloneInstancesPane.setLayout((Layout)new GridLayout(1, false));
        cloneInstancesPane.setLayoutData((Object)new GridData(1808));
        this.createCloneInstancesList((Composite)cloneInstancesPane);
        cloneInstancesPane.layout();
    }

    private void createContentPane(Composite vsplitter) {
        this.contentPane = new CompareViewerSwitchingPane(vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)CloneComparisonDialog.this.compareConfiguration);
            }
        };
        this.contentPane.setInput((Object)this.selected.getNode());
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.initStructureCreator();
        this.selected = (CloneFileEclipse)this.ci.getCloneFile();
        this.initCompareConfiguration();
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData((Object)new GridData(1808));
        this.createCloneInstancesPane((Composite)vsplitter);
        this.createContentPane((Composite)vsplitter);
        vsplitter.setWeights(new int[]{30, 70});
        CloneComparisonDialog.applyDialogFont((Control)parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        return parent;
    }

    protected Point getInitialSize() {
        int x = this.convertHorizontalDLUsToPixels(400);
        int y = this.convertVerticalDLUsToPixels(500);
        return new Point(x, y);
    }

    private void initCompareConfiguration() {
        this.compareConfiguration = new CompareConfiguration();
        this.compareConfiguration.setLeftEditable(false);
        this.compareConfiguration.setRightEditable(false);
        this.compareConfiguration.setLeftLabel(this.ci.getCloneFile().toString());
    }

    protected void initStructureCreator() {
    }

    protected void okPressed() {
        super.okPressed();
    }

    private ITypedElement wrapResource(CloneFileEclipse cf) {
        return new ResourceNode((IResource)cf.getIFile());
    }

    protected ITypedElement wrapSelectionUnit(CloneFileEclipse cf) {
        IStructureComparator structureComparator;
        if (this.ci == null) {
            return null;
        }
        if (this.structureCreator != null && (structureComparator = this.structureCreator.locate((Object)this.ci.getCloneSet(), (Object)this.wrapResource(this.ci.getCloneFileEclipse()))) instanceof ITypedElement) {
            return (ITypedElement)structureComparator;
        }
        return new ResourceNode((IResource)this.ci.getCloneFileEclipse().getIFile());
    }

    class Foo
    implements ITypedElement {
        Foo() {
        }

        public String getName() {
            return "FooName";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }
    }
}

