/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.util;

import de.fzi.cloneanalyzer.core.CloneInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class LineSlotTable {
    protected int lineNumber;
    protected ArrayList lines;

    public LineSlotTable(int lineNumber) {
        this.init(lineNumber);
    }

    protected void init(int lineNumber) {
        this.lineNumber = lineNumber;
        this.lines = new ArrayList(lineNumber);
        int i = 0;
        while (i < lineNumber) {
            this.lines.add(new HashMap());
            ++i;
        }
    }

    public Iterator iterator() {
        return this.lines.iterator();
    }

    public Iterator iterator(int line) {
        return ((HashMap)this.lines.get(line)).values().iterator();
    }

    protected HashMap get(int line) {
        return (HashMap)this.lines.get(line);
    }

    public CloneInstance get(int line, int slot) {
        return (CloneInstance)this.get(line).get(new Integer(slot));
    }

    public void set(int line, int slot, CloneInstance toSet) {
        this.get(line).put(new Integer(slot), toSet);
    }

    public void set(int line, int length, int slot, CloneInstance toSet) {
        int j = 0;
        while (j < length) {
            this.set(line + j, slot, toSet);
            ++j;
        }
    }

    public int getFirstFreeSlot(int line) {
        int i = 0;
        while (this.get(line, i) != null) {
            ++i;
        }
        return i;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public LinkedList getLL(int line) {
        return new LinkedList(this.get(line).values());
    }
}

