/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.util;

import de.fzi.cloneanalyzer.core.CloneInstance;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class IntTreeMap {
    protected TreeMap tm;
    protected int key;

    public IntTreeMap() {
        IntComp cmp = new IntComp();
        this.init(cmp);
    }

    public IntTreeMap(Comparator cmp) {
        this.init(cmp);
    }

    public void init(Comparator cmp) {
        this.tm = new TreeMap();
        this.key = 0;
    }

    public void put(int key, Object value) {
        this.tm.put(new Integer(key), value);
    }

    public void enqueue(Object value) {
        this.tm.put(new Integer(this.key++), value);
    }

    public Object get(int key) {
        return this.tm.get(new Integer(key));
    }

    public Iterator iterator() {
        return this.tm.values().iterator();
    }

    public LinkedList toLinkedList() {
        LinkedList ll = new LinkedList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            ll.add(obj);
        }
        return ll;
    }

    public class IntComp
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int ret = 0;
            if (o1 instanceof Integer && o2 instanceof Integer) {
                Integer i1 = (Integer)o1;
                Integer i2 = (Integer)o2;
                ret = i1 - i2;
            }
            return ret;
        }
    }

    public class LengthComp
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int ret = 0;
            if (IntTreeMap.this.tm.get(o1) instanceof CloneInstance && IntTreeMap.this.tm.get(o2) instanceof CloneInstance) {
                CloneInstance ci1 = (CloneInstance)IntTreeMap.this.tm.get(o1);
                CloneInstance ci2 = (CloneInstance)IntTreeMap.this.tm.get(o2);
                ret = ci1.getLength() - ci2.getLength();
            }
            return ret;
        }
    }
}

