/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.reader;

import de.fzi.cloneanalyzer.annotation.CloneAnnotation;
import de.fzi.cloneanalyzer.annotation.CloneFileAnnotationPositionManager;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.CloneInstanceEclipse;
import de.fzi.cloneanalyzer.reader.CloneFile;
import de.fzi.cloneanalyzer.util.IntTreeMap2D;
import de.fzi.cloneanalyzer.viewer.CloneDocumentRangeNode;
import de.fzi.cloneanalyzer.viewer.CloneEditor;
import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CloneFileEclipse
extends CloneFile {
    protected IFile iFile;
    protected CloneEditor cloneEditor;
    protected IAnnotationModel model;
    protected CloneFileAnnotationPositionManager apm;
    protected CloneDocumentRangeNode node;
    protected boolean nodeConstructed = false;
    protected boolean positionCalculationDone = false;

    public CloneFileEclipse(File File_param, IFile iFile_param) {
        super(File_param);
        this.iFile = iFile_param;
        this.model = new AnnotationModel();
    }

    public void setVisible(CloneInstance inst) {
        this.registerCloneInstanceAPM(inst);
    }

    public IAnnotationModel getAnnotationModel() {
        return this.model;
    }

    public CloneEditor getEditor() {
        return this.cloneEditor;
    }

    public CloneEditor openEditor() {
        this.callAPM();
        try {
            openingInstance = this;
            this.cloneEditor = (CloneEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.iFile), "de.fzi.cloneanalyzer.viewer.CloneEditor");
            openingInstance = null;
            this.cloneEditor.setAnnotationModel(this.model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.cloneEditor;
    }

    public IFile getIFile() {
        return this.iFile;
    }

    public void setIFile(IFile file) {
        this.iFile = file;
    }

    protected CloneEditor setEditor() {
        return this.openEditor();
    }

    public void callAPM() {
        if (!this.positionCalculationDone) {
            this.apm.calc();
            this.positionCalculationDone = true;
        }
    }

    public void registerCloneInstanceAPM(CloneInstance toRegister) {
        this.apm.registerCloneInstance(toRegister);
    }

    public LinkedList getCloneInstanceList() {
        IntTreeMap2D itm = this.apm.getCloneStartList();
        return itm.toLinkedList();
    }

    public LinkedList getCloneInstanceList(int line) {
        return this.apm.getCloneInstances(line);
    }

    public IDocument getDocument() {
        return this.cloneEditor.getDocumentProvider().getDocument((Object)this.cloneEditor.getEditorInput());
    }

    public int getMaxRulerWidth() {
        return CloneAnnotation.calculateX(0, this.apm.getMaxSlotNumber());
    }

    public void finishInit() {
        this.apm = new CloneFileAnnotationPositionManager(this);
    }

    public Object[] getChildren() {
        return this.getCloneInstanceList().toArray();
    }

    public CloneDocumentRangeNode getNode() {
        return this.constructNode();
    }

    protected CloneDocumentRangeNode constructNode() {
        if (!this.nodeConstructed) {
            this.node = new CloneDocumentRangeNode(0, "CloneFile" + Integer.toString(CloneFile.instanceCounter++), this.getDocument(), 0, this.characterLength, null, this, null);
            for (CloneInstanceEclipse ci : this.getCloneInstanceList()) {
                this.node.addChild(ci.getNode(this.node));
            }
            this.nodeConstructed = true;
        }
        return this.node;
    }
}

