/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.ClonePattern;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class MaxCloneSet {
    private boolean expandState = false;
    private int sigLines;
    private ArrayList clones = new ArrayList();
    private int anzClones = 0;
    static int instanceCounter = 0;
    private int identifier = instanceCounter++;
    private String identifierString = String.valueOf(this.identifier);
    private final int maxInst = 4;

    public void setInstancesVisible() {
        Iterator it = this.clones.iterator();
        while (it.hasNext()) {
            ((CloneInstance)it.next()).setVisible();
        }
    }

    public int getInstanceNumber() {
        return this.clones.size();
    }

    public boolean expanded() {
        return this.expandState;
    }

    public void setExpand() {
        this.expandState = true;
    }

    public void setSigLines(int sigLines) {
        this.sigLines = sigLines;
    }

    public void addCloneInstance(CloneInstance clone) {
        ++this.anzClones;
        this.clones.add(clone);
        clone.setCloneSet(this);
    }

    public ClonePattern getClonePattern() {
        return ((CloneInstance)this.clones.get(0)).getMuster(0);
    }

    public void printCloneSet(int nr) {
        System.out.println(this.cloneSetLine(nr));
        int i = 0;
        while (i < this.clones.size()) {
            System.out.println(this.cloneInstanceLine(i));
            ++i;
        }
    }

    public void writeCloneSetToFileWriter(FileWriter writer, int nr) {
        try {
            writer.write(String.valueOf(this.cloneSetLine(nr)) + "\r\n");
            int i = 0;
            while (i < this.clones.size()) {
                writer.write(String.valueOf(this.cloneInstanceLine(i)) + "\r\n");
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void writeSummary(FileWriter writer, int nr) {
        try {
            if (nr == 1) {
                writer.write("Nr\tSigLines\tInstances\tFiles\r\n");
            }
            writer.write(String.valueOf(this.cloneSetSummary(nr)) + "\r\n");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private String cloneInstanceLine(int instance) {
        String result;
        CloneInstance c = (CloneInstance)this.clones.get(instance);
        try {
            result = " " + c.getFile().getCanonicalPath() + " : lines " + c.getStartLine().getLineNumber() + "-" + c.getEndLine().getLineNumber();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            result = " " + c.getFile().getAbsolutePath() + " : lines " + c.getStartLine().getLineNumber() + "-" + c.getEndLine().getLineNumber();
        }
        return result;
    }

    private String cloneSetSummary(int nr) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(nr) + "\t" + this.sigLines + "\t" + this.clones.size() + "\t");
        int i = 0;
        while (i < this.clones.size() - 1 && i < 4) {
            sb.append(String.valueOf(this.shortCloneInstanceLine(i)) + ",");
            ++i;
        }
        sb.append(this.shortCloneInstanceLine(i));
        if (i == 4 && this.clones.size() >= 4) {
            sb.append(",...");
        }
        return sb.toString();
    }

    private String shortCloneInstanceLine(int instance) {
        String result;
        CloneInstance c = (CloneInstance)this.clones.get(instance);
        try {
            result = String.valueOf(c.getFile().getCanonicalPath()) + "(" + c.getStartLine().getLineNumber() + "-" + c.getEndLine().getLineNumber() + ")";
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            result = String.valueOf(c.getFile().getAbsolutePath()) + "(" + c.getStartLine().getLineNumber() + "-" + c.getEndLine().getLineNumber() + ")";
        }
        return result;
    }

    private String cloneSetLine(int nr) {
        return "Cloneset " + nr + " : " + this.sigLines + " significant line(s), " + this.clones.size() + " instances";
    }

    public Object[] getArray() {
        return this.clones.toArray();
    }

    public ArrayList getCloneInstances() {
        return this.clones;
    }

    public int getLength() {
        return ((CloneInstance)this.clones.get(0)).getLength();
    }

    public double getAvgCoverage() {
        double sum = 0.0;
        int i = 0;
        while (i < this.clones.size()) {
            sum += ((CloneInstance)this.clones.get(i)).getRelativeCoverage();
            ++i;
        }
        return sum / (double)this.clones.size();
    }

    public double getMaxCoverage() {
        double max = 0.0;
        int i = 0;
        while (i < this.clones.size()) {
            max = Math.max(max, ((CloneInstance)this.clones.get(i)).getRelativeCoverage());
            ++i;
        }
        return max;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public String toString() {
        return "Clone Set No " + this.getIdentifier() + " (Length: " + this.getLength() + ", Instances: " + this.getInstanceNumber() + ")";
    }

    public String toTupel() {
        return "\nClone Set No " + this.getIdentifier() + "," + this.getLength() + "," + this.getInstanceNumber() + "\n";
    }

    public Object[] getArrayExcept(CloneInstance except) {
        ArrayList clonesExcept = (ArrayList)this.clones.clone();
        clonesExcept.remove(except);
        Object[] obj = clonesExcept.toArray();
        return obj;
    }
}

