/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.core.ClonePattern;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.cloneanalyzer.reader.CloneFile;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;

public class CloneInstance {
    protected int key;
    protected LineElement startLine;
    protected LineElement endLine;
    protected ClonePattern muster = null;
    protected CloneFile cloneFile;
    protected int annotationPosition;
    protected MaxCloneSet cloneSet;
    protected boolean visible;
    protected static int instanceCounter;
    public static final String TYPE = "CloneInstance";
    protected boolean displayable = false;

    public CloneInstance(LineElement startLine, LineElement endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.cloneFile = this.startLine.getCloneFile();
        this.key = instanceCounter++;
    }

    public double getRelativeCoverage() {
        return (double)this.getLength() / (double)this.cloneFile.getLineNumber();
    }

    public int getLength() {
        return this.endLine.getLineNumber() - this.startLine.getLineNumber() + 1;
    }

    public LineElement getStartLine() {
        return this.startLine;
    }

    public LineElement getEndLine() {
        return this.endLine;
    }

    public File getFile() {
        return this.cloneFile.getFile();
    }

    public CloneFile getCloneFile() {
        return this.cloneFile;
    }

    public ClonePattern getMuster(int anz) {
        if (this.muster == null) {
            LineElement le = this.endLine;
            ArrayList<Integer> muster2 = new ArrayList<Integer>();
            if (le == this.startLine) {
                muster2.add(le.getHashValue());
            } else {
                do {
                    muster2.add(le.getHashValue());
                } while ((le = le.getPrevLine()) != this.startLine);
                muster2.add(le.getHashValue());
            }
            this.muster = new ClonePattern(muster2);
            this.muster.anz = anz;
        }
        return this.muster;
    }

    public String toString() {
        return "Clone Instance (Lines: " + this.startLine.getLineNumber() + " to " + this.endLine.getLineNumber() + ", Coverage " + Integer.toString((int)Math.round(this.getRelativeCoverage() * 100.0)) + "%" + ", File: " + this.startLine.getFile() + ")";
    }

    public String toTupel() {
        return this.startLine.getLineNumber() + "," + this.endLine.getLineNumber() + "," + this.startLine.getFile() + "\n";
    }

    public String toShortString() {
        return "Clone Instance (Lines: " + this.startLine.getLineNumber() + " to " + this.endLine.getLineNumber() + ")";
    }

    public int getStartCharacterPosition() {
        return this.getStartLine().getLinePosition();
    }

    public int getEndCharacterPosition() {
        return this.getEndLine().getLineEndPosition();
    }

    public int getCharacterLength() {
        int from = this.getStartLine().getLinePosition();
        int to = this.getEndLine().getLineEndPosition();
        return to - from + 1;
    }

    public void addAnnotation() {
    }

    public int getAnnotationPosition() {
        return this.annotationPosition;
    }

    public void setAnnotationPosition(int i) {
        this.annotationPosition = i;
    }

    public MaxCloneSet getCloneSet() {
        return this.cloneSet;
    }

    public Object[] getCloneSetSiblings() {
        if (this.cloneSet == null) {
            return null;
        }
        return this.cloneSet.getArrayExcept(this);
    }

    public Object[] getCloneSetSiblingsCloneFiles() {
        Object[] cs = this.getCloneSetSiblings();
        if (cs == null) {
            return null;
        }
        TreeSet<CloneFile> ts = new TreeSet<CloneFile>();
        int i = 0;
        while (i < cs.length) {
            CloneInstance ci = (CloneInstance)cs[i];
            CloneFile cf = ci.getCloneFile();
            if (cf != this.cloneFile) {
                ts.add(cf);
            }
            ++i;
        }
        Object[] arr = ts.toArray();
        System.out.println(arr.length);
        return arr;
    }

    public void setCloneSet(MaxCloneSet set) {
        this.cloneSet = set;
    }

    public boolean displayable() {
        return this.displayable;
    }

    public void setDisplayable(boolean setTo) {
        this.displayable = setTo;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible() {
        this.visible = true;
    }
}

