/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.core;

import de.fzi.cloneanalyzer.analyzer.CloneInstanceFactory;
import de.fzi.cloneanalyzer.analyzer.IterativeAnalyzer;
import de.fzi.cloneanalyzer.annotation.AnnotationManager;
import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.config.PluginConfig;
import de.fzi.cloneanalyzer.core.CloneInstance;
import de.fzi.cloneanalyzer.core.CloneInstanceEclipse;
import de.fzi.cloneanalyzer.core.CloneResourceChangeReporter;
import de.fzi.cloneanalyzer.core.CloneSetStructure;
import de.fzi.cloneanalyzer.core.LineElement;
import de.fzi.cloneanalyzer.core.MonitorCancelDispatcher;
import de.fzi.cloneanalyzer.core.Updater;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.reader.ProjectLineElementReader;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import de.fzi.cloneanalyzer.util.FileConsoleLogger;
import de.fzi.cloneanalyzer.util.IntTreeMap;
import de.fzi.cloneanalyzer.util.TimeLogger;
import de.fzi.cloneanalyzer.viewer.CloneTreeViewer;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class CloneAnalyzerPlugin
extends AbstractUIPlugin {
    private static CloneAnalyzerPlugin plugin;
    private ResourceBundle resourceBundle;
    private CloneSetStructure data;
    private CloneTreeViewer treeViewer;
    private IConfig config;
    private Shell shell;
    private IWorkbenchWindow wbw;
    private CloneInstance selectedCloneInstance;
    private CloneInstance compareCloneInstance;
    private static final int SHOW_THRESHOLD = 1000;
    private FileConsoleLogger logger;
    private IntTreeMap map;
    private boolean showReminder = false;

    public CloneAnalyzerPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        Updater updater = new Updater();
    }

    public void startup() throws CoreException {
        super.startup();
        try {
            this.resourceBundle = ResourceBundle.getBundle("CloneAnalyzer.CloneAnalyzerPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        this.data = new CloneSetStructure();
        try {
            this.config = PluginConfig.getStdInstance();
        }
        catch (CloneException e) {
            EclipseUtil.warning("There is a problem with the configuration, the plugin will not be usable until changed." + e.getMessage());
        }
        this.map = new IntTreeMap();
        this.wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.logger = new FileConsoleLogger("CloneAnalyzerLogger", String.valueOf(CloneAnalyzerPlugin.getDefault().getStateLocation().toString()) + "/cloneanalyzer.log");
        CloneResourceChangeReporter listener = new CloneResourceChangeReporter();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 3);
    }

    public static CloneAnalyzerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CloneAnalyzerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public CloneSetStructure getData() {
        return this.data;
    }

    public void setData(CloneSetStructure structure, Shell param_shell) {
        boolean showData = false;
        if (structure.getSize() > 1000) {
            MessageBox m = new MessageBox(param_shell, 288);
            m.setText("Large number of CloneSets found");
            m.setMessage("A number of CloneSets > " + Integer.toString(1000) + " was found. Constructing the GUI components might take a while. Continue anyway?");
            if (m.open() == 32) {
                showData = true;
            }
        } else {
            showData = true;
        }
        if (showData) {
            this.setDataSilent(structure);
        }
    }

    private Shell Shell() {
        return null;
    }

    protected void setDataSilent(CloneSetStructure structure) {
        CloneSetStructure oldData = this.data;
        this.data = structure;
    }

    protected void setDataUpdate(CloneSetStructure structure) {
        this.setDataSilent(structure);
        this.update();
    }

    public void update() {
        Runnable r = new Runnable(){

            public void run() {
                IWorkbenchPage wp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    wp.showView("de.fzi.cloneanalyzer.viewer.CloneTreeViewer");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CloneAnalyzerPlugin.this.treeViewer.myUpdate();
            }
        };
        Display.getDefault().asyncExec(r);
    }

    public IConfig getConfig() {
        return this.config;
    }

    public void setConfig(IConfig config) {
        this.config = config;
        this.config.storeInstance();
    }

    public void prepareUI() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
    }

    public void runAnalyzer() {
        try {
            this.prepareUI();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            MyRunnableWithProgress op = new MyRunnableWithProgress();
            pmd.run(true, true, (IRunnableWithProgress)op);
            this.update();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            EclipseUtil.warning(String.valueOf(e.getMessage()) + "\naborted operation!");
        }
    }

    public CloneTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setTreeViewer(CloneTreeViewer viewer_param) {
        this.treeViewer = viewer_param;
    }

    public void open(String path) {
        this.data.readFile();
        this.update();
    }

    public void save(String path) {
        System.out.println("saving");
        this.data.writeFile(path);
    }

    public CloneInstance getCompareCloneInstance() {
        return this.compareCloneInstance;
    }

    public CloneInstance getSelectedCloneInstance() {
        return this.selectedCloneInstance;
    }

    public void setCompareCloneInstance(CloneInstance instance) {
        this.compareCloneInstance = instance;
    }

    public void setSelectedCloneInstance(CloneInstance instance) {
        this.selectedCloneInstance = instance;
    }

    public CloneInstance getCloneInstance(int key) {
        return (CloneInstance)this.map.get(key);
    }

    public void setCloneInstance(int key, CloneInstance ci) {
        this.map.put(key, ci);
    }

    public void toggleReminder() {
        this.showReminder = !this.showReminder;
    }

    public boolean isShowReminder() {
        return this.showReminder;
    }

    public String getPluginDir() {
        String installDir = "";
        Bundle b = this.getBundle();
        installDir = b.getLocation();
        installDir = installDir.substring(installDir.indexOf("/") + 1, installDir.length());
        System.out.println(installDir);
        return installDir;
    }

    public class MyRunnableWithProgress
    implements IRunnableWithProgress {
        Shell mshell;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.mshell = new Shell(new Display());
            TimeLogger tl = new TimeLogger();
            MonitorCancelDispatcher cancel = new MonitorCancelDispatcher(monitor);
            try {
                CloneAnalyzerPlugin.this.config.updateCommentFile();
            }
            catch (CloneException e) {
                throw new InterruptedException(e.getMessage());
            }
            IterativeAnalyzer a = new IterativeAnalyzer(CloneAnalyzerPlugin.this.config, new CloneInstanceFactory(){

                public CloneInstance newInstance(LineElement start, LineElement end) {
                    return new CloneInstanceEclipse(start, end);
                }
            });
            LineElement lastLineElement = null;
            ProjectLineElementReader reader = null;
            Hashtable ht = null;
            AnnotationManager am = null;
            CloneSetStructure css = null;
            CloneAnalyzerPlugin.this.logger.info(CloneAnalyzerPlugin.this.config.toString());
            if (!cancel.isCanceled()) {
                if (monitor != null) {
                    tl.log("Start");
                    monitor.beginTask("reading files of current projects...", 4);
                }
                reader = new ProjectLineElementReader();
                CloneAnalyzerPlugin.this.logger.info("reading started...");
                try {
                    lastLineElement = reader.read(CloneAnalyzerPlugin.this.config, cancel);
                }
                catch (CloneException e) {
                    throw new InterruptedException(e.getMessage());
                }
                CloneAnalyzerPlugin.this.logger.info("...reading completed.");
                ht = reader.getHashtable();
                CloneAnalyzerPlugin.this.logger.info("got Hashtable.");
                System.gc();
                CloneAnalyzerPlugin.this.logger.info("performed gc.");
                if (lastLineElement == null) {
                    CloneAnalyzerPlugin.this.logger.info("lastLineElement == null");
                    return;
                }
            }
            if (!cancel.isCanceled()) {
                CloneAnalyzerPlugin.this.logger.info("not canceled before analyzing.");
                if (monitor != null) {
                    tl.log("Reading files");
                    monitor.worked(1);
                    monitor.setTaskName("analyzing files for clones...");
                }
                CloneAnalyzerPlugin.this.logger.info("analyzing started.");
                css = a.buildCloneSetStructure(lastLineElement, ht, cancel);
                CloneAnalyzerPlugin.this.logger.info("analyzing completed.");
                StringBuffer buf = new StringBuffer();
                buf.append("\n--------------------------------------------------------\n");
                buf.append("LOC (total) processed: " + Integer.toString(reader.getGlobalTotalLineCount()) + "\n");
                buf.append("LOC (significant) processed: " + Integer.toString(reader.getGlobalLineCount()) + "\n");
                buf.append("No of Files: " + Integer.toString(reader.getCloneFileList().size()) + "\n");
                buf.append("CloneSets found: " + Integer.toString(css.getSize()));
                CloneAnalyzerPlugin.this.logger.info(buf.toString());
                System.gc();
            }
            if (!cancel.isCanceled() && CloneAnalyzerPlugin.this.config.getCalcAtOnce()) {
                if (monitor != null) {
                    tl.log("IterativeAnalyzer");
                    monitor.worked(1);
                    monitor.setTaskName("calculating positions of annotations...");
                }
                am = new AnnotationManager(reader.getCloneFileList());
                am.calc();
                System.gc();
            }
            if (!cancel.isCanceled()) {
                if (monitor != null) {
                    tl.log("AnnotationCalculation");
                    monitor.worked(1);
                    monitor.setTaskName("feeding elements into CloneTreeView...");
                }
                CloneAnalyzerPlugin.this.setData(css, this.mshell);
                if (monitor != null) {
                    tl.log("Feeding CloneTreeView");
                    monitor.worked(1);
                    CloneAnalyzerPlugin.this.logger.info(tl.print());
                }
                System.gc();
            }
        }
    }
}

