/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.config;

import de.fzi.cloneanalyzer.config.GenericConfig;
import de.fzi.cloneanalyzer.core.CloneAnalyzerPlugin;
import de.fzi.cloneanalyzer.exceptions.CloneConfigException;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.util.EclipseUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PluginConfig
extends GenericConfig {
    public static GenericConfig getStdInstance() throws CloneException {
        PluginConfig configInstance = new PluginConfig();
        configInstance.setStdValues();
        return configInstance;
    }

    public void setStdValues() throws CloneException {
        IEclipsePreferences prefs = new ConfigurationScope().getNode("de.fzi.cloneanalyzer");
        try {
            this.setMinCloneLength(prefs.getInt("MinCloneLength", 15));
            this.setDeleteWhitespace(prefs.getBoolean("DeleteWhiteSpace", true));
            this.setDeleteComments(prefs.getBoolean("DeleteComments", true));
            this.setFileFilter(prefs.get("FileFilter", ".*\\.(java|c|cpp|pas)"));
            this.setCalcAtOnce(prefs.getBoolean("CalcAtOnce", false));
        }
        catch (CloneException e) {
            e.printStackTrace();
            super.setStdValues();
        }
        try {
            this.setCommentFileName(prefs.get("Comments", this.getDefaultCommentsFilename()));
        }
        catch (CloneConfigException e) {
            this.setCommentFileName(this.getDefaultCommentsFilename());
        }
    }

    public void storeInstance() {
        IEclipsePreferences prefs = new ConfigurationScope().getNode("de.fzi.cloneanalyzer");
        prefs.putInt("MinCloneLength", this.getMinCloneLength());
        prefs.putBoolean("DeleteWhiteSpace", this.isDeleteWhitespace());
        prefs.putBoolean("DeleteComments", this.isDeleteComments());
        prefs.put("FileFilter", this.getFileFilter());
        String s = this.getCommentFileName();
        prefs.put("Comments", this.getCommentFileName());
        prefs.putBoolean("CalcAtOnce", this.getCalcAtOnce());
        prefs.put("Dir", this.getAnalysisPathList().toString());
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getDefaultCommentsFilename() throws CloneConfigException {
        String userFilename = String.valueOf(CloneAnalyzerPlugin.getDefault().getStateLocation().toString()) + "/comments.conf";
        String defaultFilename = String.valueOf(CloneAnalyzerPlugin.getDefault().getPluginDir()) + "comments.conf";
        File userFile = new File(userFilename);
        File defaultFile = new File(defaultFilename);
        BufferedReader r = null;
        FileWriter w = null;
        if (!userFile.exists()) {
            if (!defaultFile.exists()) {
                throw new CloneConfigException("\nNo comments-file found, not even the default-file in \n" + defaultFilename + "\nReinstall the Plugin");
            }
            try {
                String s;
                r = new BufferedReader(new FileReader(defaultFile));
                w = new FileWriter(userFile);
                while ((s = r.readLine()) != null) {
                    w.write(String.valueOf(s) + "\n");
                }
                r.close();
                w.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("copied configuration from default");
            EclipseUtil.message("The CommentFile you specified was not found.\nCreated default configuration file in: \n" + userFilename);
        }
        return userFilename;
    }
}

