/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.cloneanalyzer.config;

import de.fzi.cloneanalyzer.config.IConfig;
import de.fzi.cloneanalyzer.exceptions.CloneCommentException;
import de.fzi.cloneanalyzer.exceptions.CloneConfigException;
import de.fzi.cloneanalyzer.exceptions.CloneException;
import de.fzi.cloneanalyzer.reader.Comment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConfig
implements IConfig {
    protected boolean deleteWhitespace;
    protected boolean deleteComments;
    protected int minCloneLength;
    protected ArrayList filters;
    protected ArrayList comments;
    private List<String> analysisPathList;
    protected String fileFilter;
    protected String commentFileName;
    protected boolean calcAtOnce = false;
    protected String dir = "";
    protected boolean checked = false;

    public GenericConfig() {
        this.init();
    }

    public static GenericConfig getStdInstance() throws CloneException {
        GenericConfig configInstance = new GenericConfig();
        configInstance.setStdValues();
        return configInstance;
    }

    protected String getDefaultCommentsFilename() throws CloneConfigException {
        return "comments.conf";
    }

    public void setStdValues() throws CloneException {
        this.setMinCloneLength(15);
        this.setDeleteWhitespace(true);
        this.setDeleteComments(true);
        this.setFileFilter(".*\\.(java|c|cpp|pas)");
        this.commentFileName = this.getDefaultCommentsFilename();
        this.setCalcAtOnce(false);
        this.addAnalysisPath(".");
    }

    @Override
    public void storeInstance() {
    }

    protected static boolean isWhitespace(String str) {
        int i = 0;
        if (i < str.length()) {
            switch (str.charAt(i)) {
                default: 
            }
            return false;
        }
        return true;
    }

    protected static String readNext(BufferedReader r) {
        String line = "";
        try {
            while ((line = r.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#") || GenericConfig.isWhitespace(line)) continue;
                return line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected ArrayList readCommentFile() throws CloneException {
        this.comments = new ArrayList();
        File f = new File(this.getCommentFileName());
        if (f.exists() && f.isFile()) {
            int ctr = 0;
            try {
                String s1;
                FileReader filereader = new FileReader(f);
                BufferedReader r = new BufferedReader(filereader);
                while ((s1 = GenericConfig.readNext(r)) != null) {
                    String s2 = GenericConfig.readNext(r);
                    if (s2 != null) {
                        this.comments.add(new Comment(s1, s2));
                    }
                    ++ctr;
                }
            }
            catch (CloneCommentException e) {
                throw new CloneCommentException("Error in CommentDescriptionFile " + this.getCommentFileName() + " Line " + Integer.toString(ctr) + ": " + e.getMessage());
            }
            catch (Exception e) {
                throw new CloneCommentException("Error in CommentDescriptionFile " + this.getCommentFileName() + " Line " + Integer.toString(ctr) + ".");
            }
        } else {
            throw new CloneConfigException("CommentDescriptionFile " + this.getCommentFileName() + " does not exist.");
        }
        return this.comments;
    }

    protected void init() {
        this.deleteWhitespace = true;
        this.deleteComments = true;
        this.minCloneLength = 1;
        this.filters = new ArrayList();
        this.commentFileName = "comments.conf";
    }

    @Override
    public void setCommentFileName(String string) throws CloneException {
        File f = new File(string);
        if (!f.exists()) {
            throw new CloneConfigException("CommentsFile " + string + " does not exist!");
        }
        this.commentFileName = string;
        this.readCommentFile();
        this.checked = true;
    }

    @Override
    public void updateCommentFile() throws CloneException {
        this.readCommentFile();
    }

    @Override
    public boolean isDeleteWhitespace() {
        return this.deleteWhitespace;
    }

    @Override
    public void setDeleteWhitespace(boolean b) {
        this.deleteWhitespace = b;
    }

    public void setDeleteWhitespaceString(String str) throws CloneConfigException {
        try {
            this.setDeleteWhitespace(Boolean.valueOf(str));
        }
        catch (Exception e) {
            throw new CloneConfigException("The value of the argument ignoreWhitespace has to be one out of {true, false}");
        }
    }

    @Override
    public int getMinCloneLength() {
        return this.minCloneLength;
    }

    @Override
    public void setMinCloneLength(int i) {
        this.minCloneLength = i;
    }

    @Override
    public void setMinCloneLength(String str) throws CloneConfigException {
        try {
            this.minCloneLength = Integer.parseInt(str);
            if (this.minCloneLength < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.minCloneLength = 1;
            throw new CloneConfigException("Please correct minimumCloneLengthInt, it has to be a positive integer value");
        }
    }

    @Override
    public ArrayList getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(ArrayList strings) {
        this.filters = strings;
    }

    public void addFilter(String string) {
        this.filters.add(string);
    }

    @Override
    public String getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public void setFileFilter(String p) throws CloneConfigException {
        try {
            Pattern fileFilterPattern = Pattern.compile(p);
            this.fileFilter = p;
        }
        catch (PatternSyntaxException e) {
            throw new CloneConfigException("Please correct the RegExp in fileFilter");
        }
    }

    protected void check() throws CloneException {
        this.readCommentFile();
        this.checked = true;
    }

    @Override
    public ArrayList getComments() throws CloneException {
        if (!this.checked) {
            this.check();
        }
        return this.comments;
    }

    @Override
    public void setComments(ArrayList list) {
        this.comments = list;
    }

    @Override
    public boolean isDeleteComments() {
        return this.deleteComments;
    }

    @Override
    public void setDeleteComments(boolean b) {
        this.deleteComments = b;
    }

    public void setDeleteCommentsString(String str) throws CloneConfigException {
        try {
            this.setDeleteComments(Boolean.valueOf(str));
        }
        catch (Exception e) {
            throw new CloneConfigException("The value of the argument ignoreComments has to be one out of {true, false}");
        }
    }

    @Override
    public String getCommentFileName() {
        return this.commentFileName;
    }

    @Override
    public boolean getCalcAtOnce() {
        return this.calcAtOnce;
    }

    @Override
    public void setCalcAtOnce(boolean b) {
        this.calcAtOnce = b;
    }

    @Override
    public List<String> getAnalysisPathList() {
        if (this.analysisPathList != null) {
            return this.analysisPathList;
        }
        return new ArrayList<String>();
    }

    void setAnalysisPathListParameter(String param) throws CloneConfigException {
        File f = new File(param);
        if (!f.exists()) {
            throw new CloneConfigException("Cannot determine analysis path: file not found");
        }
        if (this.analysisPathList != null) {
            this.analysisPathList.clear();
        }
        if (f.isDirectory()) {
            this.addAnalysisPath(param);
        } else {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document doc = docBuilder.parse(f);
                doc.normalizeDocument();
                Element rootNode = doc.getDocumentElement();
                if (rootNode == null || !rootNode.getNodeName().equals("CloneAnalyzerConfig")) {
                    throw new CloneConfigException("Root node of the configuration file is not CloneAnalyzerConfig");
                }
                NodeList nl = rootNode.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node node = nl.item(i);
                    if (node.getNodeName().equals("IncludeDirectory")) {
                        this.addAnalysisPath(node.getAttributes().getNamedItem("path").getTextContent());
                    }
                    ++i;
                }
            }
            catch (CloneConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CloneConfigException("Error parsing configuration file");
            }
        }
    }

    void addAnalysisPath(String path) {
        if ((path = this.checkDir(path)) != null) {
            if (this.analysisPathList == null) {
                this.analysisPathList = new ArrayList<String>();
            }
            this.analysisPathList.add(path);
        }
    }

    private String checkDir(String string) {
        File f = new File(string);
        if (f.exists()) {
            return string;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Using the following parameters (specified explicitly or implicitly)\n");
        buf.append("Minimum Length of CloneSet (-m) : " + this.getMinCloneLength() + "\n");
        buf.append("Source Directories (-d)           : " + this.getAnalysisPathList().toString() + "\n");
        buf.append("FileFilter (-f)                 : " + this.getFileFilter() + "\n");
        buf.append("CommentFileName (-c)            : " + this.getCommentFileName() + "\n");
        buf.append("Ignore Whitespace (-iw)         : " + this.isDeleteWhitespace() + "\n");
        buf.append("Ignore Comments (-ic)           : " + this.isDeleteComments() + "\n");
        buf.append("\n");
        return buf.toString();
    }
}

