/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.text;

import com.google.inject.Injector;
import eu.qimpress.ide.editors.text.internal.TBPActivator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class TBPExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private Logger log = Logger.getLogger(TBPExecutableExtensionFactory.class);
    private String clazzName;
    private IConfigurationElement config;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof String)) {
            throw new IllegalArgumentException("couldn't handle passed data : " + data);
        }
        this.clazzName = (String)data;
        this.config = config;
    }

    public Object create() throws CoreException {
        TBPActivator instance = TBPActivator.getInstance();
        if (instance == null) {
            throw new IllegalStateException("The bundle has not yet been activated. Make sure the Manifest.MF contains 'Bundle-ActivationPolicy: lazy'.");
        }
        Bundle bundle = instance.getBundle();
        try {
            Class clazz = bundle.loadClass(this.clazzName);
            Injector injector = TBPActivator.getInstance().getInjector("eu.qimpress.ide.editors.text.TBP");
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, null, null);
            }
            return result;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }
}

