/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ProfileMetadataRepository
extends AbstractMetadataRepository {
    private static final String DEFAULT_ARTIFACT_REPO_DIRECTORY = "org.eclipse.equinox.p2.core/cache";
    private static final String ARTIFACTS_XML = "artifacts.xml";
    private static final String FILE_SCHEME = "file";
    private static final String DOT_PROFILE = ".profile";
    public static final String TYPE = "org.eclipse.equinox.p2.engine.repo.metadataRepository";
    public static final Integer VERSION = new Integer(1);
    private IProfile profile;

    public ProfileMetadataRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        super(location.toString(), TYPE, VERSION.toString(), location, null, null, null);
        try {
            this.profile = ProfileMetadataRepository.getProfile(location);
        }
        catch (RuntimeException e) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", 1002, e.getMessage(), (Throwable)e));
        }
        this.publishArtifactRepos();
    }

    private void publishArtifactRepos() {
        List artifactRepos = this.findArtifactRepos();
        IProvisioningEventBus bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        Iterator it = artifactRepos.iterator();
        while (it.hasNext()) {
            URI repo = (URI)it.next();
            bus.publishEvent((EventObject)new RepositoryEvent(repo, 1, 4, true));
        }
    }

    private List findArtifactRepos() {
        String dropinRepositories;
        String sharedBundlePool;
        String bundlePool;
        ArrayList<URI> artifactRepos = new ArrayList<URI>();
        File p2Directory = this.findP2Directory();
        File agentArtifactRepository = this.findAgentArtifactRepositoryDirectory(p2Directory);
        if (agentArtifactRepository != null) {
            artifactRepos.add(agentArtifactRepository.toURI());
        }
        if ((bundlePool = this.profile.getProperty("org.eclipse.equinox.p2.cache")) != null) {
            File bundlePoolFile = new File(bundlePool);
            if (bundlePoolFile.exists()) {
                artifactRepos.add(bundlePoolFile.toURI());
            } else if (Boolean.valueOf(this.profile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
                bundlePoolFile = this.findDefaultBundlePool(p2Directory);
                if (bundlePoolFile != null) {
                    artifactRepos.add(bundlePoolFile.toURI());
                }
                return artifactRepos;
            }
        }
        if ((sharedBundlePool = this.profile.getProperty("org.eclipse.equinox.p2.cache.shared")) != null) {
            artifactRepos.add(new File(sharedBundlePool).toURI());
        }
        if ((dropinRepositories = this.profile.getProperty("org.eclipse.equinox.p2.cache.extensions")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, "|");
            while (tokenizer.hasMoreTokens()) {
                String repoLocation = "";
                try {
                    repoLocation = tokenizer.nextToken();
                    artifactRepos.add(new URI(repoLocation));
                }
                catch (URISyntaxException e) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "invalid repo reference with location: " + repoLocation, (Throwable)e));
                }
            }
        }
        return artifactRepos;
    }

    private File findAgentArtifactRepositoryDirectory(File p2Directory) {
        if (p2Directory == null) {
            return null;
        }
        File agentArtifactRepositoryDirectory = new File(p2Directory, DEFAULT_ARTIFACT_REPO_DIRECTORY);
        if (!agentArtifactRepositoryDirectory.isDirectory()) {
            return null;
        }
        return agentArtifactRepositoryDirectory;
    }

    private File findDefaultBundlePool(File p2Directory) {
        if (p2Directory == null) {
            return null;
        }
        File productDirectory = p2Directory.getParentFile();
        if (productDirectory == null || !new File(productDirectory, ARTIFACTS_XML).exists()) {
            return null;
        }
        return productDirectory;
    }

    private File findP2Directory() {
        File profileRegistryDirectory;
        File target = new File(this.location);
        if (target.isFile()) {
            target = target.getParentFile();
        }
        if ((profileRegistryDirectory = target.getParentFile()) == null) {
            return null;
        }
        File p2EngineDirectory = profileRegistryDirectory.getParentFile();
        if (p2EngineDirectory == null) {
            return null;
        }
        return p2EngineDirectory.getParentFile();
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return this.profile.query(query, collector, monitor);
    }

    public static void validate(URI location, IProgressMonitor monitor) throws ProvisionException {
        try {
            ProfileMetadataRepository.getProfile(location);
        }
        catch (RuntimeException e) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", 1002, e.getMessage(), (Throwable)e));
        }
    }

    private static IProfile getProfile(URI location) throws ProvisionException {
        IProfile profile;
        File target;
        if (!FILE_SCHEME.equalsIgnoreCase(location.getScheme())) {
            ProfileMetadataRepository.fail(location, 1000);
        }
        if (!(target = new File(location)).exists()) {
            ProfileMetadataRepository.fail(location, 1000);
        }
        long timestamp = -1L;
        int index = target.getName().lastIndexOf(DOT_PROFILE);
        if (index == -1) {
            ProfileMetadataRepository.fail(location, 1000);
        }
        String profileId = target.getName().substring(0, index);
        if (target.isFile()) {
            try {
                timestamp = Long.parseLong(profileId);
            }
            catch (NumberFormatException numberFormatException) {
                ProfileMetadataRepository.fail(location, 1002);
            }
            target = target.getParentFile();
            if (target == null) {
                ProfileMetadataRepository.fail(location, 1000);
            }
            index = target.getName().lastIndexOf(DOT_PROFILE);
            profileId = target.getName().substring(0, index);
        }
        profileId = SimpleProfileRegistry.unescape(profileId);
        File registryDirectory = target.getParentFile();
        if (registryDirectory == null) {
            ProfileMetadataRepository.fail(location, 1000);
        }
        SimpleProfileRegistry profileRegistry = new SimpleProfileRegistry(registryDirectory, null, false);
        if (timestamp == -1L) {
            long[] timestamps = profileRegistry.listProfileTimestamps(profileId);
            timestamp = timestamps[timestamps.length - 1];
        }
        if ((profile = profileRegistry.getProfile(profileId, timestamp)) == null) {
            ProfileMetadataRepository.fail(location, 1000);
        }
        return profile;
    }

    private static void fail(URI location, int code) throws ProvisionException {
        switch (code) {
            case 1000: {
                String msg = NLS.bind((String)Messages.io_NotFound, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1000, msg, null));
            }
            case 1002: {
                String msg = NLS.bind((String)Messages.io_FailedRead, (Object)location);
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1000, msg, null));
            }
        }
    }
}

