/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.providers;

import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.repository.diagram.providers.SammElementTypes;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class SammViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        return true;
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "SAMM Repository".equals(op.getSemanticHint()) && SammVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = SammVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = SammVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!SammElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != SammVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"SAMM Repository".equals(SammVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 2001: 
                    case 2002: 
                    case 2003: 
                    case 2004: 
                    case 3001: 
                    case 3002: 
                    case 3003: 
                    case 3005: 
                    case 3006: 
                    case 3007: 
                    case 3008: {
                        if (domainElement != null && visualID == SammVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2001 == visualID || 2002 == visualID || 2003 == visualID || 2004 == visualID || 3002 == visualID || 3005 == visualID || 3006 == visualID || 3008 == visualID || 3007 == visualID || 3003 == visualID || 3001 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!SammElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = SammVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == SammVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("SAMM Repository");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? SammVisualIDRegistry.getNodeVisualID(containerView, domainElement) : SammVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2001: {
                return this.createMessageType_2001(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2002: {
                return this.createCompositeComponent_2002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2003: {
                return this.createPrimitiveComponent_2003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2004: {
                return this.createInterface_2004(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3002: {
                return this.createParameter_3002(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3005: {
                return this.createSubcomponentInstance_3005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3006: {
                return this.createSeffBehaviourStub_3006(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3008: {
                return this.createGastBehaviourStub_3008(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3007: {
                return this.createTBPBehaviourStub_3007(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3003: {
                return this.createOperationBehaviour_3003(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3001: {
                return this.createOperation_3001(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (SammVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 4001: {
                return this.createInterfacePort_4001(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4004: {
                return this.createInterfacePort_4004(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4002: {
                return this.createEventPort_4002(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4005: {
                return this.createEventPort_4005(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4003: {
                return this.createInterfaceInheritance_4003(containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createMessageType_2001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SammVisualIDRegistry.getType(2001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, SammVisualIDRegistry.getType(5001));
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7002), true, false, true, true);
        return node;
    }

    public Node createCompositeComponent_2002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SammVisualIDRegistry.getType(2002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, SammVisualIDRegistry.getType(5002));
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7005), true, false, true, true);
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7006), true, true, true, true);
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7007), true, true, true, true);
        return node;
    }

    public Node createPrimitiveComponent_2003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SammVisualIDRegistry.getType(2003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, SammVisualIDRegistry.getType(5003));
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7003), true, true, true, true);
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7004), true, true, true, true);
        return node;
    }

    public Node createInterface_2004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(SammVisualIDRegistry.getType(2004));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, SammVisualIDRegistry.getType(5004));
        this.createCompartment((View)node, SammVisualIDRegistry.getType(7001), true, false, true, true);
        return node;
    }

    public Node createParameter_3002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3002));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createSubcomponentInstance_3005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createOperationBehaviour_3003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3003));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createSeffBehaviourStub_3006(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3006));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createGastBehaviourStub_3008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3008));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createTBPBehaviourStub_3007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3007));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Node createOperation_3001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(SammVisualIDRegistry.getType(3001));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        return node;
    }

    public Edge createInterfacePort_4001(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Routing routing;
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SammVisualIDRegistry.getType(4001));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        if ((routing = Routing.get((int)prefStore.getInt("Connectors.lineStyle"))) != null) {
            ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        Node label6001 = this.createLabel((View)edge, SammVisualIDRegistry.getType(6001));
        label6001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6001 = (Location)label6001.getLayoutConstraint();
        location6001.setX(0);
        location6001.setY(40);
        return edge;
    }

    public Edge createInterfacePort_4004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Routing routing;
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SammVisualIDRegistry.getType(4004));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        if ((routing = Routing.get((int)prefStore.getInt("Connectors.lineStyle"))) != null) {
            ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        Node label6003 = this.createLabel((View)edge, SammVisualIDRegistry.getType(6003));
        label6003.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6003 = (Location)label6003.getLayoutConstraint();
        location6003.setX(0);
        location6003.setY(40);
        return edge;
    }

    public Edge createEventPort_4002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Routing routing;
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SammVisualIDRegistry.getType(4002));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        if ((routing = Routing.get((int)prefStore.getInt("Connectors.lineStyle"))) != null) {
            ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        Node label6002 = this.createLabel((View)edge, SammVisualIDRegistry.getType(6002));
        label6002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6002 = (Location)label6002.getLayoutConstraint();
        location6002.setX(0);
        location6002.setY(40);
        return edge;
    }

    public Edge createEventPort_4005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Routing routing;
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SammVisualIDRegistry.getType(4005));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        if ((routing = Routing.get((int)prefStore.getInt("Connectors.lineStyle"))) != null) {
            ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        Node label6004 = this.createLabel((View)edge, SammVisualIDRegistry.getType(6004));
        label6004.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6004 = (Location)label6004.getLayoutConstraint();
        location6004.setX(0);
        location6004.setY(40);
        return edge;
    }

    public Edge createInterfaceInheritance_4003(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Routing routing;
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(SammVisualIDRegistry.getType(4003));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        if ((routing = Routing.get((int)prefStore.getInt("Connectors.lineStyle"))) != null) {
            ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getRoutingStyle_Routing(), (Object)routing);
        }
        return edge;
    }

    private void stampShortcut(View containerView, Node target) {
        if (!"SAMM Repository".equals(SammVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"SAMM Repository");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    private Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            ts.setShowTitle(true);
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

