/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.part;

import eu.qimpress.ide.editors.gmf.repository.diagram.part.SammDiagramEditorPlugin;
import eu.qimpress.samm.behaviour.BehaviourPackage;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class SammVisualIDRegistry {
    private static final String DEBUG_KEY = "eu.qimpress.ide.editors.gmf.repository.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("SAMM Repository".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SammVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SammDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (StaticstructurePackage.eINSTANCE.getRepository().isSuperTypeOf(domainElement.eClass()) && SammVisualIDRegistry.isDiagram((Repository)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SammVisualIDRegistry.getModelID(containerView);
        if (!"SAMM Repository".equals(containerModelID)) {
            return -1;
        }
        if ("SAMM Repository".equals(containerModelID)) {
            containerVisualID = SammVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7002: {
                if (!StaticstructurePackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7005: {
                if (!StaticstructurePackage.eINSTANCE.getSubcomponentInstance().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7006: {
                if (BehaviourPackage.eINSTANCE.getSeffBehaviourStub().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (!BehaviourPackage.eINSTANCE.getGastBehaviourStub().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7007: {
                if (!BehaviourPackage.eINSTANCE.getTBPBehaviourStub().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7003: {
                if (BehaviourPackage.eINSTANCE.getSeffBehaviourStub().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (BehaviourPackage.eINSTANCE.getGastBehaviourStub().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!BehaviourPackage.eINSTANCE.getOperationBehaviour().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (!BehaviourPackage.eINSTANCE.getTBPBehaviourStub().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7001: {
                if (!StaticstructurePackage.eINSTANCE.getOperation().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 1000: {
                if (StaticstructurePackage.eINSTANCE.getMessageType().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (StaticstructurePackage.eINSTANCE.getCompositeComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (StaticstructurePackage.eINSTANCE.getPrimitiveComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (!StaticstructurePackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 2004;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SammVisualIDRegistry.getModelID(containerView);
        if (!"SAMM Repository".equals(containerModelID)) {
            return false;
        }
        if ("SAMM Repository".equals(containerModelID)) {
            containerVisualID = SammVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6003 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6004 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Required().equals(domainElement.eContainmentFeature())) {
            return 4001;
        }
        if (StaticstructurePackage.eINSTANCE.getInterfacePort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Provided().equals(domainElement.eContainmentFeature())) {
            return 4004;
        }
        if (StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Sink().equals(domainElement.eContainmentFeature())) {
            return 4002;
        }
        if (StaticstructurePackage.eINSTANCE.getEventPort().isSuperTypeOf(domainElement.eClass()) && StaticstructurePackage.eINSTANCE.getPortEnabledEntity_Sink().equals(domainElement.eContainmentFeature())) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(Repository element) {
        return true;
    }
}

