/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.policies.SammBaseItemSemanticEditPolicy;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class InterfacePort2CreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;

    public InterfacePort2CreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof PortEnabledEntity)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Interface)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canCreateInterfacePort_4004(this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        InterfacePort newElement = StaticstructureFactory.eINSTANCE.createInterfacePort();
        this.getSource().getProvided().add((Object)newElement);
        newElement.setInterfaceType(this.getTarget());
        StringBuilder newName = new StringBuilder();
        newName.append(this.getSource().getName() != null ? String.valueOf(this.getSource().getName()) + "_" : "");
        String containmentFeature = newElement.eContainmentFeature().getName();
        newName.append(String.valueOf(containmentFeature.substring(0, 1).toUpperCase()) + containmentFeature.substring(1));
        newName.append(this.getTarget().getName() != null ? "_" + this.getTarget().getName() : "");
        newElement.setName(newName.toString());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(InterfacePort newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected PortEnabledEntity getSource() {
        return (PortEnabledEntity)this.source;
    }

    protected Interface getTarget() {
        return (Interface)this.target;
    }
}

