/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.policies.SammBaseItemSemanticEditPolicy;
import eu.qimpress.samm.staticstructure.Interface;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;

public class InterfaceInheritanceReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public InterfaceInheritanceReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Interface)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistInterfaceInheritance_4003(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Interface) || !(this.newEnd instanceof Interface)) {
            return false;
        }
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistInterfaceInheritance_4003(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getInheritance().remove((Object)this.getOldTarget());
        this.getNewSource().getInheritance().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getInheritance().remove((Object)this.getOldTarget());
        this.getOldSource().getInheritance().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Interface getOldSource() {
        return (Interface)this.referenceOwner;
    }

    protected Interface getNewSource() {
        return (Interface)this.newEnd;
    }

    protected Interface getOldTarget() {
        return (Interface)this.oldEnd;
    }

    protected Interface getNewTarget() {
        return (Interface)this.newEnd;
    }
}

