/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.editors.gmf.repository.diagram.edit.commands;

import eu.qimpress.ide.editors.gmf.repository.diagram.edit.policies.SammBaseItemSemanticEditPolicy;
import eu.qimpress.samm.staticstructure.EventPort;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class EventPort2ReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public EventPort2ReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof EventPort)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof PortEnabledEntity) || !(this.newEnd instanceof PortEnabledEntity)) {
            return false;
        }
        MessageType target = this.getLink().getMessage();
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistEventPort_4005(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof MessageType) || !(this.newEnd instanceof MessageType)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof PortEnabledEntity)) {
            return false;
        }
        PortEnabledEntity source = (PortEnabledEntity)this.getLink().eContainer();
        return SammBaseItemSemanticEditPolicy.LinkConstraints.canExistEventPort_4005(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getSink().remove((Object)this.getLink());
        this.getNewSource().getSink().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setMessage(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected EventPort getLink() {
        return (EventPort)this.getElementToEdit();
    }

    protected PortEnabledEntity getOldSource() {
        return (PortEnabledEntity)this.oldEnd;
    }

    protected PortEnabledEntity getNewSource() {
        return (PortEnabledEntity)this.newEnd;
    }

    protected MessageType getOldTarget() {
        return (MessageType)this.oldEnd;
    }

    protected MessageType getNewTarget() {
        return (MessageType)this.newEnd;
    }
}

