/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.utils;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.samm.usagemodel.UsageModel;
import eu.qimpress.samm.usagemodel.UsageRepository;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SAMMModelsUtils {
    private static final Logger logger = Logger.getLogger(SAMMModelsUtils.class);

    public static UsageModel[] getUsageModels(IQAlternative alternative, EnumModelLookup lookup) throws RepositoryException {
        UsageModel[] result = null;
        if (lookup.support(EnumModelLookup.ONLY_LOCAL)) {
            result = SAMMModelsUtils.getUsageModels(alternative);
        }
        if (lookup.support(EnumModelLookup.ONLY_COMMON)) {
            IQRepository qRepo = alternative.getRepository();
            UsageModel[] commonResult = SAMMModelsUtils.getUsageModels(qRepo.getGlobalAlternative());
            if (result != null) {
                int localResultLen = result.length;
                result = Arrays.copyOf(result, result.length + commonResult.length);
                int i = 0;
                while (i < commonResult.length) {
                    result[localResultLen + i] = commonResult[i];
                    ++i;
                }
            } else {
                result = commonResult;
            }
        }
        return result;
    }

    public static UsageModel[] getUsageModels(IQAlternative alternative) throws RepositoryException {
        IQModel model = alternative.getModel("samm_usagemodel");
        UsageRepository usageRepositoryObject = model.getTopLevelEObject(UsageRepository.class);
        if (usageRepositoryObject != null && usageRepositoryObject instanceof UsageRepository) {
            UsageRepository usageRepository = usageRepositoryObject;
            if (usageRepository.getUsageModels().size() > 0) {
                return (UsageModel[])usageRepository.getUsageModels().toArray((Object[])new UsageModel[0]);
            }
            return new UsageModel[0];
        }
        logger.warn((Object)("No usage repository or corrupted usage repository in alternative: " + alternative));
        return new UsageModel[0];
    }

    public static enum EnumModelLookup {
        ONLY_LOCAL(1),
        ONLY_COMMON(2),
        LOCAL_AND_COMMON(3);

        private int value;

        private EnumModelLookup(int i) {
            this.value = i;
        }

        public boolean support(EnumModelLookup lookup) {
            boolean res = (this.value & lookup.value) != 0;
            return res;
        }
    }
}

