/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.model;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class QElementResourceMapping
extends ResourceMapping {
    protected QElementResourceMapping() {
    }

    public IQElement getQElement() {
        Object o = this.getModelObject();
        if (o instanceof IQElement) {
            return (IQElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QElementResourceMapping)) {
            return false;
        }
        return this.getQElement().equals(((QElementResourceMapping)((Object)obj)).getQElement());
    }

    public int hashCode() {
        IQElement qAppElement = this.getQElement();
        if (qAppElement == null) {
            return super.hashCode();
        }
        return qAppElement.hashCode();
    }

    public String getModelProviderId() {
        return QImpressApplicationModelProvider.QIMPRESS_APP_MODEL_PROVIDER_ID;
    }

    public static ResourceMapping create(IQElement element) {
        switch (element.getElementType()) {
            case Q_APPLICATION_MODEL: {
                return QElementResourceMapping.create((IQApplicationModel)element);
            }
            case Q_REPOSITORY: {
                return QElementResourceMapping.create((IQRepository)element);
            }
            case Q_PROJECT: {
                return QElementResourceMapping.create((IQProject)element);
            }
            case Q_ALTERNATIVE: {
                return QElementResourceMapping.create((IQAlternative)element);
            }
            case Q_MODEL: {
                return QElementResourceMapping.create((IQModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IQApplicationModel model) {
        return new QAppModelResourceMapping(model);
    }

    public static ResourceMapping create(IQProject project) {
        return new QProjectResourceMapping(project);
    }

    public static ResourceMapping create(IQRepository repository) {
        return new QRepositoryResourceMapping(repository);
    }

    public static ResourceMapping create(IQAlternative alternative) {
        return new QAlternativeResourceMapping(alternative);
    }

    public static ResourceMapping create(IQModel model) {
        return null;
    }

    private static final class QAlternativeResourceMapping
    extends QElementResourceMapping {
        private final IQAlternative qAlternative;

        private QAlternativeResourceMapping(IQAlternative qAlternative) {
            this.qAlternative = qAlternative;
        }

        public Object getModelObject() {
            return this.qAlternative;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.qAlternative.getAlternativeFolder().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.qAlternative.getCorrespondingResource()}, 2, 0)};
        }
    }

    private static final class QAppModelResourceMapping
    extends QElementResourceMapping {
        private final IQApplicationModel qAppModel;

        private QAppModelResourceMapping(IQApplicationModel qAppModel) {
            this.qAppModel = qAppModel;
        }

        public Object getModelObject() {
            return this.qAppModel;
        }

        public IProject[] getProjects() {
            IQProject[] qProjects = this.qAppModel.getQProjects();
            IProject[] result = new IProject[qProjects.length];
            int i = 0;
            IQProject[] iQProjectArray = qProjects;
            int n = qProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IQProject project = iQProjectArray[n2];
                result[i++] = project.getProject();
                ++n2;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IQProject[] qProjects = this.qAppModel.getQProjects();
            ResourceTraversal[] result = new ResourceTraversal[qProjects.length];
            int i = 0;
            IQProject[] iQProjectArray = qProjects;
            int n = qProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IQProject p = iQProjectArray[n2];
                result[i++] = new ResourceTraversal(new IResource[]{p.getProject()}, 2, 0);
                ++n2;
            }
            return result;
        }
    }

    private static final class QProjectResourceMapping
    extends QElementResourceMapping {
        private final IQProject qProject;

        private QProjectResourceMapping(IQProject qAppProject) {
            this.qProject = qAppProject;
        }

        public Object getModelObject() {
            return this.qProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.qProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.qProject.getProject()}, 2, 0)};
        }
    }

    private static final class QRepositoryResourceMapping
    extends QElementResourceMapping {
        private final IQRepository qRepository;

        public QRepositoryResourceMapping(IQRepository repository) {
            this.qRepository = repository;
        }

        public Object getModelObject() {
            return this.qRepository;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.qRepository.getRepositoryFolder().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.qRepository.getCorrespondingResource()}, 2, 0)};
        }
    }
}

