/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.QAlternativeImpl;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class QModelImpl
extends QElement
implements IQModel {
    private static final Logger logger = Logger.getLogger(QModelImpl.class);
    private IFile repositoryFile;
    private String name;
    private IQAlternative alternative;
    private boolean deleted;

    public QModelImpl(IFile repoFile, IQAlternative alternative) {
        this(repoFile, repoFile.getFileExtension(), alternative);
    }

    public QModelImpl(IFile repoFile, String name, IQAlternative alternative) {
        super(alternative);
        this.name = name;
        this.repositoryFile = repoFile;
        this.alternative = alternative;
    }

    @Override
    public IQAlternative getAlternative() {
        return this.alternative;
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.repositoryFile;
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_MODEL;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream result = null;
        if (this.repositoryFile.exists()) {
            try {
                return this.repositoryFile.getContents();
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.repositoryFile.getName();
    }

    @Override
    public String getType() {
        return this.repositoryFile.getFileExtension();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public EObject getTopLevelEObject() {
        return this.getTopLevelEObject(EObject.class);
    }

    @Override
    public <T extends EObject> T getTopLevelEObject(Class<T> clazz) {
        return this.getTopLevelEObject(clazz, null);
    }

    @Override
    public <T extends EObject> T getTopLevelEObject(Class<T> clazz, EClass eclazz) {
        EObject topLevelEObject = null;
        Resource resource = (Resource)this.getAdapter(Resource.class);
        if (resource != null) {
            if (!resource.getContents().isEmpty()) {
                topLevelEObject = (EObject)resource.getContents().get(0);
            } else if (eclazz != null) {
                topLevelEObject = eclazz.getEPackage().getEFactoryInstance().create(eclazz);
                resource.getContents().add((Object)topLevelEObject);
            } else {
                logger.debug((Object)("The top-level EObject is not created for IQModel: " + this));
            }
        } else {
            logger.warn((Object)("Cannot get EMF resource for the IQModel: " + this));
        }
        return (T)topLevelEObject;
    }

    @Override
    public void delete() throws RepositoryException {
        if (!this.repositoryFile.exists()) {
            throw new IllegalStateException("Model is already deleted.");
        }
        this.internalDelete();
        ((QAlternativeImpl)this.alternative).internalDelete(this.name);
    }

    void internalDelete() throws RepositoryException {
        try {
            this.repositoryFile.delete(true, false, null);
            this.deleted = true;
        }
        catch (CoreException ex) {
            throw new RepositoryException("Model cannot be deleted.", ex);
        }
    }

    public String toString() {
        return "QModelImpl [name=" + this.name + ", repositoryFile=" + this.repositoryFile + "]";
    }

    @Override
    public void save() throws RepositoryException {
        Resource resource = (Resource)this.getAdapter(Resource.class);
        if (resource != null) {
            try {
                resource.save(null);
            }
            catch (IOException iOException) {
                logger.error((Object)("Model save failed - cannot save EMF resource for the IQModel: " + this));
                throw new RepositoryException("Cannot save EMF resource for model: " + this);
            }
        } else {
            logger.error((Object)("Model save failed - cannot get EMF resource for the IQModel: " + this));
            throw new RepositoryException("Cannot obtain EMF resource for model: " + this);
        }
    }
}

