/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.internal.model.QProjectImpl;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQApplicationModelChangeListener;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class QApplicationModelImpl
extends QElement
implements IQApplicationModel {
    private Map<IProject, IQProject> projectsMap = new HashMap<IProject, IQProject>();
    private Set<IQApplicationModelChangeListener> refreshListeners = new HashSet<IQApplicationModelChangeListener>();
    private static final Logger logger = Logger.getLogger(QApplicationModelImpl.class);

    public QApplicationModelImpl() {
        super(null);
        this.initApplicationModel();
    }

    private void initApplicationModel() {
        IProject[] projects;
        IWorkspace workspace = this.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.hasQINature(project)) {
                this.getQProject(project);
            }
            ++n2;
        }
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_APPLICATION_MODEL;
    }

    @Override
    public IResource getCorrespondingResource() {
        return null;
    }

    @Override
    public synchronized IQProject getQProject(IProject project) {
        if (project == null) {
            return null;
        }
        if (!project.isAccessible()) {
            return null;
        }
        if (this.projectsMap.containsKey(project)) {
            return this.projectsMap.get(project);
        }
        QProjectImpl qProject = new QProjectImpl(project, this);
        this.projectsMap.put(project, qProject);
        return qProject;
    }

    @Override
    public IQElement[] getChildren() {
        return this.getQProjects();
    }

    @Override
    public boolean hasChildren() {
        return !this.projectsMap.isEmpty();
    }

    @Override
    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public IQProject[] getQProjects() {
        Collection<IQProject> qProjects = this.projectsMap.values();
        return qProjects.toArray(new IQProject[qProjects.size()]);
    }

    @Override
    public void addChangeListener(IQApplicationModelChangeListener listener) {
        this.refreshListeners.add(listener);
    }

    @Override
    public void removeChangeListener(IQApplicationModelChangeListener listener) {
        this.refreshListeners.remove(listener);
    }

    @Override
    public void fireRefresh() {
        for (IQApplicationModelChangeListener listener : this.refreshListeners) {
            listener.refresh();
        }
    }

    @Override
    public void fireAlternativeCreated(IQAlternative alternative) {
        for (IQApplicationModelChangeListener listener : this.refreshListeners) {
            listener.alternativeCreated(alternative);
        }
    }

    @Override
    public void fireModelCreated(IQModel[] models) {
        this.updateModelsInAlternatives(models);
        for (IQApplicationModelChangeListener listener : this.refreshListeners) {
            listener.modelCreated(models);
        }
    }

    @Override
    public void fireModelModified(IQModel[] models) {
        this.updateModelsInAlternatives(models);
        for (IQApplicationModelChangeListener listener : this.refreshListeners) {
            listener.modelModified(models);
        }
    }

    @Override
    public void fireModelDeleted(IQModel[] models) {
        this.updateModelsInAlternatives(models);
        for (IQApplicationModelChangeListener listener : this.refreshListeners) {
            listener.modelDeleted(models);
        }
    }

    public void updateModelsInAlternatives(IQModel[] models) {
        IQModel[] iQModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel iqModel = iQModelArray[n2];
            IPath loc = iqModel.getCorrespondingResource().getLocation();
            String alternativeId = QImpressCore.getAlternativeId(loc);
            IQAlternative alternative = QImpressCore.getAlternativeById(alternativeId);
            alternative.getModels(true);
            ++n2;
        }
    }

    @Override
    public IQElement getElementByID(String id) {
        for (IQProject p : this.projectsMap.values()) {
            try {
                IQAlternative alt;
                IQRepository repo = p.getRepository();
                if (repo.isClosed() || (alt = p.getRepository().getAlternative(id)) == null) continue;
                return alt;
            }
            catch (RepositoryException repositoryException) {
                logger.debug((Object)("Cannot get element by ID: " + id));
            }
        }
        return null;
    }

    private boolean hasQINature(IProject project) {
        if (project.isAccessible()) {
            try {
                return project.hasNature("eu.qimpress.ide.backbone.core.ui.QImpressNature");
            }
            catch (CoreException coreException) {
                logger.debug((Object)("Cannot get project nature for project " + project));
            }
        }
        return false;
    }

    @Override
    public void removeQProject(IProject project) throws RepositoryException {
        if (this.projectsMap.containsKey(project)) {
            IQProject qProject = this.projectsMap.get(project);
            qProject.getRepository().close();
            this.projectsMap.remove(project);
        } else {
            logger.warn((Object)("Trying to remove projects which is not in application model, project: " + project));
        }
    }
}

