/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.errorhandling.IIssue;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.analyser.exceptions.ExpectedTypeMismatchIssue;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.util.ArrayList;
import java.util.Collection;

public class TypeCheckVisitor
extends StoexSwitch<Object> {
    private ExpressionInferTypeVisitor typeVisitor;
    private ArrayList<IIssue> issues = new ArrayList();

    public TypeCheckVisitor(NonProbabilisticExpressionInferTypeVisitor typeVisitor) {
        this.typeVisitor = typeVisitor;
    }

    public Object caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getLeft()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getLeft())));
        }
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getRight()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getRight())));
        }
        return super.caseBooleanOperatorExpression(object);
    }

    public Object caseIfElseExpression(IfElseExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getConditionExpression()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getConditionExpression())));
        }
        return super.caseIfElseExpression(object);
    }

    public Object caseNotExpression(NotExpression object) {
        if (!TypeCheckVisitor.typesCompatible(this.typeVisitor.getType((Expression)object.getInner()), TypeEnum.BOOL)) {
            this.issues.add(new ExpectedTypeMismatchIssue(TypeEnum.BOOL, this.typeVisitor.getType((Expression)object.getInner())));
        }
        return super.caseNotExpression(object);
    }

    public Object caseProductExpression(ProductExpression object) {
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getLeft()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getLeft())));
        }
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getRight()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getRight())));
        }
        return super.caseProductExpression(object);
    }

    public Object caseTermExpression(TermExpression object) {
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getLeft()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getLeft())));
        }
        if (!this.isNummericType(this.typeVisitor.getType((Expression)object.getRight()))) {
            this.issues.add(new ExpectedTypeMismatchIssue("Numeric", this.typeVisitor.getType((Expression)object.getRight())));
        }
        return super.caseTermExpression(object);
    }

    public static boolean typesCompatible(TypeEnum expectedType, TypeEnum foundType) {
        if (expectedType == TypeEnum.ANY) {
            return true;
        }
        if (expectedType == foundType) {
            return true;
        }
        if (foundType == TypeEnum.ANY) {
            return true;
        }
        return expectedType == TypeEnum.DOUBLE && (foundType == TypeEnum.INT || foundType == TypeEnum.DOUBLE);
    }

    private boolean isNummericType(TypeEnum type) {
        return type == TypeEnum.INT || type == TypeEnum.DOUBLE || type == TypeEnum.ANY;
    }

    public Collection<IIssue> getIssues() {
        return this.issues;
    }
}

