/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.probfunction.print.ProbFunctionPrettyPrint;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.VariableReference;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

public class StoExPrettyPrintVisitor
extends StoexSwitch<String> {
    public String caseBoolLiteral(BoolLiteral object) {
        return object.isValue() ? "true" : "false";
    }

    public String casePowerExpression(PowerExpression object) {
        return String.valueOf((String)this.doSwitch((EObject)object.getBase())) + " ^ " + (String)this.doSwitch((EObject)object.getExponent());
    }

    public String caseStringLiteral(StringLiteral object) {
        return "\"" + object.getValue() + "\"";
    }

    public String caseCompareExpression(CompareExpression object) {
        String op = "";
        switch (object.getOperation()) {
            case EQUALS: {
                op = " == ";
                break;
            }
            case GREATER: {
                op = " > ";
                break;
            }
            case GREATEREQUAL: {
                op = " >= ";
                break;
            }
            case LESS: {
                op = " < ";
                break;
            }
            case LESSEQUAL: {
                op = " <= ";
                break;
            }
            case NOTEQUAL: {
                op = " <> ";
            }
        }
        return String.valueOf((String)this.doSwitch((EObject)object.getLeft())) + op + (String)this.doSwitch((EObject)object.getRight());
    }

    public String caseDoubleLiteral(DoubleLiteral object) {
        DecimalFormat df = new DecimalFormat("#0.0###########", new DecimalFormatSymbols(Locale.US));
        return df.format(object.getValue());
    }

    public String caseIntLiteral(IntLiteral object) {
        return Integer.toString(object.getValue());
    }

    public String caseParenthesis(Parenthesis object) {
        return "( " + (String)this.doSwitch((EObject)object.getInnerExpression()) + " )";
    }

    public String caseProbabilityFunctionLiteral(ProbabilityFunctionLiteral object) {
        return (String)new ProbFunctionPrettyPrint().doSwitch((EObject)object.getFunction_ProbabilityFunctionLiteral());
    }

    public String caseProductExpression(ProductExpression object) {
        String op = "";
        switch (object.getOperation()) {
            case MULT: {
                op = " * ";
                break;
            }
            case MOD: {
                op = " % ";
                break;
            }
            case DIV: {
                op = " / ";
            }
        }
        return String.valueOf((String)this.doSwitch((EObject)object.getLeft())) + op + (String)this.doSwitch((EObject)object.getRight());
    }

    public String caseTermExpression(TermExpression object) {
        String op = "";
        switch (object.getOperation()) {
            case ADD: {
                op = " + ";
                break;
            }
            case SUB: {
                op = " - ";
            }
        }
        return String.valueOf((String)this.doSwitch((EObject)object.getLeft())) + op + (String)this.doSwitch((EObject)object.getRight());
    }

    public String caseNamespaceReference(NamespaceReference object) {
        return String.valueOf(object.getReferenceName()) + "." + (String)this.doSwitch((EObject)object.getInnerReference_NamespaceReference());
    }

    public String caseVariableReference(VariableReference object) {
        return object.getReferenceName();
    }

    public String caseVariable(Variable object) {
        String result = (String)this.doSwitch((EObject)object.getId_Variable());
        return result;
    }

    public String prettyPrint(EObject theObject) {
        return (String)this.doSwitch(theObject);
    }

    public String caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        String result = (String)this.doSwitch((EObject)object.getLeft());
        result = String.valueOf(result) + " " + object.getOperation().getLiteral() + " ";
        return String.valueOf(result) + (String)this.doSwitch((EObject)object.getRight());
    }

    public String caseNegativeExpression(NegativeExpression object) {
        return "-" + (String)this.doSwitch((EObject)object.getInner());
    }

    public String caseNotExpression(NotExpression object) {
        return "NOT " + (String)this.doSwitch((EObject)object.getInner());
    }

    public String caseFunctionLiteral(FunctionLiteral object) {
        String result = String.valueOf(object.getId()) + "(";
        int i = 0;
        while (i < object.getParameters_FunctionLiteral().size() - 1) {
            result = String.valueOf(result) + (String)this.doSwitch((EObject)object.getParameters_FunctionLiteral().get(i)) + ", ";
            ++i;
        }
        result = String.valueOf(result) + (String)this.doSwitch((EObject)object.getParameters_FunctionLiteral().get(object.getParameters_FunctionLiteral().size() - 1)) + ")";
        return result;
    }

    public String caseIfElseExpression(IfElseExpression object) {
        return String.valueOf((String)this.doSwitch((EObject)object.getConditionExpression())) + " ? " + (String)this.doSwitch((EObject)object.getIfExpression()) + " : " + (String)this.doSwitch((EObject)object.getElseExpression());
    }
}

