/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.repository.edit.commands;

import de.uka.ipd.sdq.pcm.core.entity.InterfaceRequiringEntity;
import de.uka.ipd.sdq.pcm.gmf.repository.edit.policies.PalladioComponentModelBaseItemSemanticEditPolicy;
import de.uka.ipd.sdq.pcm.repository.EventGroup;
import de.uka.ipd.sdq.pcm.repository.SourceRole;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class SourceRoleReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public SourceRoleReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof SourceRole)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof InterfaceRequiringEntity) || !(this.newEnd instanceof InterfaceRequiringEntity)) {
            return false;
        }
        EventGroup target = this.getLink().getEventGroup__SourceRole();
        return PalladioComponentModelBaseItemSemanticEditPolicy.LinkConstraints.canExistSourceRole_4110(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof EventGroup) || !(this.newEnd instanceof EventGroup)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof InterfaceRequiringEntity)) {
            return false;
        }
        InterfaceRequiringEntity source = (InterfaceRequiringEntity)this.getLink().eContainer();
        return PalladioComponentModelBaseItemSemanticEditPolicy.LinkConstraints.canExistSourceRole_4110(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getRequiredRoles_InterfaceRequiringEntity().remove((Object)this.getLink());
        this.getNewSource().getRequiredRoles_InterfaceRequiringEntity().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setEventGroup__SourceRole(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected SourceRole getLink() {
        return (SourceRole)this.getElementToEdit();
    }

    protected InterfaceRequiringEntity getOldSource() {
        return (InterfaceRequiringEntity)this.oldEnd;
    }

    protected InterfaceRequiringEntity getNewSource() {
        return (InterfaceRequiringEntity)this.newEnd;
    }

    protected EventGroup getOldTarget() {
        return (EventGroup)this.oldEnd;
    }

    protected EventGroup getNewTarget() {
        return (EventGroup)this.newEnd;
    }
}

