/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IHistSeriesExporter;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class ExportDoublePDF
extends Action {
    private IHistSeriesExporter viewer;

    public ExportDoublePDF(IHistSeriesExporter freeChartHistogramViewer) {
        this.setText("Copy to Clipboard as DoublePDF...");
        this.viewer = freeChartHistogramViewer;
    }

    public void run() {
        String pdf = this.exportCSV(this.viewer.getSeries());
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{pdf}, new Transfer[]{textTransfer});
        clipboard.dispose();
    }

    private String exportCSV(XYSeries series) {
        String result = "DoublePDF[";
        double lastProb = 0.0;
        double lastX = 0.0;
        for (Object item : series.getItems()) {
            XYDataItem data = (XYDataItem)item;
            result = String.valueOf(result) + "(" + (data.getX().doubleValue() - this.viewer.getHistogramWidth() / 2.0) + ";" + lastProb + ")";
            lastProb = data.getY().doubleValue();
            lastX = data.getX().doubleValue();
        }
        return String.valueOf(result) + "(" + (lastX + this.viewer.getHistogramWidth() / 2.0) + ";" + lastProb + ")]";
    }
}

