/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartChart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;

public abstract class AbstractJFreeChartWidthViewer
extends AbstractJFreeChartChart<Histogram> {
    protected String DEFAULT_X_AXIS_LABEL = "Time";
    private Logger logger;
    protected String xAxisLabel;
    protected boolean xAxisCustomSet = false;
    protected Collection<Histogram> lastData;
    protected DefaultTableXYDataset densityDataset = new DefaultTableXYDataset();

    public synchronized List<XYSeries> getAllSeries() {
        this.logger.info((Object)"Only the first series of densityDataset is returned");
        ArrayList<XYSeries> ret = new ArrayList<XYSeries>();
        int i = 0;
        while (i < this.densityDataset.getSeriesCount()) {
            ret.add(this.densityDataset.getSeries(i));
            ++i;
        }
        return ret;
    }

    protected void setCustomXAxisLabel(Histogram histogram) {
        if (this.xAxisCustomSet) {
            this.logger.info((Object)("xAxisLabel already custom-set to " + this.xAxisLabel + ", " + "passed histogram not checked for x-axis label"));
        } else if (histogram.getXAxisAnnotation() != null && histogram.getXAxisAnnotation().length() != 0) {
            this.xAxisLabel = histogram.getXAxisAnnotation();
            this.xAxisCustomSet = true;
        } else {
            this.logger.info((Object)"No custom x-axis label set, but the passed histogram's x-axis label is null or empty");
        }
    }

    public AbstractJFreeChartWidthViewer(Composite parent, int style) {
        super(parent, style);
        this.logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    @Override
    public void setData(Collection<Histogram> data) {
        this.densityDataset.removeAllSeries();
        for (Histogram h : data) {
            System.err.println("TEST jfree vis: histogram:\n" + h);
            XYSeries density = this.computeDensities(h);
            this.densityDataset.addSeries(density);
            System.err.println("TEST jfree vis: density:\n" + density);
        }
        this.initChart();
        this.setChart(this.chart);
        this.forceRedraw();
        this.lastData = data;
    }

    protected abstract XYSeries computeDensities(Histogram var1);
}

