/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.console.Activator;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class ProvCommandProvider
implements CommandProvider {
    private static final String WILDCARD_ANY = "*";
    public static final String NEW_LINE = System.getProperty("line.separator", "\n");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ProvCommandProvider(String profileId, IProfileRegistry registry) {
    }

    public void _provaddrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.print((Object)"Repository location must be provided");
            interpreter.println();
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        if (ProvisioningHelper.addMetadataRepository(repoURL) == null) {
            interpreter.println((Object)("Unable to add repository: " + repoURL));
        }
    }

    public void _provdelrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.print((Object)"Repository location must be provided");
            interpreter.println();
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        ProvisioningHelper.removeMetadataRepository(repoURL);
    }

    public void _provaddartifactrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.print((Object)"Repository location must be provided");
            interpreter.println();
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        if (ProvisioningHelper.addArtifactRepository(repoURL) == null) {
            interpreter.println((Object)("Unable to add repository: " + repoURL));
        }
    }

    public void _provdelartifactrepo(CommandInterpreter interpreter) {
        String urlString = interpreter.nextArgument();
        if (urlString == null) {
            interpreter.print((Object)"Repository location must be provided");
            interpreter.println();
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        ProvisioningHelper.removeArtifactRepository(repoURL);
    }

    public void _provinstall(CommandInterpreter interpreter) {
        String iu = interpreter.nextArgument();
        String version = interpreter.nextArgument();
        String profileId = interpreter.nextArgument();
        if (profileId == null || profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if (iu == null || version == null || profileId == null) {
            interpreter.println((Object)"Installable unit id, version, and profile Id must be provided");
            return;
        }
        IStatus s = null;
        try {
            s = ProvisioningHelper.install(iu, version, ProvisioningHelper.getProfile(profileId), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            interpreter.println((Object)"installation failed ");
            e.printStackTrace();
            return;
        }
        if (s.isOK()) {
            interpreter.println((Object)"installation complete");
        } else {
            interpreter.println((Object)("installation failed " + s.getMessage()));
        }
    }

    public void _provaddprofile(CommandInterpreter interpreter) {
        String profileId = interpreter.nextArgument();
        String location = interpreter.nextArgument();
        String flavor = interpreter.nextArgument();
        if (profileId == null || location == null || flavor == null) {
            interpreter.println((Object)"Id, location, and flavor must be provided");
            return;
        }
        String environments = interpreter.nextArgument();
        Properties props = new Properties();
        props.setProperty("org.eclipse.equinox.p2.installFolder", location);
        props.setProperty("org.eclipse.equinox.p2.flavor", flavor);
        if (environments != null) {
            props.setProperty("org.eclipse.equinox.p2.environments", environments);
        }
        try {
            ProvisioningHelper.addProfile(profileId, props);
        }
        catch (ProvisionException e) {
            interpreter.println((Object)("add profile failed " + e.getMessage()));
        }
    }

    public void _provdelprofile(CommandInterpreter interpreter) {
        String profileId = interpreter.nextArgument();
        if (profileId == null) {
            interpreter.println((Object)"Id must be provided");
            return;
        }
        ProvisioningHelper.removeProfile(profileId);
    }

    public void _provliu(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String version = this.processArgument(interpreter.nextArgument());
        URI repoURL = null;
        if (urlString != null && !urlString.equals(WILDCARD_ANY)) {
            repoURL = this.toURI(interpreter, urlString);
        }
        IInstallableUnit[] units = this.sort(ProvisioningHelper.getInstallableUnits(repoURL, (Query)new InstallableUnitQuery(id, new VersionRange(version)), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlr(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String version = this.processArgument(interpreter.nextArgument());
        if (urlString == null) {
            URI[] repositories = ProvisioningHelper.getMetadataRepositories();
            if (repositories != null) {
                int i = 0;
                while (i < repositories.length) {
                    interpreter.println((Object)repositories[i]);
                    ++i;
                }
            }
            return;
        }
        URI repoLocation = this.toURI(interpreter, urlString);
        if (repoLocation == null) {
            return;
        }
        IInstallableUnit[] units = this.sort(ProvisioningHelper.getInstallableUnits(repoLocation, (Query)new InstallableUnitQuery(id, new VersionRange(version)), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlg(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        IQueryable queryable = null;
        if (urlString == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((queryable = (IQueryable)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
                return;
            }
        } else {
            URI repoURL = this.toURI(interpreter, urlString);
            if (repoURL == null) {
                return;
            }
            queryable = ProvisioningHelper.getMetadataRepository(repoURL);
            if (queryable == null) {
                return;
            }
        }
        IUPropertyQuery query = new IUPropertyQuery("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        IInstallableUnit[] units = this.sort(queryable.query((Query)query, new Collector(), null));
        int i = 0;
        while (i < units.length) {
            this.println(interpreter, units[i]);
            ++i;
        }
    }

    public void _provlar(CommandInterpreter interpreter) {
        String urlString = this.processArgument(interpreter.nextArgument());
        if (urlString == null) {
            URI[] repositories = ProvisioningHelper.getArtifactRepositories();
            if (repositories == null) {
                return;
            }
            int i = 0;
            while (i < repositories.length) {
                interpreter.println((Object)repositories[i]);
                ++i;
            }
            return;
        }
        URI repoURL = this.toURI(interpreter, urlString);
        if (repoURL == null) {
            return;
        }
        IArtifactRepository repo = ProvisioningHelper.getArtifactRepository(repoURL);
        IArtifactKey[] keys = null;
        try {
            keys = repo != null ? repo.getArtifactKeys() : null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            interpreter.println((Object)"Repository does not support list commands.");
            return;
        }
        if (keys == null || keys.length == 0) {
            interpreter.println((Object)"Repository has no artifacts");
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFileArtifactRepository fileRepo = (IFileArtifactRepository)repo.getAdapter((Class)clazz);
        int i = 0;
        while (i < keys.length) {
            IArtifactDescriptor[] descriptors = repo.getArtifactDescriptors(keys[i]);
            int j = 0;
            while (j < descriptors.length) {
                IArtifactDescriptor descriptor = descriptors[j];
                File location = null;
                if (fileRepo != null) {
                    location = fileRepo.getArtifactFile(descriptor);
                }
                this.println(interpreter, keys[i], location);
                ++j;
            }
            ++i;
        }
    }

    private URI toURI(CommandInterpreter interpreter, String urlString) {
        try {
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            interpreter.print((Object)e.getMessage());
            interpreter.println();
            return null;
        }
    }

    private String processArgument(String arg) {
        if (arg == null || arg.equals(WILDCARD_ANY)) {
            return null;
        }
        return arg;
    }

    public void _provlp(CommandInterpreter interpreter) {
        String profileId = this.processArgument(interpreter.nextArgument());
        String id = this.processArgument(interpreter.nextArgument());
        String range = this.processArgument(interpreter.nextArgument());
        if (profileId == null) {
            IProfile[] profiles = ProvisioningHelper.getProfiles();
            int i = 0;
            while (i < profiles.length) {
                interpreter.println((Object)profiles[i].getProfileId());
                ++i;
            }
            return;
        }
        IProfile target = null;
        if (profileId.equals("this")) {
            profileId = "_SELF_";
        }
        if ((target = ProvisioningHelper.getProfile(profileId)) == null) {
            return;
        }
        IInstallableUnit[] result = this.sort(target.query((Query)new InstallableUnitQuery(id, new VersionRange(range)), new Collector(), null));
        int i = 0;
        while (i < result.length) {
            interpreter.println((Object)result[i]);
            ++i;
        }
    }

    private IInstallableUnit[] sort(Collector collector) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IInstallableUnit[] units = (IInstallableUnit[])collector.toArray((Class)clazz);
        Arrays.sort(units, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        return units;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append(NEW_LINE);
        help.append("---");
        help.append("Provisioning Commands");
        help.append("---");
        help.append(NEW_LINE);
        help.append("\tprovlr [<repository URL> <iu id | *> <version range | *>]   - Lists all metadata repositories, or the contents of a given metadata repository");
        help.append(NEW_LINE);
        help.append("\tprovlar [<repository URL>] - Lists all artifact repositories, or the contents of a given artifact repository");
        help.append(NEW_LINE);
        help.append("\tprovliu [<repository URL | *> <iu id | *> <version range | *>] - Lists the IUs that match the pattern in the given repo.  * matches all");
        help.append(NEW_LINE);
        help.append("\tprovlp [<profile id | *> - Lists all profiles, or the contents of the profile at the given profile");
        help.append(NEW_LINE);
        help.append("\tprovlg [<repository URL> <iu id | *> <version range | *>] - Lists all IUs with group capabilities in the given repo or in all repos if the URL is omitted");
        help.append(NEW_LINE);
        help.append("\tprovinstall <InstallableUnit> <version> <profileId> - Provisions an IU to the profile with the give id");
        help.append(NEW_LINE);
        help.append("\tprovaddrepo <repository URL> - Adds a metadata repository");
        help.append(NEW_LINE);
        help.append("\tprovaddartifactrepo <repository URL> - Adds an artifact repository");
        help.append(NEW_LINE);
        help.append("\tprovaddprofile <profileId> <location> <flavor> - Adds a profile with the given id, location and flavor");
        help.append(NEW_LINE);
        return help.toString();
    }

    public void print(CommandInterpreter interpreter, IInstallableUnit unit) {
        interpreter.print((Object)(String.valueOf(unit.getId()) + ' ' + unit.getVersion()));
    }

    public void println(CommandInterpreter interpreter, IInstallableUnit unit) {
        this.print(interpreter, unit);
        interpreter.println();
    }

    private void println(CommandInterpreter interpreter, IArtifactKey artifactKey, File location) {
        interpreter.print((Object)(String.valueOf(artifactKey.toString()) + ' ' + location));
        interpreter.println();
    }
}

