/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.resultmodel.helpers;

import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.AnalysisResult;
import eu.qimpress.resultmodel.ResultObject;
import eu.qimpress.resultmodel.ResultRepository;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;

public abstract class ResultRepositoryHelper {
    public static Collection<ResultObject> getObjectsByTimestampPeriod(ResultRepository repo, Date dateFrom, Date dateTo) {
        LinkedList<ResultObject> listFound = new LinkedList<ResultObject>();
        for (AlternativeEvaluation alternativeEvaluation : repo.getAnalysisRuns()) {
            if (alternativeEvaluation.getRunDate().compareTo(dateFrom) < 0 || alternativeEvaluation.getRunDate().compareTo(dateTo) > 0) continue;
            for (AnalysisResult analysisResult : alternativeEvaluation.getAnalysisResults()) {
                for (EObject resultObject : analysisResult.eContents()) {
                    listFound.add((ResultObject)resultObject);
                }
            }
        }
        return listFound;
    }

    public static Collection<ResultObject> getObjectsByTimestampPeriod(ResultRepository repo, int[] dateFrom, int[] dateTo) {
        Calendar calFrom = ResultRepositoryHelper.createCalendarFromArray(dateFrom, true);
        Calendar calTo = ResultRepositoryHelper.createCalendarFromArray(dateTo, false);
        return ResultRepositoryHelper.getObjectsByTimestampPeriod(repo, calFrom.getTime(), calTo.getTime());
    }

    public static Collection<ResultObject> getAllResultObjects(ResultRepository repo) {
        LinkedList<ResultObject> out = new LinkedList<ResultObject>();
        ResultRepositoryHelper.recursiveGetAllResultObjects(repo, out);
        return out;
    }

    private static Calendar createCalendarFromArray(int[] arr, boolean isBegin) {
        Calendar cal = Calendar.getInstance();
        if (isBegin) {
            cal.set(0, 0, 1, 0, 0, 0);
        } else {
            cal.set(0, 11, 31, 23, 59, 59);
        }
        switch (arr.length) {
            case 6: {
                cal.set(13, arr[5]);
            }
            case 5: {
                cal.set(12, arr[4]);
            }
            case 4: {
                cal.set(11, arr[3]);
            }
            case 3: {
                cal.set(5, arr[2]);
            }
            case 2: {
                cal.set(2, arr[1] - 1);
            }
            case 1: {
                cal.set(1, arr[0]);
            }
        }
        return cal;
    }

    private static void recursiveGetAllResultObjects(EObject root, Collection<ResultObject> out) {
        for (EObject obj : root.eContents()) {
            if (obj instanceof ResultObject) {
                out.add((ResultObject)obj);
            }
            ResultRepositoryHelper.recursiveGetAllResultObjects(obj, out);
        }
    }
}

