/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.part;

import de.uka.ipd.sdq.pcm.core.composition.CompositionPackage;
import de.uka.ipd.sdq.pcm.core.entity.ComposedProvidingRequiringEntity;
import de.uka.ipd.sdq.pcm.core.entity.EntityPackage;
import de.uka.ipd.sdq.pcm.gmf.composite.part.PalladioComponentModelComposedStructureDiagramEditorPlugin;
import de.uka.ipd.sdq.pcm.repository.RepositoryPackage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class PalladioComponentModelVisualIDRegistry {
    private static final String DEBUG_KEY = "de.uka.ipd.sdq.pcm.gmf.composite/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("CompositeModel".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return PalladioComponentModelVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                PalladioComponentModelComposedStructureDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (EntityPackage.eINSTANCE.getComposedProvidingRequiringEntity().isSuperTypeOf(domainElement.eClass()) && PalladioComponentModelVisualIDRegistry.isDiagram((ComposedProvidingRequiringEntity)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"CompositeModel".equals(containerModelID)) {
            return -1;
        }
        if ("CompositeModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2002: {
                if (RepositoryPackage.eINSTANCE.getOperationProvidedRole().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (!RepositoryPackage.eINSTANCE.getOperationRequiredRole().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 3006: {
                if (RepositoryPackage.eINSTANCE.getOperationProvidedRole().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (RepositoryPackage.eINSTANCE.getOperationRequiredRole().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (RepositoryPackage.eINSTANCE.getSourceRole().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!RepositoryPackage.eINSTANCE.getSinkRole().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7002: {
                if (!CompositionPackage.eINSTANCE.getAssemblyContext().isSuperTypeOf(domainElement.eClass())) break;
                return 3006;
            }
            case 1000: {
                if (!EntityPackage.eINSTANCE.getComposedProvidingRequiringEntity().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"CompositeModel".equals(containerModelID)) {
            return false;
        }
        if ("CompositeModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2002: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5016 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5013 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3006 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (CompositionPackage.eINSTANCE.getAssemblyConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (CompositionPackage.eINSTANCE.getAssemblyEventConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (CompositionPackage.eINSTANCE.getRequiredDelegationConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        if (CompositionPackage.eINSTANCE.getProvidedDelegationConnector().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        return -1;
    }

    private static boolean isDiagram(ComposedProvidingRequiringEntity element) {
        return true;
    }
}

